/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.compute;

import com.barrybecker4.simulation.liquid.model.Cell;
import com.barrybecker4.simulation.liquid.model.CellDimensions;
import com.barrybecker4.simulation.liquid.model.CellNeighbors;
import java.io.Serializable;
import javax.vecmath.Vector2d;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0002\u0005\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u001by\u0002B\u0002\u0014\u0001A\u00035\u0001\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003L\u0001\u0011%A\nC\u0003X\u0001\u0011\u0005\u0001LA\bWK2|7-\u001b;z+B$\u0017\r^3s\u0015\tI!\"A\u0004d_6\u0004X\u000f^3\u000b\u0005-a\u0011A\u00027jcVLGM\u0003\u0002\u000e\u001d\u0005Q1/[7vY\u0006$\u0018n\u001c8\u000b\u0005=\u0001\u0012\u0001\u00042beJL(-Z2lKJ$$\"A\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0011\u0005!A-[7t+\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u000b\u0003\u0015iw\u000eZ3m\u0013\t)#E\u0001\bDK2dG)[7f]NLwN\\:\u0002\u000b\u0011LWn\u001d\u0011\u0002+U\u0004H-\u0019;f)&dG-\u001a,fY>\u001c\u0017\u000e^5fgRA\u0011\u0006L\u00197qiz\u0014\n\u0005\u0002\u0016U%\u00111F\u0006\u0002\u0005+:LG\u000fC\u0003.\t\u0001\u0007a&\u0001\u0003dK2d\u0007CA\u00110\u0013\t\u0001$E\u0001\u0003DK2d\u0007\"\u0002\u001a\u0005\u0001\u0004\u0019\u0014!\u00038fS\u001eD'm\u001c:t!\t\tC'\u0003\u00026E\ti1)\u001a7m\u001d\u0016Lw\r\u001b2peNDQa\u000e\u0003A\u00029\nqa\u0019-nce\u0003\u0018\u0007C\u0003:\t\u0001\u0007a&A\u0004d1B\f\u0014,\\\u0019\t\u000bm\"\u0001\u0019\u0001\u001f\u0002\u0005\u0011$\bCA\u000b>\u0013\tqdC\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0001\u0012\u0001\r!Q\u0001\u0006M>\u00148-\u001a\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bqA^3d[\u0006$\bNC\u0001G\u0003\u0015Q\u0017M^1y\u0013\tA5I\u0001\u0005WK\u000e$xN\u001d\u001ae\u0011\u0015QE\u00011\u0001=\u0003%1\u0018n]2pg&$\u00180\u0001\u0006dC2\u001cW\u000bV5mI\u0016$\u0002\"K'O\u001fF\u001bFK\u0016\u0005\u0006[\u0015\u0001\rA\f\u0005\u0006e\u0015\u0001\ra\r\u0005\u0006!\u0016\u0001\r\u0001P\u0001\fY><XM\u001d*jO\"$h\u000bC\u0003S\u000b\u0001\u0007A(A\u0003ja*\u0004(\u0007C\u0003<\u000b\u0001\u0007A\bC\u0003V\u000b\u0001\u0007A(\u0001\u0004g_J\u001cW\r\u0017\u0005\u0006\u0015\u0016\u0001\r\u0001P\u0001\u000bG\u0006d7M\u0016+jY\u0012,G\u0003C\u0015Z5nkflX1\t\u000b52\u0001\u0019\u0001\u0018\t\u000bI2\u0001\u0019A\u001a\t\u000bq3\u0001\u0019\u0001\u001f\u0002\u0015U\u0004\b/\u001a:MK\u001a$X\u000bC\u0003S\r\u0001\u0007A\bC\u0003<\r\u0001\u0007A\bC\u0003a\r\u0001\u0007A(\u0001\u0004g_J\u001cW-\u0017\u0005\u0006\u0015\u001a\u0001\r\u0001\u0010")
public class VelocityUpdater {
    private final CellDimensions dims = new CellDimensions();

    private final CellDimensions dims() {
        return this.dims;
    }

    public void updateTildeVelocities(Cell cell, CellNeighbors neighbors, Cell cXm1Yp1, Cell cXp1Ym1, double dt, Vector2d force, double viscosity) {
        if (!cell.isFull()) {
            cell.passVelocityThrough();
            return;
        }
        Predef$.MODULE$.assert(dt > 1.0E-7, (Function0 & Serializable)() -> "dt got too small");
        double u_ipjp = (cell.getU() + neighbors.getTop().getU()) / 2.0;
        double v_ipjp = (cell.getV() + neighbors.getRight().getV()) / 2.0;
        double ipjp2 = u_ipjp * v_ipjp;
        this.calcUTilde(cell, neighbors, cXp1Ym1.getV(), ipjp2, dt, force.x, viscosity);
        this.calcVTilde(cell, neighbors, cXm1Yp1.getU(), ipjp2, dt, force.y, viscosity);
    }

    private void calcUTilde(Cell cell, CellNeighbors neighbors, double lowerRightV, double ipjp2, double dt, double forceX, double viscosity) {
        block0: {
            double u_i = (cell.getU() + neighbors.getLeft().getU()) / 2.0;
            double u_ip1 = (neighbors.getRight().getU() + cell.getU()) / 2.0;
            double u_ipjm = (cell.getU() + neighbors.getBottom().getU()) / 2.0;
            double v_ipjm = (neighbors.getBottom().getV() + lowerRightV) / 2.0;
            if (neighbors.getRight().isObstacle()) break block0;
            double xNume = u_i * u_i - u_ip1 * u_ip1;
            double yNume = u_ipjm * v_ipjm - ipjp2;
            double v1 = (neighbors.getRight().getU() - (double)2 * cell.getU() + neighbors.getLeft().getU()) / this.dims().dxSq();
            double v2 = (neighbors.getTop().getU() - (double)2 * cell.getU() + neighbors.getBottom().getU()) / this.dims().dySq();
            double pf = xNume / this.dims().dx() + yNume / this.dims().dy() + forceX + (cell.getPressure() + neighbors.getLeft().getPressure()) / this.dims().dx() + viscosity * (v1 + v2);
            double newu = cell.getU() + dt * pf;
            cell.setNewU(newu);
        }
    }

    public void calcVTilde(Cell cell, CellNeighbors neighbors, double upperLeftU, double ipjp2, double dt, double forceY, double viscosity) {
        block0: {
            double u_imjp = (neighbors.getLeft().getU() + upperLeftU) / 2.0;
            double v_imjp = (cell.getV() + neighbors.getBottom().getV()) / 2.0;
            double v_j = (neighbors.getBottom().getV() + cell.getV()) / 2.0;
            double v_jp1 = (cell.getV() + neighbors.getTop().getV()) / 2.0;
            if (neighbors.getTop().isObstacle()) break block0;
            double xNume = u_imjp * v_imjp - ipjp2;
            double yNume = v_j * v_j - v_jp1 * v_jp1;
            double v1 = (neighbors.getRight().getV() - (double)2 * cell.getV() + neighbors.getLeft().getV()) / this.dims().dxSq();
            double v2 = (neighbors.getTop().getV() - (double)2 * cell.getV() + neighbors.getBottom().getV()) / this.dims().dySq();
            double pf = xNume / this.dims().dx() + yNume / this.dims().dy() + forceY + (cell.getPressure() - neighbors.getBottom().getPressure()) / this.dims().dy() + viscosity * (v1 + v2);
            double newv = cell.getV() + dt * pf;
            cell.setNewV(newv);
        }
    }
}

