/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.model;

import com.barrybecker4.simulation.common.PhysicsConstants$;
import com.barrybecker4.simulation.liquid.model.CellNeighbors;
import com.barrybecker4.simulation.liquid.model.CellStatus$;
import com.barrybecker4.simulation.liquid.model.CellVelocity;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055e\u0001\u0002\u0015*\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001A\u0002\u0013%\u0001\tC\u0004E\u0001\u0001\u0007I\u0011B#\t\r-\u0003\u0001\u0015)\u0003B\u0011\u001da\u0005A1A\u0005\n5Ca!\u0015\u0001!\u0002\u0013q\u0005b\u0002*\u0001\u0001\u0004%Ia\u0015\u0005\b/\u0002\u0001\r\u0011\"\u0003Y\u0011\u0019Q\u0006\u0001)Q\u0005)\"91\f\u0001a\u0001\n\u0013a\u0006bB3\u0001\u0001\u0004%IA\u001a\u0005\u0007Q\u0002\u0001\u000b\u0015B/\t\u000b%\u0004A\u0011\u00016\t\u000b-\u0004A\u0011\u00017\t\u000b=\u0004A\u0011\u0001!\t\rA\u0004A\u0011A\u0015r\u0011\u0019!\b\u0001\"\u0001*k\")\u0001\u0010\u0001C\u0001s\")A\u0010\u0001C\u0001{\"1q\u0010\u0001C\u0001\u0003\u0003Aa!!\u0002\u0001\t\u0003\u0001\u0005BBA\u0004\u0001\u0011\u0005\u0001\tC\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\u0007\u0003G\u0001A\u0011\u00016\t\r\u0005\u0015\u0002\u0001\"\u0001k\u0011\u0019\t9\u0003\u0001C\u0001U\"1\u0011\u0011\u0006\u0001\u0005\u0002MCq!a\u000b\u0001\t\u0003\ti\u0003C\u0004\u0002T\u0001!\t!!\u0016\t\u000f\u0005u\u0003\u0001\"\u0001\u0002V!9\u0011q\f\u0001\u0005\u0002\u0005U\u0003bBA1\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003G\u0002A\u0011AA+\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002z\u0001!\t%a\u001f\u0003\t\r+G\u000e\u001c\u0006\u0003U-\nQ!\\8eK2T!\u0001L\u0017\u0002\r1L\u0017/^5e\u0015\tqs&\u0001\u0006tS6,H.\u0019;j_:T!\u0001M\u0019\u0002\u0019\t\f'O]=cK\u000e\\WM\u001d\u001b\u000b\u0003I\n1aY8n\u0007\u0001\u0019\"\u0001A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\b\u0005\u0002?\u00015\t\u0011&\u0001\u0005qe\u0016\u001c8/\u001e:f+\u0005\t\u0005C\u0001\u001cC\u0013\t\u0019uG\u0001\u0004E_V\u0014G.Z\u0001\raJ,7o];sK~#S-\u001d\u000b\u0003\r&\u0003\"AN$\n\u0005!;$\u0001B+oSRDqAS\u0002\u0002\u0002\u0003\u0007\u0011)A\u0002yIE\n\u0011\u0002\u001d:fgN,(/\u001a\u0011\u0002\u0011Y,Gn\\2jif,\u0012A\u0014\t\u0003}=K!\u0001U\u0015\u0003\u0019\r+G\u000e\u001c,fY>\u001c\u0017\u000e^=\u0002\u0013Y,Gn\\2jif\u0004\u0013\u0001\u00048v[B\u000b'\u000f^5dY\u0016\u001cX#\u0001+\u0011\u0005Y*\u0016B\u0001,8\u0005\rIe\u000e^\u0001\u0011]Vl\u0007+\u0019:uS\u000edWm]0%KF$\"AR-\t\u000f)C\u0011\u0011!a\u0001)\u0006ia.^7QCJ$\u0018n\u00197fg\u0002\naa\u001d;biV\u001cX#A/\u0011\u0005y\u000bgB\u0001 `\u0013\t\u0001\u0017&\u0001\u0006DK2d7\u000b^1ukNL!AY2\u0003\u000bY\u000bG.^3\n\u0005\u0011<$aC#ok6,'/\u0019;j_:\f!b\u001d;biV\u001cx\fJ3r)\t1u\rC\u0004K\u0017\u0005\u0005\t\u0019A/\u0002\u000fM$\u0018\r^;tA\u0005!1o^1q)\u00051\u0015aC:fiB\u0013Xm]:ve\u0016$\"AR7\t\u000b9t\u0001\u0019A!\u0002\u0003A\f1bZ3u!J,7o];sK\u0006Y\u0011N\\5uS\u0006d\u0017N_3V)\t1%\u000fC\u0003t!\u0001\u0007\u0011)A\u0001v\u0003-Ig.\u001b;jC2L'0\u001a,\u0015\u0005\u00193\b\"B<\u0012\u0001\u0004\t\u0015!\u0001<\u0002%%t\u0017\u000e^5bY&TXMV3m_\u000eLG/\u001f\u000b\u0004\rj\\\b\"B:\u0013\u0001\u0004\t\u0005\"B<\u0013\u0001\u0004\t\u0015\u0001B:fiV#\"A\u0012@\t\u000bM\u001c\u0002\u0019A!\u0002\tM,GO\u0016\u000b\u0004\r\u0006\r\u0001\"B<\u0015\u0001\u0004\t\u0015\u0001B4fiV\u000bAaZ3u-\u0006Q\u0011N\\2sK6,g\u000e^+\u0015\u0007\u0019\u000bi\u0001\u0003\u0004\u0002\u0010]\u0001\r!Q\u0001\u0004S:\u001c\u0017AC5oGJ,W.\u001a8u-R\u0019a)!\u0006\t\r\u0005=\u0001\u00041\u0001B\u0003\u001d\u0019X\r\u001e(foV#2ARA\u000e\u0011\u0015\u0019\u0018\u00041\u0001B\u0003\u001d\u0019X\r\u001e(foZ#2ARA\u0011\u0011\u00159(\u00041\u0001B\u0003M\u0001\u0018m]:WK2|7-\u001b;z)\"\u0014x.^4i\u00031Ign\u0019)beRL7\r\\3t\u00031!Wm\u0019)beRL7\r\\3t\u0003=9W\r\u001e(v[B\u000b'\u000f^5dY\u0016\u001c\u0018!C4fiN#\u0018\r^;t+\t\ty\u0003\u0005\u0003\u00022\u00055cbAA\u001a?:!\u0011QGA&\u001d\u0011\t9$!\u0013\u000f\t\u0005e\u0012q\t\b\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\rSBAA \u0015\r\t\teM\u0001\u0007yI|w\u000e\u001e \n\u0003IJ!\u0001M\u0019\n\u00059z\u0013B\u0001\u0017.\u0013\tQ3&\u0003\u0003\u0002P\u0005E#AC\"fY2\u001cF/\u0019;vg*\u0011\u0001-K\u0001\nSN\u001cVO\u001d4bG\u0016,\"!a\u0016\u0011\u0007Y\nI&C\u0002\u0002\\]\u0012qAQ8pY\u0016\fg.A\u0004jg\u0016k\u0007\u000f^=\u0002\r%\u001ch)\u001e7m\u0003)I7o\u00142ti\u0006\u001cG.Z\u0001\u000bSNL5o\u001c7bi\u0016$\u0017!C:fiN#\u0018\r^;t)\r1\u0015\u0011\u000e\u0005\u00077\u0016\u0002\r!a\f\u0002\u0019U\u0004H-\u0019;f'R\fG/^:\u0015\u0007\u0019\u000by\u0007C\u0004\u0002r\u0019\u0002\r!a\u001d\u0002\u00139,\u0017n\u001a5c_J\u001c\bc\u0001 \u0002v%\u0019\u0011qO\u0015\u0003\u001b\r+G\u000e\u001c(fS\u001eD'm\u001c:t\u0003!!xn\u0015;sS:<GCAA?!\u0011\ty(a\"\u000f\t\u0005\u0005\u00151\u0011\t\u0004\u0003{9\u0014bAACo\u00051\u0001K]3eK\u001aLA!!#\u0002\f\n11\u000b\u001e:j]\u001eT1!!\"8\u0001")
public class Cell {
    private double pressure = PhysicsConstants$.MODULE$.ATMOSPHERIC_PRESSURE();
    private final CellVelocity velocity = new CellVelocity();
    private int numParticles = 0;
    private Enumeration.Value status = CellStatus$.MODULE$.EMPTY();

    private double pressure() {
        return this.pressure;
    }

    private void pressure_$eq(double x$1) {
        this.pressure = x$1;
    }

    private CellVelocity velocity() {
        return this.velocity;
    }

    private int numParticles() {
        return this.numParticles;
    }

    private void numParticles_$eq(int x$1) {
        this.numParticles = x$1;
    }

    private Enumeration.Value status() {
        return this.status;
    }

    private void status_$eq(Enumeration.Value x$1) {
        this.status = x$1;
    }

    public void swap() {
        this.velocity().step();
    }

    public void setPressure(double p) {
        this.pressure_$eq(p);
    }

    public double getPressure() {
        return this.pressure();
    }

    public void initializeU(double u) {
        this.velocity().initializeU(u);
    }

    public void initializeV(double v) {
        this.velocity().initializeV(v);
    }

    public void initializeVelocity(double u, double v) {
        this.velocity().initialize(u, v);
    }

    public void setU(double u) {
        this.velocity().setCurrentU(u);
    }

    public void setV(double v) {
        this.velocity().setCurrentV(v);
    }

    public double getU() {
        return this.velocity().getU();
    }

    public double getV() {
        return this.velocity().getV();
    }

    public void incrementU(double inc) {
        this.velocity().incrementU(inc);
    }

    public void incrementV(double inc) {
        this.velocity().incrementV(inc);
    }

    public void setNewU(double u) {
        this.velocity().setNewU(u);
    }

    public void setNewV(double v) {
        this.velocity().setNewV(v);
    }

    public void passVelocityThrough() {
        this.velocity().passThrough();
    }

    public void incParticles() {
        this.numParticles_$eq(this.numParticles() + 1);
    }

    public void decParticles() {
        this.numParticles_$eq(this.numParticles() - 1);
        Predef$.MODULE$.assert(this.numParticles() >= 0);
    }

    public int getNumParticles() {
        return this.numParticles();
    }

    public Enumeration.Value getStatus() {
        return this.status();
    }

    public boolean isSurface() {
        return this.status() == CellStatus$.MODULE$.SURFACE();
    }

    public boolean isEmpty() {
        return this.status() == CellStatus$.MODULE$.EMPTY();
    }

    public boolean isFull() {
        return this.status() == CellStatus$.MODULE$.FULL();
    }

    public boolean isObstacle() {
        return this.status() == CellStatus$.MODULE$.OBSTACLE();
    }

    public boolean isIsolated() {
        return this.status() == CellStatus$.MODULE$.ISOLATED();
    }

    public void setStatus(Enumeration.Value status) {
        this.status_$eq(status);
    }

    public void updateStatus(CellNeighbors neighbors) {
        Predef$.MODULE$.assert(this.numParticles() >= 0, (Function0 & Serializable)() -> "num particles less than 0.");
        if (this.status() != CellStatus$.MODULE$.OBSTACLE()) {
            if (this.numParticles() == 0) {
                this.status_$eq(CellStatus$.MODULE$.EMPTY());
            } else if (neighbors.allHaveParticles()) {
                this.status_$eq(CellStatus$.MODULE$.FULL());
            } else if (neighbors.noneHaveParticles()) {
                this.status_$eq(CellStatus$.MODULE$.ISOLATED());
            } else {
                this.status_$eq(CellStatus$.MODULE$.SURFACE());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Cell:");
        sb.append((Object)this.status());
        sb.append(" num particles=").append(this.numParticles());
        sb.append(" pressure=").append(this.pressure());
        sb.append(" ").append((Object)this.velocity());
        return sb.toString();
    }
}

