/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.model;

import com.barrybecker4.simulation.liquid.model.Cell;
import com.barrybecker4.simulation.liquid.model.CellNeighbors;
import com.barrybecker4.simulation.liquid.model.CellStatus$;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.vecmath.Vector2d;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\f\u0019\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0004%\ta\u000b\u0005\t_\u0001\u0011\t\u0019!C\u0001a!Aa\u0007\u0001B\u0001B\u0003&A\u0006\u0003\u00058\u0001\t\u0005\r\u0011\"\u0001,\u0011!A\u0004A!a\u0001\n\u0003I\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0017\t\u000bq\u0002A\u0011A\u001f\t\u000f\t\u0003\u0001\u0019!C\u0005\u0007\"91\n\u0001a\u0001\n\u0013a\u0005B\u0002(\u0001A\u0003&A\tC\u0004P\u0001\t\u0007I\u0011\u0002)\t\re\u0003\u0001\u0015!\u0003R\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u00159\u0007\u0001\"\u0001,\u0011\u0015A\u0007\u0001\"\u0001,\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u00159\b\u0001\"\u0001y\u0011\u0015I\b\u0001\"\u0001y\u0011\u0015Q\b\u0001\"\u0001y\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'\u0011Aa\u0012:jI*\u0011\u0011DG\u0001\u0006[>$W\r\u001c\u0006\u00037q\ta\u0001\\5rk&$'BA\u000f\u001f\u0003)\u0019\u0018.\\;mCRLwN\u001c\u0006\u0003?\u0001\nABY1sef\u0014WmY6feRR\u0011!I\u0001\u0004G>l7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017\u0001\u0002=ES6,\u0012\u0001\f\t\u0003K5J!A\f\u0014\u0003\u0007%sG/\u0001\u0005y\t&lw\fJ3r)\t\tD\u0007\u0005\u0002&e%\u00111G\n\u0002\u0005+:LG\u000fC\u00046\u0005\u0005\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0013'A\u0003y\t&l\u0007%\u0001\u0003z\t&l\u0017\u0001C=ES6|F%Z9\u0015\u0005ER\u0004bB\u001b\u0006\u0003\u0003\u0005\r\u0001L\u0001\u0006s\u0012KW\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007y\u0002\u0015\t\u0005\u0002@\u00015\t\u0001\u0004C\u0003+\u000f\u0001\u0007A\u0006C\u00038\u000f\u0001\u0007A&\u0001\u0003he&$W#\u0001#\u0011\u0007\u0015*u)\u0003\u0002GM\t)\u0011I\u001d:bsB\u0019Q%\u0012%\u0011\u0005}J\u0015B\u0001&\u0019\u0005\u0011\u0019U\r\u001c7\u0002\u0011\u001d\u0014\u0018\u000eZ0%KF$\"!M'\t\u000fUJ\u0011\u0011!a\u0001\t\u0006)qM]5eA\u0005Iam\u001c:nCR$XM]\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005i\u0016DHOC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&!\u0004#fG&l\u0017\r\u001c$pe6\fG/\u0001\u0006g_Jl\u0017\r\u001e;fe\u0002\nqaZ3u\u0007\u0016dG\u000eF\u0002I9zCQ!X\u0007A\u00021\n\u0011!\u001b\u0005\u0006?6\u0001\r\u0001L\u0001\u0002U\u0006aq-\u001a;OK&<\u0007NY8sgR\u0019!-\u001a4\u0011\u0005}\u001a\u0017B\u00013\u0019\u00055\u0019U\r\u001c7OK&<\u0007NY8sg\")QL\u0004a\u0001Y!)qL\u0004a\u0001Y\u0005iq-\u001a;Y\t&lWM\\:j_:\fQbZ3u3\u0012KW.\u001a8tS>t\u0017aC:fiZ+Gn\\2jif$B!M6m[\")Q,\u0005a\u0001Y!)q,\u0005a\u0001Y!)a.\u0005a\u0001_\u0006Aa/\u001a7pG&$\u0018\u0010\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u00069a/Z2nCRD'\"\u0001;\u0002\u000b)\fg/\u0019=\n\u0005Y\f(\u0001\u0003,fGR|'O\r3\u0002!U\u0004H-\u0019;f\u0007\u0016dGn\u0015;biV\u001cH#A\u0019\u0002\u001bM,GOQ8v]\u0012\f'/[3t\u0003Y\u0019X\r\u001e\"pk:$\u0017M]=D_:\u001cHO]1j]R\u001c\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003u\u00042A`A\u0006\u001d\ry\u0018q\u0001\t\u0004\u0003\u00031SBAA\u0002\u0015\r\t)AI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%a%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u00131\u0013A\u00024pe6\fG\u000fF\u0002~\u0003+Aq!a\u0006\u0017\u0001\u0004\tI\"A\u0002ok6\u00042!JA\u000e\u0013\r\tiB\n\u0002\u0007\t>,(\r\\3")
public class Grid {
    private int xDim;
    private int yDim;
    private Cell[][] grid;
    private final DecimalFormat formatter;

    public int xDim() {
        return this.xDim;
    }

    public void xDim_$eq(int x$1) {
        this.xDim = x$1;
    }

    public int yDim() {
        return this.yDim;
    }

    public void yDim_$eq(int x$1) {
        this.yDim = x$1;
    }

    private Cell[][] grid() {
        return this.grid;
    }

    private void grid_$eq(Cell[][] x$1) {
        this.grid = x$1;
    }

    private DecimalFormat formatter() {
        return this.formatter;
    }

    public Cell getCell(int i, int j) {
        return this.grid()[i][j];
    }

    public CellNeighbors getNeighbors(int i, int j) {
        return new CellNeighbors(this.grid()[i + 1][j], this.grid()[i - 1][j], this.grid()[i][j + 1], this.grid()[i][j - 1]);
    }

    public int getXDimension() {
        return this.xDim();
    }

    public int getYDimension() {
        return this.yDim();
    }

    public void setVelocity(int i, int j, Vector2d velocity) {
        this.grid()[i][j].initializeU(velocity.x);
        this.grid()[i][j].initializeV(velocity.y);
    }

    public void updateCellStatus() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.yDim() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.xDim() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.grid()[i][j].updateStatus(this.getNeighbors(i, j))));
    }

    public void setBoundaries() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.yDim()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            this.grid()[0][j].setStatus(CellStatus$.MODULE$.OBSTACLE());
            this.grid()[this.xDim() - 1][j].setStatus(CellStatus$.MODULE$.OBSTACLE());
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.xDim()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.grid()[i][0].setStatus(CellStatus$.MODULE$.OBSTACLE());
            this.grid()[i][this.yDim() - 1].setStatus(CellStatus$.MODULE$.OBSTACLE());
        });
    }

    public void setBoundaryConstraints() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.yDim()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            Cell n = this.grid()[1][j];
            this.grid()[0][j].setPressure(n.getPressure());
            this.grid()[0][j].initializeVelocity(0.0, n.getV());
            n = this.grid()[this.xDim() - 2][j];
            this.grid()[this.xDim() - 1][j].setPressure(n.getPressure());
            this.grid()[this.xDim() - 1][j].initializeVelocity(0.0, n.getV());
            this.grid()[this.xDim() - 2][j].initializeU(0.0);
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.xDim()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Cell n = this.grid()[i][1];
            this.grid()[i][0].setPressure(n.getPressure());
            this.grid()[i][0].initializeVelocity(n.getU(), 0.0);
            n = this.grid()[i][this.yDim() - 2];
            this.grid()[i][this.yDim() - 1].setPressure(n.getPressure());
            this.grid()[i][this.yDim() - 1].initializeVelocity(n.getU(), 0.0);
            this.grid()[i][this.yDim() - 2].initializeV(0.0);
        });
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.yDim() - 1), 0).by(-1).foreach((Function1 & Serializable)j -> Grid.$anonfun$toString$1(this, bldr, BoxesRunTime.unboxToInt((Object)j)));
        return bldr.toString();
    }

    private String format(double num) {
        StringBuilder fmtNum = new StringBuilder(this.formatter().format(num));
        while (fmtNum.length() < 5) {
            fmtNum.append(' ');
        }
        return fmtNum.toString();
    }

    public static final /* synthetic */ StringBuilder $anonfun$toString$2(Grid $this, int j$3, StringBuilder bldr$1, int i) {
        Cell cell = $this.getCell(i, j$3);
        bldr$1.append(new java.lang.StringBuilder(6).append("    V=").append($this.format(cell.getV())).toString());
        return bldr$1.append("    |");
    }

    public static final /* synthetic */ StringBuilder $anonfun$toString$3(Grid $this, int j$3, StringBuilder bldr$1, int i) {
        Cell cell = $this.getCell(i, j$3);
        bldr$1.append(new java.lang.StringBuilder(2).append("P=").append($this.format(cell.getPressure())).toString());
        bldr$1.append(new java.lang.StringBuilder(3).append(" U=").append($this.format(cell.getU())).toString());
        return bldr$1.append("|");
    }

    public static final /* synthetic */ StringBuilder $anonfun$toString$1(Grid $this, StringBuilder bldr$1, int j) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.xDim()).foreach((Function1 & Serializable)i -> Grid.$anonfun$toString$2($this, j, bldr$1, BoxesRunTime.unboxToInt((Object)i)));
        bldr$1.append("\n");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.xDim()).foreach((Function1 & Serializable)i -> Grid.$anonfun$toString$3($this, j, bldr$1, BoxesRunTime.unboxToInt((Object)i)));
        bldr$1.append("\n");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.xDim()).foreach((Function1 & Serializable)i -> bldr$1.append("----------------"));
        return bldr$1.append("\n");
    }

    public Grid(int xDim, int yDim) {
        this.xDim = xDim;
        this.yDim = yDim;
        this.grid = (Cell[][])Array$.MODULE$.ofDim(this.xDim(), this.yDim(), ClassTag$.MODULE$.apply(Cell.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.yDim()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.xDim()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            $this.grid()[i][j$1] = new Cell();
        }));
        this.formatter = new DecimalFormat("###0.###");
    }
}

