/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.model;

import com.barrybecker4.simulation.liquid.Logger$;
import com.barrybecker4.simulation.liquid.compute.GridUpdater;
import com.barrybecker4.simulation.liquid.config.Conditions;
import com.barrybecker4.simulation.liquid.config.Region;
import com.barrybecker4.simulation.liquid.config.Source;
import com.barrybecker4.simulation.liquid.model.Grid;
import com.barrybecker4.simulation.liquid.model.LiquidEnvironment$;
import com.barrybecker4.simulation.liquid.model.Particle;
import com.barrybecker4.simulation.liquid.model.Particles;
import com.barrybecker4.simulation.liquid.model.VortexGrid;
import java.io.Serializable;
import javax.vecmath.Vector2d;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005mu!B\u0016-\u0011\u00039d!B\u001d-\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011\u0005bB\"\u0002\u0005\u0004%I\u0001\u0012\u0005\u0007\u0011\u0006\u0001\u000b\u0011B#\u0007\teb\u0003!\u0013\u0005\t\u0015\u0016\u0011)\u0019!C\u0001\u0017\"Aq+\u0002B\u0001B\u0003%A\nC\u0003B\u000b\u0011\u0005\u0001\fC\u0005\\\u000b\u0001\u0007\t\u0019!C\u00059\"I\u0001-\u0002a\u0001\u0002\u0004%I!\u0019\u0005\nO\u0016\u0001\r\u0011!Q!\nuC\u0011\u0002[\u0003A\u0002\u0003\u0007I\u0011B5\t\u0013A,\u0001\u0019!a\u0001\n\u0013\t\b\"C:\u0006\u0001\u0004\u0005\t\u0015)\u0003k\u0011%!X\u00011AA\u0002\u0013%Q\u000fC\u0005}\u000b\u0001\u0007\t\u0019!C\u0005{\"Iq0\u0002a\u0001\u0002\u0003\u0006KA\u001e\u0005\f\u0003\u0003)\u0001\u0019!a\u0001\n\u0013\t\u0019\u0001C\u0006\u0002\f\u0015\u0001\r\u00111A\u0005\n\u00055\u0001bCA\t\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u000bA\u0011\"a\u0005\u0006\u0001\u0004%I!!\u0006\t\u0013\u0005uQ\u00011A\u0005\n\u0005}\u0001\u0002CA\u0012\u000b\u0001\u0006K!a\u0006\t\u0013\u0005\u0015R\u00011A\u0005\n\u0005\u001d\u0002\"CA\u0018\u000b\u0001\u0007I\u0011BA\u0019\u0011!\t)$\u0002Q!\n\u0005%\u0002bBA\u001c\u000b\u0011%\u0011\u0011\b\u0005\b\u0003{)A\u0011AA \u0011\u001d\t\t%\u0002C\u0005\u0003\u007fAa!a\u0011\u0006\t\u0003!\u0005BBA#\u000b\u0011\u0005A\t\u0003\u0004\u0002H\u0015!\t\u0001\u0018\u0005\b\u0003\u0013*A\u0011AA&\u0011\u001d\t)'\u0002C\u0001\u0003OBq!!\u001c\u0006\t\u0003\ty\u0007C\u0004\u0002v\u0015!\t!a\n\t\u000f\u0005]T\u0001\"\u0001\u0002z!9\u0011qP\u0003\u0005\u0002\u0005\u0005\u0005bBAD\u000b\u0011%\u0011q\b\u0005\b\u0003\u0013+A\u0011BA \u0011\u001d\tY)\u0002C\u0001\u0003\u007fAq!!$\u0006\t\u0013\ty)A\tMSF,\u0018\u000eZ#om&\u0014xN\\7f]RT!!\f\u0018\u0002\u000b5|G-\u001a7\u000b\u0005=\u0002\u0014A\u00027jcVLGM\u0003\u00022e\u0005Q1/[7vY\u0006$\u0018n\u001c8\u000b\u0005M\"\u0014\u0001\u00042beJL(-Z2lKJ$$\"A\u001b\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005a\nQ\"\u0001\u0017\u0003#1K\u0017/^5e\u000b:4\u0018N]8o[\u0016tGo\u0005\u0002\u0002wA\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001c\u0002\u001d9+Vj\u0018*B\u001d\u0012{\u0006+\u0011*U'V\tQ\t\u0005\u0002=\r&\u0011q)\u0010\u0002\u0004\u0013:$\u0018a\u0004(V\u001b~\u0013\u0016I\u0014#`!\u0006\u0013Fk\u0015\u0011\u0014\u0005\u0015Y\u0014AC2p]\u001aLwMR5mKV\tA\n\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fvj\u0011\u0001\u0015\u0006\u0003#Z\na\u0001\u0010:p_Rt\u0014BA*>\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Mk\u0014aC2p]\u001aLwMR5mK\u0002\"\"!\u0017.\u0011\u0005a*\u0001\"\u0002&\t\u0001\u0004a\u0015\u0001B4sS\u0012,\u0012!\u0018\t\u0003qyK!a\u0018\u0017\u0003\t\u001d\u0013\u0018\u000eZ\u0001\tOJLGm\u0018\u0013fcR\u0011!-\u001a\t\u0003y\rL!\u0001Z\u001f\u0003\tUs\u0017\u000e\u001e\u0005\bM*\t\t\u00111\u0001^\u0003\rAH%M\u0001\u0006OJLG\rI\u0001\fOJLG-\u00169eCR,'/F\u0001k!\tYg.D\u0001m\u0015\tig&A\u0004d_6\u0004X\u000f^3\n\u0005=d'aC$sS\u0012,\u0006\u000fZ1uKJ\fqb\u001a:jIV\u0003H-\u0019;fe~#S-\u001d\u000b\u0003EJDqAZ\u0007\u0002\u0002\u0003\u0007!.\u0001\u0007he&$W\u000b\u001d3bi\u0016\u0014\b%\u0001\u0006d_:$\u0017\u000e^5p]N,\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s:\naaY8oM&<\u0017BA>y\u0005)\u0019uN\u001c3ji&|gn]\u0001\u000fG>tG-\u001b;j_:\u001cx\fJ3r)\t\u0011g\u0010C\u0004g!\u0005\u0005\t\u0019\u0001<\u0002\u0017\r|g\u000eZ5uS>t7\u000fI\u0001\na\u0006\u0014H/[2mKN,\"!!\u0002\u0011\u0007a\n9!C\u0002\u0002\n1\u0012\u0011\u0002U1si&\u001cG.Z:\u0002\u001bA\f'\u000f^5dY\u0016\u001cx\fJ3r)\r\u0011\u0017q\u0002\u0005\tMN\t\t\u00111\u0001\u0002\u0006\u0005Q\u0001/\u0019:uS\u000edWm\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003/\u00012\u0001PA\r\u0013\r\tY\"\u0010\u0002\u0007\t>,(\r\\3\u0002\u0011QLW.Z0%KF$2AYA\u0011\u0011!1g#!AA\u0002\u0005]\u0011!\u0002;j[\u0016\u0004\u0013!D1em\u0016\u001cG/[8o\u001f:d\u00170\u0006\u0002\u0002*A\u0019A(a\u000b\n\u0007\u00055RHA\u0004C_>dW-\u00198\u0002#\u0005$g/Z2uS>twJ\u001c7z?\u0012*\u0017\u000fF\u0002c\u0003gA\u0001BZ\r\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u000fC\u00124Xm\u0019;j_:|e\u000e\\=!\u0003aIg.\u001b;jC2L'0\u001a$s_6\u001cuN\u001c4jO\u001aKG.\u001a\u000b\u0004E\u0006m\u0002\"\u0002&\u001c\u0001\u0004a\u0015!\u0002:fg\u0016$H#\u00012\u0002\u001f%t\u0017\u000e^#om&\u0014xN\\7f]R\f\u0001bZ3u/&$G\u000f[\u0001\nO\u0016$\b*Z5hQR\fqaZ3u\u000fJLG-\u0001\u0007hKR\u0004\u0016M\u001d;jG2,7/\u0006\u0002\u0002NA1\u0011qJA-\u0003?rA!!\u0015\u0002V9\u0019q*a\u0015\n\u0003yJ1!a\u0016>\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0017\u0002^\tA\u0011\n^3sCR|'OC\u0002\u0002Xu\u00022\u0001OA1\u0013\r\t\u0019\u0007\f\u0002\t!\u0006\u0014H/[2mK\u0006a1/\u001a;WSN\u001cwn]5usR\u0019!-!\u001b\t\u000f\u0005-$\u00051\u0001\u0002\u0018\u0005\ta/A\u0003tKR\u0014\u0005\u0007F\u0002c\u0003cBq!a\u001d$\u0001\u0004\t9\"\u0001\u0002ca\u0005\u0001r-\u001a;BIZ,7\r^5p]>sG._\u0001\u0011g\u0016$\u0018\t\u001a<fGRLwN\\(oYf$2AYA>\u0011\u001d\ti(\na\u0001\u0003S\t!\"\u00193wK\u000e$xJ\u001c7z\u0003-\u0019H/\u001a9G_J<\u0018M\u001d3\u0015\t\u0005]\u00111\u0011\u0005\b\u0003\u000b3\u0003\u0019AA\f\u0003!!\u0018.\\3Ti\u0016\u0004\u0018\u0001E:fi&s\u0017\u000e^5bY2K\u0017/^5e\u00039\u0019X\r^\"p]N$(/Y5oiN\f!\"\u00193e'>,(oY3t\u0003%\tG\rZ*pkJ\u001cW\rF\u0002c\u0003#Cq!a%+\u0001\u0004\t)*\u0001\u0004t_V\u00148-\u001a\t\u0004o\u0006]\u0015bAAMq\n11k\\;sG\u0016\u0004")
public class LiquidEnvironment {
    private final String configFile;
    private Grid grid;
    private GridUpdater gridUpdater;
    private Conditions conditions;
    private Particles particles;
    private double time;
    private boolean advectionOnly;

    public String configFile() {
        return this.configFile;
    }

    private Grid grid() {
        return this.grid;
    }

    private void grid_$eq(Grid x$1) {
        this.grid = x$1;
    }

    private GridUpdater gridUpdater() {
        return this.gridUpdater;
    }

    private void gridUpdater_$eq(GridUpdater x$1) {
        this.gridUpdater = x$1;
    }

    private Conditions conditions() {
        return this.conditions;
    }

    private void conditions_$eq(Conditions x$1) {
        this.conditions = x$1;
    }

    private Particles particles() {
        return this.particles;
    }

    private void particles_$eq(Particles x$1) {
        this.particles = x$1;
    }

    private double time() {
        return this.time;
    }

    private void time_$eq(double x$1) {
        this.time = x$1;
    }

    private boolean advectionOnly() {
        return this.advectionOnly;
    }

    private void advectionOnly_$eq(boolean x$1) {
        this.advectionOnly = x$1;
    }

    private void initializeFromConfigFile(String configFile) {
        this.conditions_$eq(new Conditions(configFile));
        this.initEnvironment();
    }

    public void reset() {
        this.initEnvironment();
    }

    private void initEnvironment() {
        int xDim = this.conditions().getGridWidth() + 2;
        int yDim = this.conditions().getGridHeight() + 2;
        this.grid_$eq(new VortexGrid(xDim, yDim));
        this.particles_$eq(new Particles());
        this.gridUpdater_$eq(new GridUpdater(this.grid()));
        this.setInitialLiquid();
        this.grid().setBoundaries();
        this.setConstraints();
    }

    public int getWidth() {
        return this.grid().getXDimension() + 2;
    }

    public int getHeight() {
        return this.grid().getYDimension() + 2;
    }

    public Grid getGrid() {
        return this.grid();
    }

    public Iterator<Particle> getParticles() {
        return this.particles().iterator();
    }

    public void setViscosity(double v) {
        this.gridUpdater().setViscosity(v);
    }

    public void setB0(double b0) {
        this.gridUpdater().setB0(b0);
    }

    public boolean getAdvectionOnly() {
        return this.advectionOnly();
    }

    public void setAdvectionOnly(boolean advectOnly) {
        this.advectionOnly_$eq(advectOnly);
    }

    /*
     * WARNING - void declaration
     */
    public double stepForward(double timeStep) {
        void var3_2;
        this.grid().updateCellStatus();
        this.setConstraints();
        if (!this.advectionOnly()) {
            this.gridUpdater().updateVelocity(timeStep, this.conditions().getGravity());
            this.gridUpdater().updatePressure(timeStep);
            this.gridUpdater().updateSurfaceVelocity();
        }
        double newTimeStep = this.gridUpdater().updateParticlePosition(timeStep, this.particles());
        this.time_$eq(this.time() + newTimeStep);
        Logger$.MODULE$.log(1, new StringBuilder(11).append(" the Time= ").append(this.time()).toString());
        return (double)var3_2;
    }

    private void setInitialLiquid() {
        this.conditions().getInitialLiquidRegions().foreach((Function1 & Serializable)region -> {
            LiquidEnvironment.$anonfun$setInitialLiquid$1(this, region);
            return BoxedUnit.UNIT;
        });
    }

    private void setConstraints() {
        this.grid().setBoundaryConstraints();
        this.addSources();
    }

    public void addSources() {
        this.conditions().getSources().foreach((Function1 & Serializable)source -> {
            this.addSource(source);
            return BoxedUnit.UNIT;
        });
    }

    private void addSource(Source source) {
        block0: {
            Vector2d velocity = source.getVelocity();
            if (!source.isOn(this.time())) break block0;
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(source.getStart().getX()), source.getStop().getX()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(source.getStart().getY()), source.getStop().getY()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
                this.grid().setVelocity(i, j, velocity);
                this.particles().addRandomParticles(i, j, LiquidEnvironment$.MODULE$.com$barrybecker4$simulation$liquid$model$LiquidEnvironment$$NUM_RAND_PARTS(), this.grid());
            }));
        }
    }

    public static final /* synthetic */ void $anonfun$setInitialLiquid$1(LiquidEnvironment $this, Region region) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(region.getStart().getX()), region.getStop().getX()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(region.getStart().getY()), region.getStop().getY()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> $this.particles().addRandomParticles(i, j, 4 * LiquidEnvironment$.MODULE$.com$barrybecker4$simulation$liquid$model$LiquidEnvironment$$NUM_RAND_PARTS(), $this.grid())));
    }

    public LiquidEnvironment(String configFile) {
        this.configFile = configFile;
        this.initializeFromConfigFile(configFile);
        this.time = 0.0;
        this.advectionOnly = false;
    }
}

