/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.model;

import com.barrybecker4.simulation.liquid.model.CellStatus$;
import com.barrybecker4.simulation.liquid.model.Grid;
import java.io.Serializable;
import javax.vecmath.Vector2d;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005}3Aa\u0004\t\u00017!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003\"\u0011!A\u0003A!b\u0001\n\u0003I\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u0011M\u0002!Q1A\u0005\u0002QB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006\u0015\u0002!\ta\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u00191\u0006\u0001)A\u0005'\"9q\u000b\u0001b\u0001\n\u0003\u0011\u0006B\u0002-\u0001A\u0003%1\u000bC\u0004Z\u0001\t\u0007I\u0011\u0001*\t\ri\u0003\u0001\u0015!\u0003T\u0011\u0015Q\u0005\u0001\"\u0001\\\u00059quN\\+oS\u001a|'/\\$sS\u0012T!!\u0005\n\u0002\u000b5|G-\u001a7\u000b\u0005M!\u0012A\u00027jcVLGM\u0003\u0002\u0016-\u0005Q1/[7vY\u0006$\u0018n\u001c8\u000b\u0005]A\u0012\u0001\u00042beJL(-Z2lKJ$$\"A\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f\u001f\u001b\u0005\u0001\u0012BA\u0010\u0011\u0005\u00119%/\u001b3\u0002\ta$\u0015.\u001c\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0004\u0013:$\u0018\u0001B=ES6\f\u0001B^3m_\u000eLG/_\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\bm\u0016\u001cW.\u0019;i\u0015\u0005y\u0013!\u00026bm\u0006D\u0018BA\u0019-\u0005!1Vm\u0019;peJ\"\u0017!\u0003<fY>\u001c\u0017\u000e^=!\u0003\u0019\u0019H/\u0019;vgV\tQ\u0007\u0005\u00027\r:\u0011q\u0007\u0012\b\u0003q\rs!!\u000f\"\u000f\u0005i\neBA\u001eA\u001d\tat(D\u0001>\u0015\tq$$\u0001\u0004=e>|GOP\u0005\u00023%\u0011q\u0003G\u0005\u0003+YI!a\u0005\u000b\n\u0005E\u0011\u0012BA#\u0011\u0003)\u0019U\r\u001c7Ti\u0006$Xo]\u0005\u0003\u000f\"\u0013!bQ3mYN#\u0018\r^;t\u0015\t)\u0005#A\u0004ti\u0006$Xo\u001d\u0011\u0002\rqJg.\u001b;?)\u0015aUJT(Q!\ti\u0002\u0001C\u0003!\u000f\u0001\u0007\u0011\u0005C\u0003(\u000f\u0001\u0007\u0011\u0005C\u0003)\u000f\u0001\u0007!\u0006C\u00034\u000f\u0001\u0007Q'A\u0004dK:$XM\u001d-\u0016\u0003M\u0003\"A\t+\n\u0005U\u001b#A\u0002#pk\ndW-\u0001\u0005dK:$XM\u001d-!\u0003\u001d\u0019WM\u001c;fef\u000b\u0001bY3oi\u0016\u0014\u0018\fI\u0001\b[\u0006DH)[:u\u0003!i\u0017\r\u001f#jgR\u0004C\u0003\u0002'];zCQ\u0001\t\bA\u0002\u0005BQa\n\bA\u0002\u0005BQ\u0001\u000b\bA\u0002)\u0002")
public class NonUniformGrid
extends Grid {
    private final int xDim;
    private final Vector2d velocity;
    private final Enumeration.Value status;
    private final double centerX;
    private final double centerY;
    private final double maxDist;

    public Vector2d velocity() {
        return this.velocity;
    }

    public Enumeration.Value status() {
        return this.status;
    }

    public double centerX() {
        return this.centerX;
    }

    public double centerY() {
        return this.centerY;
    }

    public double maxDist() {
        return this.maxDist;
    }

    public NonUniformGrid(int xDim, int yDim, Vector2d velocity, Enumeration.Value status) {
        this.xDim = xDim;
        this.velocity = velocity;
        this.status = status;
        super(xDim, yDim);
        this.centerX = (double)(xDim / 2) + 0.5;
        this.centerY = (double)(yDim / 2) + 0.5;
        this.maxDist = Math.sqrt(this.centerX() * this.centerX() + this.centerY() * this.centerY());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), yDim - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), $this.xDim - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double xDiff = this.centerX() - (double)i;
            double yDiff = this.centerY() - (double)j;
            double dist = Math.sqrt(xDiff * xDiff + yDiff * yDiff);
            double scale = (this.maxDist() - dist) / this.maxDist();
            Vector2d vel = new Vector2d($this.velocity().x * scale, $this.velocity().y * scale);
            this.setVelocity(i, j, vel);
            this.getCell(i, j).setStatus(this.status());
        }));
    }

    public NonUniformGrid(int xDim, int yDim, Vector2d velocity) {
        this(xDim, yDim, velocity, CellStatus$.MODULE$.EMPTY());
    }
}

