/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.liquid.rendering;

import com.barrybecker4.simulation.liquid.Logger$;
import com.barrybecker4.simulation.liquid.compute.VelocityInterpolator;
import com.barrybecker4.simulation.liquid.model.Cell;
import com.barrybecker4.simulation.liquid.model.Grid;
import com.barrybecker4.simulation.liquid.model.LiquidEnvironment;
import com.barrybecker4.simulation.liquid.model.Particle;
import com.barrybecker4.simulation.liquid.rendering.EnvironmentRenderer$;
import com.barrybecker4.simulation.liquid.rendering.RenderingOptions;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.Serializable;
import javax.vecmath.Vector2d;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Mw!B\u001d;\u0011\u0003)e!B$;\u0011\u0003A\u0005\"B(\u0002\t\u0003\u0001\u0006bB)\u0002\u0005\u0004%IA\u0015\u0005\u00077\u0006\u0001\u000b\u0011B*\t\u000fq\u000b!\u0019!C\u0005%\"1Q,\u0001Q\u0001\nMCqAX\u0001C\u0002\u0013%q\f\u0003\u0004d\u0003\u0001\u0006I\u0001\u0019\u0005\bI\u0006\u0011\r\u0011\"\u0003S\u0011\u0019)\u0017\u0001)A\u0005'\"9a-\u0001b\u0001\n\u0013y\u0006BB4\u0002A\u0003%\u0001\rC\u0004i\u0003\t\u0007I\u0011B5\t\r5\f\u0001\u0015!\u0003k\u0011\u001dq\u0017A1A\u0005\nICaa\\\u0001!\u0002\u0013\u0019\u0006b\u00029\u0002\u0005\u0004%IA\u0015\u0005\u0007c\u0006\u0001\u000b\u0011B*\t\u000fI\f!\u0019!C\u0005g\"1q/\u0001Q\u0001\nQDq\u0001_\u0001C\u0002\u0013%1\u000f\u0003\u0004z\u0003\u0001\u0006I\u0001\u001e\u0005\bu\u0006\u0011\r\u0011\"\u0003|\u0011\u001d\tI!\u0001Q\u0001\nqD\u0011\"a\u0003\u0002\u0005\u0004%I!!\u0004\t\u0011\u0005U\u0011\u0001)A\u0005\u0003\u001f1Qa\u0012\u001e\u0003\u0003/A!\"!\u0007\u001c\u0005\u0003\u0007I\u0011AA\u000e\u0011)\tIc\u0007BA\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003oY\"\u0011!Q!\n\u0005u\u0001BB(\u001c\t\u0003\tI\u0004\u0003\u0005\u0002@m\u0001\r\u0011\"\u0003j\u0011%\t\te\u0007a\u0001\n\u0013\t\u0019\u0005C\u0004\u0002Hm\u0001\u000b\u0015\u00026\t\u0013\u0005%3\u00041A\u0005\n\u0005-\u0003\"CA*7\u0001\u0007I\u0011BA+\u0011!\tIf\u0007Q!\n\u00055\u0003\u0002CA.7\u0001\u0007I\u0011B:\t\u0013\u0005u3\u00041A\u0005\n\u0005}\u0003bBA27\u0001\u0006K\u0001\u001e\u0005\n\u0003KZ\"\u0019!C\u0005\u0003OB\u0001\"a\u001c\u001cA\u0003%\u0011\u0011\u000e\u0005\b\u0003cZB\u0011AA:\u0011\u001d\t9h\u0007C\u0005\u0003sBa!a!\u001c\t\u0003I\u0007bBAC7\u0011\u0005\u0011q\r\u0005\b\u0003\u000f[B\u0011AAE\u0011\u0019\tIj\u0007C\u0005S\"9\u00111T\u000e\u0005\n\u0005u\u0005bBAQ7\u0011%\u00111\u0015\u0005\b\u0003O[B\u0011BAU\u0011\u001d\t)l\u0007C\u0005\u0003oCq!a/\u001c\t\u0013\ti\fC\u0004\u0002Bn!I!a1\t\u000f\u0005\u001d7\u0004\"\u0003\u0002J\"9\u0011QZ\u000e\u0005\n\u0005=\u0017aE#om&\u0014xN\\7f]R\u0014VM\u001c3fe\u0016\u0014(BA\u001e=\u0003%\u0011XM\u001c3fe&twM\u0003\u0002>}\u00051A.[9vS\u0012T!a\u0010!\u0002\u0015MLW.\u001e7bi&|gN\u0003\u0002B\u0005\u0006a!-\u0019:ss\n,7m[3si)\t1)A\u0002d_6\u001c\u0001\u0001\u0005\u0002G\u00035\t!HA\nF]ZL'o\u001c8nK:$(+\u001a8eKJ,'o\u0005\u0002\u0002\u0013B\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A#\u0002\u0015\u001d\u0013\u0016\nR0D\u001f2{%+F\u0001T!\t!\u0016,D\u0001V\u0015\t1v+A\u0002boRT\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[+\n)1i\u001c7pe\u0006YqIU%E?\u000e{Ej\u0014*!\u0003]\u0001\u0016I\u0015+J\u00072+uLV#M\u001f\u000eKE+W0D\u001f2{%+\u0001\rQ\u0003J#\u0016j\u0011'F?Z+EjT\"J)f{6i\u0014'P%\u0002\n\u0001\u0004U!S)&\u001bE*R0W\u000b2{5)\u0013+Z?N#&kT&F+\u0005\u0001\u0007C\u0001+b\u0013\t\u0011WKA\u0006CCNL7m\u0015;s_.,\u0017!\u0007)B%RK5\tT#`-\u0016cujQ%U3~\u001bFKU(L\u000b\u0002\n1CR!D\u000b~3V\tT(D\u0013RKvlQ(M\u001fJ\u000bACR!D\u000b~3V\tT(D\u0013RKvlQ(M\u001fJ\u0003\u0013\u0001\u0006$B\u0007\u0016{f+\u0012'P\u0007&#\u0016lX*U%>[U)A\u000bG\u0003\u000e+uLV#M\u001f\u000eKE+W0T)J{5*\u0012\u0011\u0002\u001dY+EjT\"J)f{6kQ!M\u000bV\t!\u000e\u0005\u0002KW&\u0011An\u0013\u0002\u0007\t>,(\r\\3\u0002\u001fY+EjT\"J)f{6kQ!M\u000b\u0002\n!bV!M\u0019~\u001bu\nT(S\u0003-9\u0016\t\u0014'`\u0007>cuJ\u0015\u0011\u0002\u0015Q+\u0005\fV0D\u001f2{%+A\u0006U\u000bb#vlQ(M\u001fJ\u0003\u0013!\u0004#F\r\u0006+F\nV0T\u0007\u0006cU)F\u0001u!\tQU/\u0003\u0002w\u0017\n\u0019\u0011J\u001c;\u0002\u001d\u0011+e)Q+M)~\u001b6)\u0011'FA\u00051qJ\u0012$T\u000bR\u000bqa\u0014$G'\u0016#\u0006%\u0001\tqe\u0016\u001c8/\u001e:f\u0007>dwN]'baV\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001B;uS2T1!a\u0001A\u0003\t)\u0018.C\u0002\u0002\by\u0014\u0001bQ8m_Jl\u0015\r]\u0001\u0012aJ,7o];sK\u000e{Gn\u001c:NCB\u0004\u0013!\u0003\"B'\u0016{fi\u0014(U+\t\ty\u0001E\u0002U\u0003#I1!a\u0005V\u0005\u00111uN\u001c;\u0002\u0015\t\u000b5+R0G\u001f:#\u0006e\u0005\u0002\u001c\u0013\u0006\u0019QM\u001c<\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rB(A\u0003n_\u0012,G.\u0003\u0003\u0002(\u0005\u0005\"!\u0005'jcVLG-\u00128wSJ|g.\\3oi\u00069QM\u001c<`I\u0015\fH\u0003BA\u0017\u0003g\u00012ASA\u0018\u0013\r\t\td\u0013\u0002\u0005+:LG\u000fC\u0005\u00026u\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u0019\u0002\t\u0015tg\u000f\t\u000b\u0005\u0003w\ti\u0004\u0005\u0002G7!9\u0011\u0011D\u0010A\u0002\u0005u\u0011!B:dC2,\u0017!C:dC2,w\fJ3r)\u0011\ti#!\u0012\t\u0011\u0005U\u0012%!AA\u0002)\faa]2bY\u0016\u0004\u0013!D<bY2d\u0015N\\3XS\u0012$\b.\u0006\u0002\u0002NA\u0019!*a\u0014\n\u0007\u0005E3JA\u0003GY>\fG/A\txC2dG*\u001b8f/&$G\u000f[0%KF$B!!\f\u0002X!I\u0011Q\u0007\u0013\u0002\u0002\u0003\u0007\u0011QJ\u0001\u000fo\u0006dG\u000eT5oK^KG\r\u001e5!\u00031\u0001\u0018M\u001d;jG2,7+\u001b>f\u0003A\u0001\u0018M\u001d;jG2,7+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002.\u0005\u0005\u0004\u0002CA\u001bO\u0005\u0005\t\u0019\u0001;\u0002\u001bA\f'\u000f^5dY\u0016\u001c\u0016N_3!\u0003\u001dy\u0007\u000f^5p]N,\"!!\u001b\u0011\u0007\u0019\u000bY'C\u0002\u0002ni\u0012\u0001CU3oI\u0016\u0014\u0018N\\4PaRLwN\\:\u0002\u0011=\u0004H/[8og\u0002\n\u0001b]3u'\u000e\fG.\u001a\u000b\u0005\u0003[\t)\b\u0003\u0004\u0002@-\u0002\rA[\u0001\u0011I\u0016$XM]7j]\u0016\u001c6-\u00197j]\u001e$b!!\f\u0002|\u0005}\u0004BBA?Y\u0001\u0007A/A\u0003xS\u0012$\b\u000e\u0003\u0004\u0002\u00022\u0002\r\u0001^\u0001\u0007Q\u0016Lw\r\u001b;\u0002\u0011\u001d,GoU2bY\u0016\f1cZ3u%\u0016tG-\u001a:j]\u001e|\u0005\u000f^5p]N\faA]3oI\u0016\u0014H\u0003CA\u0017\u0003\u0017\u000b)*a&\t\u000f\u00055u\u00061\u0001\u0002\u0010\u0006\tq\rE\u0002U\u0003#K1!a%V\u0005)9%/\u00199iS\u000e\u001c(\u0007\u0012\u0005\u0007\u0003{z\u0003\u0019\u0001;\t\r\u0005\u0005u\u00061\u0001u\u0003\u001d9W\r^'bqf\u000b\u0001\u0002\u001a:bo\u001e\u0013\u0018\u000e\u001a\u000b\u0005\u0003[\ty\nC\u0004\u0002\u000eF\u0002\r!a$\u0002\u001b\u0011\u0014\u0018m\u001e)beRL7\r\\3t)\u0011\ti#!*\t\u000f\u00055%\u00071\u0001\u0002\u0010\u0006\u0019r-\u001a;D_2|'OR8s!\u0006\u0014H/[2mKR\u00191+a+\t\u000f\u000556\u00071\u0001\u00020\u0006!\u0001/\u0019:u!\u0011\ty\"!-\n\t\u0005M\u0016\u0011\u0005\u0002\t!\u0006\u0014H/[2mK\u00061BM]1x!\u0006\u0014H/[2mKZ+Gn\\2ji&,7\u000f\u0006\u0003\u0002.\u0005e\u0006bBAGi\u0001\u0007\u0011qR\u0001\u000fe\u0016tG-\u001a:Qe\u0016\u001c8/\u001e:f)\u0011\ti#a0\t\u000f\u00055U\u00071\u0001\u0002\u0010\u0006IAM]1x/\u0006dGn\u001d\u000b\u0005\u0003[\t)\rC\u0004\u0002\u000eZ\u0002\r!a$\u0002\u001f\u0011\u0014\u0018m^\"fY2\u001c\u00160\u001c2pYN$B!!\f\u0002L\"9\u0011QR\u001cA\u0002\u0005=\u0015A\u00063sC^\u001cU\r\u001c7GC\u000e,g+\u001a7pG&$\u0018.Z:\u0015\t\u00055\u0012\u0011\u001b\u0005\b\u0003\u001bC\u0004\u0019AAH\u0001")
public final class EnvironmentRenderer {
    private LiquidEnvironment env;
    private double scale;
    private float wallLineWidth;
    private int particleSize;
    private final RenderingOptions options;

    public LiquidEnvironment env() {
        return this.env;
    }

    public void env_$eq(LiquidEnvironment x$1) {
        this.env = x$1;
    }

    private double scale() {
        return this.scale;
    }

    private void scale_$eq(double x$1) {
        this.scale = x$1;
    }

    private float wallLineWidth() {
        return this.wallLineWidth;
    }

    private void wallLineWidth_$eq(float x$1) {
        this.wallLineWidth = x$1;
    }

    private int particleSize() {
        return this.particleSize;
    }

    private void particleSize_$eq(int x$1) {
        this.particleSize = x$1;
    }

    private RenderingOptions options() {
        return this.options;
    }

    public void setScale(double scale) {
        this.scale_$eq(scale);
        this.wallLineWidth_$eq((float)(scale / 5.0) + 1.0f);
        this.particleSize_$eq((int)(scale / 6.0) + 1);
    }

    private void determineScaling(int width, int height) {
        Grid grid = this.env().getGrid();
        int proposedXScale = width / grid.getXDimension();
        int proposedYScale = height / grid.getYDimension();
        this.setScale(Math.min(proposedXScale, proposedYScale));
    }

    public double getScale() {
        return this.scale();
    }

    public RenderingOptions getRenderingOptions() {
        return this.options();
    }

    public void render(Graphics2D g, int width, int height) {
        long time = System.currentTimeMillis();
        this.determineScaling(width, height);
        this.env().getGrid().updateCellStatus();
        this.drawGrid(g);
        if (this.options().getShowPressures()) {
            this.renderPressure(g);
        }
        this.drawWalls(g);
        this.drawParticles(g);
        if (this.options().getShowCellStatus()) {
            this.drawCellSymbols(g);
        }
        if (this.options().getShowVelocities()) {
            this.drawCellFaceVelocities(g);
        }
        double duration = (double)(System.currentTimeMillis() - time) / 100.0;
        Logger$.MODULE$.log(1, new StringBuilder(20).append("time to render:  (").append(duration).append(") ").toString());
    }

    private double getMaxY() {
        return this.scale() * (double)this.env().getGrid().getYDimension() + (double)EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET();
    }

    private void drawGrid(Graphics2D g) {
        g.setColor(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$GRID_COLOR());
        Grid grid = this.env().getGrid();
        int xDim = grid.getXDimension();
        int yDim = grid.getYDimension();
        int rightEdgePos = (int)(this.scale() * (double)xDim);
        int bottomEdgePos = (int)(this.scale() * (double)yDim);
        int maxY = (int)this.getMaxY();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), yDim).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            int ypos = (int)((double)j * this.scale());
            g.drawLine(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET(), maxY - ypos, rightEdgePos + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET(), maxY - ypos);
        });
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), xDim).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int xpos = (int)((double)i * this.scale());
            g.drawLine(xpos + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET(), maxY, xpos + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET(), maxY - bottomEdgePos);
        });
    }

    private void drawParticles(Graphics2D g) {
        block0: {
            double[] a = new double[2];
            double maxY = this.getMaxY();
            this.env().getParticles().foreach((Function1 & Serializable)p -> {
                EnvironmentRenderer.$anonfun$drawParticles$1(this, a, g, maxY, p);
                return BoxedUnit.UNIT;
            });
            if (!this.options().getShowVelocities()) break block0;
            this.drawParticleVelocities(g);
        }
    }

    private Color getColorForParticle(Particle part) {
        int green = (int)part.y % 2 == 0 ? 150 : 50;
        int comp = (int)(256.0 * part.getAge() / 20.0);
        comp = comp > 255 ? 255 : comp;
        return new Color(comp, green, 255 - comp, 80);
    }

    private void drawParticleVelocities(Graphics2D g) {
        g.setStroke(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$PARTICLE_VELOCITY_STROKE());
        g.setColor(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$PARTICLE_VELOCITY_COLOR());
        double[] a = new double[2];
        Grid grid = this.env().getGrid();
        VelocityInterpolator interpolator = new VelocityInterpolator(grid);
        double maxY = this.getMaxY();
        this.env().getParticles().foreach((Function1 & Serializable)p -> {
            EnvironmentRenderer.$anonfun$drawParticleVelocities$1(this, interpolator, a, maxY, g, p);
            return BoxedUnit.UNIT;
        });
    }

    private void renderPressure(Graphics2D g) {
        Grid grid = this.env().getGrid();
        double maxY = this.getMaxY();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), grid.getYDimension()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), grid.getXDimension()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            g.setColor(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$pressureColorMap().getColorForValue(grid.getCell(i, j).getPressure()));
            g.fillRect((int)(this.scale() * (double)i) + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET(), (int)(maxY - this.scale() * (double)j), (int)this.scale(), (int)this.scale());
        }));
    }

    private void drawWalls(Graphics2D g) {
        BasicStroke wallStroke = new BasicStroke(this.wallLineWidth());
        g.setStroke(wallStroke);
        g.setColor(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$WALL_COLOR());
        g.drawRect(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET(), EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET(), (int)((double)this.env().getGrid().getXDimension() * this.scale()), (int)((double)this.env().getGrid().getYDimension() * this.scale()));
    }

    private void drawCellSymbols(Graphics2D g) {
        Grid grid = this.env().getGrid();
        g.setColor(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$TEXT_COLOR());
        g.setFont(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$BASE_FONT());
        scala.collection.mutable.StringBuilder strBuf = new scala.collection.mutable.StringBuilder("12");
        double maxY = this.getMaxY();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), grid.getYDimension()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), grid.getXDimension()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int x = (int)(this.scale() * (double)i) + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET();
            int y = (int)(maxY - this.scale() * (double)(j + 1));
            strBuf.append((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)grid.getCell(i, j).getStatus().toString()));
            strBuf.setLength(1);
            g.drawString(strBuf.toString(), x + 6, y + 18);
        }));
    }

    private void drawCellFaceVelocities(Graphics2D g) {
        g.setStroke(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$FACE_VELOCITY_STROKE());
        g.setColor(EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$FACE_VELOCITY_COLOR());
        Grid grid = this.env().getGrid();
        double maxY = this.getMaxY();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), grid.getYDimension()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), grid.getXDimension()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Cell cell = grid.getCell(i, j);
            double u = cell.getU();
            double v = cell.getV();
            int x = (int)(this.scale() * (double)i) + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET();
            int xMid = (int)(this.scale() * ((double)i + 0.5)) + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET();
            int xLen = (int)(this.scale() * (double)i + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$VELOCITY_SCALE() * u) + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET();
            int y = (int)(maxY - this.scale() * (double)j);
            int yMid = (int)(maxY - this.scale() * ((double)j + 0.5));
            int yLen = (int)(maxY - (this.scale() * (double)j + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$VELOCITY_SCALE() * v));
            g.drawLine(xMid, y, xMid, yLen);
            g.drawLine(x, yMid, xLen, yMid);
        }));
    }

    public static final /* synthetic */ void $anonfun$drawParticles$1(EnvironmentRenderer $this, double[] a$1, Graphics2D g$2, double maxY$2, Particle p) {
        p.get(a$1);
        g$2.setColor($this.getColorForParticle(p));
        double offset = (double)(-$this.particleSize()) / 2.0;
        int y = (int)(maxY$2 - ($this.scale() * a$1[1] - offset));
        g$2.fillOval((int)($this.scale() * a$1[0] + offset + (double)EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET()), y, $this.particleSize(), $this.particleSize());
    }

    public static final /* synthetic */ void $anonfun$drawParticleVelocities$1(EnvironmentRenderer $this, VelocityInterpolator interpolator$1, double[] a$2, double maxY$3, Graphics2D g$3, Particle p) {
        block0: {
            if (!$this.options().getShowVelocities()) break block0;
            Vector2d vel = interpolator$1.findVelocity(p);
            p.get(a$2);
            double x = $this.scale() * a$2[0] + (double)EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$OFFSET();
            double xLen = x + EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$VELOCITY_SCALE() * vel.x;
            double y = maxY$3 - $this.scale() * a$2[1];
            double yLen = y - EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$VELOCITY_SCALE() * vel.y;
            g$3.drawLine((int)x, (int)y, (int)xLen, (int)yLen);
        }
    }

    public EnvironmentRenderer(LiquidEnvironment env) {
        this.env = env;
        this.scale = EnvironmentRenderer$.MODULE$.com$barrybecker4$simulation$liquid$rendering$EnvironmentRenderer$$DEFAULT_SCALE();
        this.wallLineWidth = 0.0f;
        this.particleSize = 0;
        this.options = new RenderingOptions();
    }
}

