/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.puzzle.maze;

import com.barrybecker4.common.concurrency.ThreadUtil$;
import com.barrybecker4.common.geometry.IntLocation;
import com.barrybecker4.common.geometry.Location;
import com.barrybecker4.math.MathUtil$;
import com.barrybecker4.puzzle.maze.MazeGenerator$;
import com.barrybecker4.puzzle.maze.model.GenState;
import com.barrybecker4.puzzle.maze.model.MazeCell;
import com.barrybecker4.puzzle.maze.model.MazeModel;
import com.barrybecker4.puzzle.maze.model.Probabilities;
import com.barrybecker4.puzzle.maze.model.StateStack;
import com.barrybecker4.puzzle.maze.ui.MazePanel;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005eq!\u0002\u000e\u001c\u0011\u0003!c!\u0002\u0014\u001c\u0011\u00039\u0003\"\u0002\u0018\u0002\t\u0003y\u0003b\u0002\u0019\u0002\u0005\u0004%I!\r\u0005\u0007k\u0005\u0001\u000b\u0011\u0002\u001a\u0007\t\u0019Z\u0002A\u000e\u0005\to\u0015\u0011)\u0019!C\u0001q!Aq(\u0002B\u0001B\u0003%\u0011\bC\u0003/\u000b\u0011\u0005\u0001\tC\u0004\u001d\u000b\t\u0007I\u0011B\"\t\r)+\u0001\u0015!\u0003E\u0011%YU\u00011AA\u0002\u0013%A\nC\u0005Q\u000b\u0001\u0007\t\u0019!C\u0005#\"Iq+\u0002a\u0001\u0002\u0003\u0006K!\u0014\u0005\b1\u0016\u0001\r\u0011\"\u00032\u0011\u001dIV\u00011A\u0005\niCa\u0001X\u0003!B\u0013\u0011\u0004bB/\u0006\u0001\u0004%IA\u0018\u0005\bE\u0016\u0001\r\u0011\"\u0003d\u0011\u0019)W\u0001)Q\u0005?\")a-\u0002C\u0001O\")\u0011/\u0002C\u0001e\")1/\u0002C\u0001e\")A/\u0002C\u0005k\")10\u0002C\u0005y\"1\u0011qC\u0003\u0005\nI\fQ\"T1{K\u001e+g.\u001a:bi>\u0014(B\u0001\u000f\u001e\u0003\u0011i\u0017M_3\u000b\u0005yy\u0012A\u00029vujdWM\u0003\u0002!C\u0005a!-\u0019:ss\n,7m[3si)\t!%A\u0002d_6\u001c\u0001\u0001\u0005\u0002&\u00035\t1DA\u0007NCj,w)\u001a8fe\u0006$xN]\n\u0003\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001%\u0003E\u0019FjT,`'B+U\tR0U\u0011J+5\u000bS\u000b\u0002eA\u0011\u0011fM\u0005\u0003i)\u00121!\u00138u\u0003I\u0019FjT,`'B+U\tR0U\u0011J+5\u000b\u0013\u0011\u0014\u0005\u0015A\u0013!\u00029b]\u0016dW#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005qZ\u0012AA;j\u0013\tq4HA\u0005NCj,\u0007+\u00198fY\u00061\u0001/\u00198fY\u0002\"\"!\u0011\"\u0011\u0005\u0015*\u0001\"B\u001c\t\u0001\u0004IT#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d[\u0012!B7pI\u0016d\u0017BA%G\u0005%i\u0015M_3N_\u0012,G.A\u0003nCj,\u0007%A\u0003ti\u0006\u001c7.F\u0001N!\t)e*\u0003\u0002P\r\nQ1\u000b^1uKN#\u0018mY6\u0002\u0013M$\u0018mY6`I\u0015\fHC\u0001*V!\tI3+\u0003\u0002UU\t!QK\\5u\u0011\u001d1F\"!AA\u00025\u000b1\u0001\u001f\u00132\u0003\u0019\u0019H/Y2lA\u0005AQ.\u0019=EKB$\b.\u0001\u0007nCb$U\r\u001d;i?\u0012*\u0017\u000f\u0006\u0002S7\"9akDA\u0001\u0002\u0004\u0011\u0014!C7bq\u0012+\u0007\u000f\u001e5!\u0003-Ig\u000e^3seV\u0004H/\u001a3\u0016\u0003}\u0003\"!\u000b1\n\u0005\u0005T#a\u0002\"p_2,\u0017M\\\u0001\u0010S:$XM\u001d:vaR,Gm\u0018\u0013fcR\u0011!\u000b\u001a\u0005\b-J\t\t\u00111\u0001`\u00031Ig\u000e^3seV\u0004H/\u001a3!\u0003!9WM\\3sCR,G\u0003\u0002*i[>DQ!\u001b\u000bA\u0002)\f1BZ8so\u0006\u0014H\r\u0015:pEB\u0011\u0011f[\u0005\u0003Y*\u0012a\u0001R8vE2,\u0007\"\u00028\u0015\u0001\u0004Q\u0017\u0001\u00037fMR\u0004&o\u001c2\t\u000bA$\u0002\u0019\u00016\u0002\u0013ILw\r\u001b;Qe>\u0014\u0017AB:fCJ\u001c\u0007\u000eF\u0001S\u0003%Ig\u000e^3seV\u0004H/\u0001\u0007gS:$g*\u001a=u\u0007\u0016dG\u000e\u0006\u0002wsB\u0011Qi^\u0005\u0003q\u001a\u0013\u0001\"T1{K\u000e+G\u000e\u001c\u0005\u0006u^\u0001\rA^\u0001\tY\u0006\u001cHoQ3mY\u00069\u0011\r\u001a3XC2dG#\u0002*~\u007f\u0006M\u0001\"\u0002@\u0019\u0001\u00041\u0018aC2veJ,g\u000e^\"fY2Dq!!\u0001\u0019\u0001\u0004\t\u0019!A\u0002eSJ\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0005hK>lW\r\u001e:z\u0015\r\tiaH\u0001\u0007G>lWn\u001c8\n\t\u0005E\u0011q\u0001\u0002\t\u0019>\u001c\u0017\r^5p]\"1\u0011Q\u0003\rA\u0002Y\f\u0001B\\3yi\u000e+G\u000e\\\u0001\be\u00164'/Z:i\u0001")
public class MazeGenerator {
    private final MazePanel panel;
    private final MazeModel maze;
    private StateStack stack;
    private int maxDepth;
    private boolean interrupted;

    public MazePanel panel() {
        return this.panel;
    }

    private MazeModel maze() {
        return this.maze;
    }

    private StateStack stack() {
        return this.stack;
    }

    private void stack_$eq(StateStack x$1) {
        this.stack = x$1;
    }

    private int maxDepth() {
        return this.maxDepth;
    }

    private void maxDepth_$eq(int x$1) {
        this.maxDepth = x$1;
    }

    private boolean interrupted() {
        return this.interrupted;
    }

    private void interrupted_$eq(boolean x$1) {
        this.interrupted = x$1;
    }

    public void generate(double forwardProb, double leftProb, double rightProb) {
        this.maxDepth_$eq(0);
        Probabilities probs = new Probabilities(forwardProb, leftProb, rightProb);
        this.stack_$eq(new StateStack(probs));
        this.search();
        this.panel().repaint();
    }

    public void search() {
        this.stack().clear();
        Location currentPosition = this.maze().startPosition();
        MazeCell currentCell = this.maze().getCell(currentPosition);
        currentCell.visited_$eq(true);
        this.stack().pushMoves(currentPosition, (Location)new IntLocation(0, 1), 0);
        while (!this.stack().isEmpty() && !this.interrupted()) {
            currentCell = this.findNextCell(currentCell);
        }
    }

    public void interrupt() {
        block0: {
            this.interrupted_$eq(true);
            if (this.stack() == null) break block0;
            this.stack().clear();
        }
    }

    private MazeCell findNextCell(MazeCell lastCell) {
        MazeCell nextCell;
        block5: {
            boolean moved = false;
            Location currentPosition = null;
            nextCell = null;
            int depth = -1;
            Location dir = null;
            do {
                GenState state = this.stack().pop();
                currentPosition = state.position();
                dir = state.getRelativeMovement();
                depth = state.depth();
                if (depth > this.maxDepth()) {
                    this.maxDepth_$eq(depth);
                    this.maze().stopPosition_$eq(currentPosition);
                }
                if (depth > lastCell.depth()) {
                    lastCell.depth_$eq(depth);
                }
                MazeCell currentCell = this.maze().getCell(currentPosition);
                Location nextPosition = currentCell.getNextPosition(currentPosition, dir);
                nextCell = this.maze().getCell(nextPosition);
                if (nextCell.visited()) {
                    this.addWall(currentCell, dir, nextCell);
                } else {
                    moved = true;
                    nextCell.visited_$eq(true);
                    currentPosition = nextPosition;
                }
                this.refresh();
            } while (!moved && !this.stack().isEmpty() && !this.interrupted());
            this.refresh();
            if (!moved || this.interrupted()) break block5;
            this.stack().pushMoves(currentPosition, dir, depth + 1);
        }
        return nextCell;
    }

    private void addWall(MazeCell currentCell, Location dir, MazeCell nextCell) {
        block1: {
            block3: {
                block2: {
                    block0: {
                        if (dir.getX() != 1) break block0;
                        currentCell.eastWall_$eq(true);
                        break block1;
                    }
                    if (dir.getY() != 1) break block2;
                    currentCell.southWall_$eq(true);
                    break block1;
                }
                if (dir.getX() != -1) break block3;
                nextCell.eastWall_$eq(true);
                break block1;
            }
            if (dir.getY() != -1) break block1;
            nextCell.southWall_$eq(true);
        }
    }

    private void refresh() {
        block1: {
            int speed = this.panel().animationSpeed();
            if (!(MathUtil$.MODULE$.RANDOM().nextDouble() < 2.0 / (double)speed)) break block1;
            this.panel().paintAll();
            if (speed < MazeGenerator$.MODULE$.com$barrybecker4$puzzle$maze$MazeGenerator$$SLOW_SPEED_THRESH()) {
                int diff = MazeGenerator$.MODULE$.com$barrybecker4$puzzle$maze$MazeGenerator$$SLOW_SPEED_THRESH() - speed;
                ThreadUtil$.MODULE$.sleep(diff * diff * 6);
            }
        }
    }

    public MazeGenerator(MazePanel panel) {
        this.panel = panel;
        this.maze = panel.maze();
        this.maxDepth = 0;
        this.interrupted = false;
    }
}

