/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.puzzle.maze;

import com.barrybecker4.common.geometry.IntLocation;
import com.barrybecker4.common.geometry.Location;
import com.barrybecker4.puzzle.maze.model.GenState;
import com.barrybecker4.puzzle.maze.model.MazeCell;
import com.barrybecker4.puzzle.maze.model.MazeModel;
import com.barrybecker4.puzzle.maze.model.StateStack;
import com.barrybecker4.puzzle.maze.model.StateStack$;
import com.barrybecker4.puzzle.maze.ui.MazePanel;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001B\u000b\u0017\u0001}A\u0001B\n\u0001\u0003\u0002\u0004%\ta\n\u0005\t]\u0001\u0011\t\u0019!C\u0001_!AQ\u0007\u0001B\u0001B\u0003&\u0001\u0006C\u00037\u0001\u0011\u0005q\u0007C\u0004\u0018\u0001\t\u0007I\u0011B\u001e\t\r\t\u0003\u0001\u0015!\u0003=\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Ca\u0001\u0013\u0001!\u0002\u0013)\u0005bB%\u0001\u0001\u0004%\tA\u0013\u0005\b\u001d\u0002\u0001\r\u0011\"\u0001P\u0011\u0019\t\u0006\u0001)Q\u0005\u0017\"9!\u000b\u0001a\u0001\n\u0013Q\u0005bB*\u0001\u0001\u0004%I\u0001\u0016\u0005\u0007-\u0002\u0001\u000b\u0015B&\t\u000b]\u0003A\u0011\u0001-\t\u000be\u0003A\u0011\u0001-\t\u000bi\u0003A\u0011\u0002-\t\u000bm\u0003A\u0011\u0002/\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006!9\u00111\u0003\u0001\u0005\n\u0005U!AC'bu\u0016\u001cv\u000e\u001c<fe*\u0011q\u0003G\u0001\u0005[\u0006TXM\u0003\u0002\u001a5\u00051\u0001/\u001e>{Y\u0016T!a\u0007\u000f\u0002\u0019\t\f'O]=cK\u000e\\WM\u001d\u001b\u000b\u0003u\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0001\u0018M\\3m+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u0017\u0003\t)\u0018.\u0003\u0002.U\tIQ*\u0019>f!\u0006tW\r\\\u0001\na\u0006tW\r\\0%KF$\"\u0001M\u001a\u0011\u0005\u0005\n\u0014B\u0001\u001a#\u0005\u0011)f.\u001b;\t\u000fQ\u0012\u0011\u0011!a\u0001Q\u0005\u0019\u0001\u0010J\u0019\u0002\rA\fg.\u001a7!\u0003\u0019a\u0014N\\5u}Q\u0011\u0001H\u000f\t\u0003s\u0001i\u0011A\u0006\u0005\u0006M\u0011\u0001\r\u0001K\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011qHF\u0001\u0006[>$W\r\\\u0005\u0003\u0003z\u0012\u0011\"T1{K6{G-\u001a7\u0002\u000b5\f'0\u001a\u0011\u0002\u000bM$\u0018mY6\u0016\u0003\u0015\u0003\"!\u0010$\n\u0005\u001ds$AC*uCR,7\u000b^1dW\u000611\u000f^1dW\u0002\n\u0011\"[:X_J\\\u0017N\\4\u0016\u0003-\u0003\"!\t'\n\u00055\u0013#a\u0002\"p_2,\u0017M\\\u0001\u000eSN<vN]6j]\u001e|F%Z9\u0015\u0005A\u0002\u0006b\u0002\u001b\u000b\u0003\u0003\u0005\raS\u0001\u000bSN<vN]6j]\u001e\u0004\u0013aC5oi\u0016\u0014(/\u001e9uK\u0012\fq\"\u001b8uKJ\u0014X\u000f\u001d;fI~#S-\u001d\u000b\u0003aUCq\u0001N\u0007\u0002\u0002\u0003\u00071*\u0001\u0007j]R,'O];qi\u0016$\u0007%A\u0005j]R,'O];qiR\t\u0001'A\u0003t_24X-\u0001\u0007gS:$7k\u001c7vi&|g.\u0001\u0004tK\u0006\u00148\r\u001b\u000b\u0007;F\u001c\bP_@\u0011\u0007y3\u0017N\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!MH\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!!\u001a\u0012\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\u0005\u0019&\u001cHO\u0003\u0002fEA\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\tO\u0016|W.\u001a;ss*\u0011aNG\u0001\u0007G>lWn\u001c8\n\u0005A\\'\u0001\u0003'pG\u0006$\u0018n\u001c8\t\u000bI\u0014\u0002\u0019A/\u0002\u0019M|G.\u001e;j_:\u0004\u0016\r\u001e5\t\u000bQ\u0014\u0002\u0019A;\u0002\u0017\r,(O]3oi\u000e+G\u000e\u001c\t\u0003{YL!a\u001e \u0003\u00115\u000b'0Z\"fY2DQ!\u001f\nA\u0002%\f1\u0001Z5s\u0011\u0015Y(\u00031\u0001}\u0003\u0015!W\r\u001d;i!\t\tS0\u0003\u0002\u007fE\t\u0019\u0011J\u001c;\t\r\u0005\u0005!\u00031\u0001j\u00031qW\r\u001f;Q_NLG/[8o\u0003E\tGM^1oG\u0016$vNT3yi\u000e+G\u000e\u001c\u000b\fa\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty\u0001C\u0003u'\u0001\u0007Q\u000fC\u0003z'\u0001\u0007\u0011\u000eC\u0003|'\u0001\u0007A\u0010\u0003\u0004\u0002\u0002M\u0001\r!\u001b\u0005\u0007\u0003#\u0019\u0002\u0019A;\u0002\u00119,\u0007\u0010^\"fY2\f\u0011BY1dWR\u0013\u0018mY6\u0015\u0007u\u000b9\u0002C\u0003s)\u0001\u0007Q\f")
public class MazeSolver {
    private MazePanel panel;
    private final MazeModel maze;
    private final StateStack stack;
    private boolean isWorking;
    private boolean interrupted;

    public MazePanel panel() {
        return this.panel;
    }

    public void panel_$eq(MazePanel x$1) {
        this.panel = x$1;
    }

    private MazeModel maze() {
        return this.maze;
    }

    private StateStack stack() {
        return this.stack;
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public void isWorking_$eq(boolean x$1) {
        this.isWorking = x$1;
    }

    private boolean interrupted() {
        return this.interrupted;
    }

    private void interrupted_$eq(boolean x$1) {
        this.interrupted = x$1;
    }

    public void interrupt() {
        this.interrupted_$eq(true);
        this.stack().clear();
    }

    public void solve() {
        this.isWorking_$eq(true);
        this.interrupted_$eq(false);
        this.maze().unvisitAll();
        this.stack().clear();
        this.findSolution();
        this.panel().paintAll();
        this.isWorking_$eq(false);
    }

    private void findSolution() {
        List solutionPath = (List)package$.MODULE$.List().apply((Seq)Nil$.MODULE$);
        Location currentPosition = this.maze().startPosition();
        MazeCell currentCell = this.maze().getCell(currentPosition);
        this.stack().pushMoves(currentPosition, (Location)new IntLocation(0, 1), 0);
        this.panel().paintAll();
        Location dir = null;
        int depth = 0;
        boolean solved = false;
        while (!(this.stack().isEmpty() || solved || this.interrupted())) {
            GenState state = this.stack().pop();
            currentPosition = state.position();
            solutionPath = (List)solutionPath.$plus$colon((Object)currentPosition);
            Location location = currentPosition;
            Location location2 = this.maze().stopPosition();
            if (!(location != null ? !location.equals(location2) : location2 != null)) {
                solved = true;
            }
            dir = state.getRelativeMovement();
            depth = state.depth();
            if (depth > currentCell.depth()) {
                currentCell.depth_$eq(depth);
            }
            currentCell = this.maze().getCell(currentPosition);
            Location nextPosition = currentCell.getNextPosition(currentPosition, dir);
            this.search((List<Location>)solutionPath, currentCell, dir, depth, nextPosition);
        }
    }

    private List<Location> search(List<Location> solutionPath, MazeCell currentCell, Location dir, int depth, Location nextPosition) {
        boolean pathBlocked;
        List<Location> path = solutionPath;
        MazeCell nextCell = this.maze().getCell(nextPosition);
        boolean eastBlocked = dir.getX() == 1 && currentCell.eastWall();
        boolean westBlocked = dir.getX() == -1 && nextCell.eastWall();
        boolean southBlocked = dir.getY() == 1 && currentCell.southWall();
        boolean northBlocked = dir.getY() == -1 && nextCell.southWall();
        boolean bl = pathBlocked = eastBlocked || westBlocked || southBlocked || northBlocked;
        if (!pathBlocked) {
            this.advanceToNextCell(currentCell, dir, depth, nextPosition, nextCell);
        } else {
            path = this.backTrack(path);
        }
        return path;
    }

    private void advanceToNextCell(MazeCell currentCell, Location dir, int depth, Location nextPosition, MazeCell nextCell) {
        Location currentPosition = null;
        if (dir.getX() == 1) {
            currentCell.eastPath_$eq(true);
            nextCell.westPath_$eq(true);
        } else if (dir.getY() == 1) {
            currentCell.southPath_$eq(true);
            nextCell.northPath_$eq(true);
        } else if (dir.getX() == -1) {
            currentCell.westPath_$eq(true);
            nextCell.eastPath_$eq(true);
        } else if (dir.getY() == -1) {
            currentCell.northPath_$eq(true);
            nextCell.southPath_$eq(true);
        }
        nextCell.visited_$eq(true);
        currentPosition = nextPosition;
        this.stack().pushMoves(currentPosition, dir, depth + 1);
        this.panel().paintCell(currentPosition);
    }

    /*
     * WARNING - void declaration
     */
    private List<Location> backTrack(List<Location> solutionPath) {
        void var3_3;
        GenState lastState = this.stack().peek();
        List path = solutionPath;
        Location pos = null;
        do {
            pos = (Location)path.head();
            path = (List)path.tail();
            MazeCell cell = this.maze().getCell(pos);
            cell.clearPath();
        } while (pos != lastState.position());
        return var3_3;
    }

    public MazeSolver(MazePanel panel) {
        this.panel = panel;
        this.maze = this.panel().maze();
        this.stack = new StateStack(StateStack$.MODULE$.$lessinit$greater$default$1());
        this.isWorking = false;
        this.interrupted = false;
    }
}

