/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.puzzle.maze.model;

import com.barrybecker4.common.geometry.IntLocation;
import com.barrybecker4.common.geometry.Location;
import com.barrybecker4.puzzle.maze.model.MazeCell;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005Y4A\u0001G\r\u0001I!A1\u0006\u0001BA\u0002\u0013\u0005A\u0006\u0003\u00051\u0001\t\u0005\r\u0011\"\u00012\u0011!9\u0004A!A!B\u0013i\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0007I\u0011\u0001\u0017\t\u0011e\u0002!\u00111A\u0005\u0002iB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006K!\f\u0005\u0006{\u0001!\tA\u0010\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\n\u0011C\u0011\u0002\u0014\u0001A\u0002\u0003\u0007I\u0011B'\t\u0013=\u0003\u0001\u0019!A!B\u0013)\u0005b\u0002)\u0001\u0005\u0004%\t!\u0015\u0005\u00075\u0002\u0001\u000b\u0011\u0002*\t\u0013m\u0003\u0001\u0019!a\u0001\n\u0003\t\u0006\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0001^\u0011%y\u0006\u00011A\u0001B\u0003&!\u000bC\u0003a\u0001\u0011\u0005\u0011\rC\u0003e\u0001\u0011%Q\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003i\u0001\u0011\u0005A\u000eC\u0003r\u0001\u0011\u0005!\u000fC\u0003t\u0001\u0011%!\u000fC\u0003u\u0001\u0011%!\u000fC\u0003v\u0001\u0011%!OA\u0005NCj,Wj\u001c3fY*\u0011!dG\u0001\u0006[>$W\r\u001c\u0006\u00039u\tA!\\1{K*\u0011adH\u0001\u0007aVT(\u0010\\3\u000b\u0005\u0001\n\u0013\u0001\u00042beJL(-Z2lKJ$$\"\u0001\u0012\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g-A\u0003xS\u0012$\b.F\u0001.!\t1c&\u0003\u00020O\t\u0019\u0011J\u001c;\u0002\u0013]LG\r\u001e5`I\u0015\fHC\u0001\u001a6!\t13'\u0003\u00025O\t!QK\\5u\u0011\u001d1$!!AA\u00025\n1\u0001\u001f\u00132\u0003\u00199\u0018\u000e\u001a;iA\u00051\u0001.Z5hQR\f!\u0002[3jO\"$x\fJ3r)\t\u00114\bC\u00047\u000b\u0005\u0005\t\u0019A\u0017\u0002\u000f!,\u0017n\u001a5uA\u00051A(\u001b8jiz\"2aP!C!\t\u0001\u0005!D\u0001\u001a\u0011\u0015Ys\u00011\u0001.\u0011\u0015At\u00011\u0001.\u0003\u00119'/\u001b3\u0016\u0003\u0015\u00032A\n$I\u0013\t9uEA\u0003BeJ\f\u0017\u0010E\u0002'\r&\u0003\"\u0001\u0011&\n\u0005-K\"\u0001C'bu\u0016\u001cU\r\u001c7\u0002\u0011\u001d\u0014\u0018\u000eZ0%KF$\"A\r(\t\u000fYJ\u0011\u0011!a\u0001\u000b\u0006)qM]5eA\u0005i1\u000f^1siB{7/\u001b;j_:,\u0012A\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000b\u0001bZ3p[\u0016$(/\u001f\u0006\u0003/~\taaY8n[>t\u0017BA-U\u0005!aunY1uS>t\u0017AD:uCJ$\bk\\:ji&|g\u000eI\u0001\rgR|\u0007\u000fU8tSRLwN\\\u0001\u0011gR|\u0007\u000fU8tSRLwN\\0%KF$\"A\r0\t\u000fYr\u0011\u0011!a\u0001%\u0006i1\u000f^8q!>\u001c\u0018\u000e^5p]\u0002\nQb]3u\t&lWM\\:j_:\u001cHc\u0001\u001acG\")1\u0006\u0005a\u0001[!)\u0001\b\u0005a\u0001[\u0005Q1M]3bi\u0016<%/\u001b3\u0015\u0007\u00153w\rC\u0003,#\u0001\u0007Q\u0006C\u00039#\u0001\u0007Q&A\u0004hKR\u001cU\r\u001c7\u0015\u0005%S\u0007\"B6\u0013\u0001\u0004\u0011\u0016!\u00019\u0015\u0007%kw\u000eC\u0003o'\u0001\u0007Q&A\u0001y\u0011\u0015\u00018\u00031\u0001.\u0003\u0005I\u0018AC;om&\u001c\u0018\u000e^!mYR\t!'\u0001\btKR\u001cuN\\:ue\u0006Lg\u000e^:\u0002/M,GOU5hQRdUM\u001a;D_:\u001cHO]1j]R\u001c\u0018AG:fiR{\u0007/\u00118e\u0005>$Ho\\7D_:\u001cHO]1j]R\u001c\b")
public class MazeModel {
    private int width;
    private int height;
    private MazeCell[][] grid;
    private final Location startPosition;
    private Location stopPosition;

    public int width() {
        return this.width;
    }

    public void width_$eq(int x$1) {
        this.width = x$1;
    }

    public int height() {
        return this.height;
    }

    public void height_$eq(int x$1) {
        this.height = x$1;
    }

    private MazeCell[][] grid() {
        return this.grid;
    }

    private void grid_$eq(MazeCell[][] x$1) {
        this.grid = x$1;
    }

    public Location startPosition() {
        return this.startPosition;
    }

    public Location stopPosition() {
        return this.stopPosition;
    }

    public void stopPosition_$eq(Location x$1) {
        this.stopPosition = x$1;
    }

    public void setDimensions(int width, int height) {
        this.width_$eq(width);
        this.height_$eq(height);
        this.grid_$eq(this.createGrid(width, height));
        this.setConstraints();
    }

    /*
     * WARNING - void declaration
     */
    private MazeCell[][] createGrid(int width, int height) {
        void var3_3;
        MazeCell[][] grid = (MazeCell[][])Array$.MODULE$.ofDim(width, height, ClassTag$.MODULE$.apply(MazeCell.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            grid$1[i][j$1] = new MazeCell();
        }));
        return var3_3;
    }

    public MazeCell getCell(Location p) {
        return this.getCell(p.getX(), p.getY());
    }

    public MazeCell getCell(int x, int y) {
        Predef$.MODULE$.assert(x < this.width(), (Function0 & Serializable)() -> new StringBuilder(31).append("Tried to get x = ").append(x).append(" when width = ").append(this.width()).toString());
        Predef$.MODULE$.assert(y < this.height(), (Function0 & Serializable)() -> new StringBuilder(32).append("Tried to get y = ").append(y).append(" when height = ").append(this.height()).toString());
        return this.grid()[x][y];
    }

    public void unvisitAll() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            MazeCell c = this.grid()[i][j];
            c.clear();
        }));
    }

    private void setConstraints() {
        this.setRightLeftConstraints();
        this.setTopAndBottomConstraints();
    }

    private void setRightLeftConstraints() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            MazeCell cell = this.grid()[0][j];
            cell.visited_$eq(true);
            cell = this.grid()[this.width() - 1][j];
            cell.visited_$eq(true);
        });
    }

    private void setTopAndBottomConstraints() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            MazeCell cell = this.grid()[i][0];
            cell.visited_$eq(true);
            cell = this.grid()[i][this.height() - 1];
            cell.visited_$eq(true);
        });
    }

    public MazeModel(int width, int height) {
        this.width = width;
        this.height = height;
        this.setDimensions(this.width(), this.height());
        this.startPosition = new IntLocation(2, 2);
    }
}

