/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.puzzle.maze.ui;

import com.barrybecker4.common.concurrency.ThreadUtil$;
import com.barrybecker4.common.geometry.Location;
import com.barrybecker4.math.MathUtil$;
import com.barrybecker4.puzzle.maze.model.MazeModel;
import com.barrybecker4.puzzle.maze.ui.MazeRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005)4A\u0001E\t\u00019!)Q\u0005\u0001C\u0001M!9A\u0003\u0001b\u0001\n\u0003I\u0003B\u0002\u0019\u0001A\u0003%!\u0006C\u00042\u0001\t\u0007I\u0011\u0002\u001a\t\rY\u0002\u0001\u0015!\u00034\u0011\u001d9\u0004\u00011A\u0005\u0002aBqa\u0010\u0001A\u0002\u0013\u0005\u0001\t\u0003\u0004G\u0001\u0001\u0006K!\u000f\u0005\b\u000f\u0002\u0001\r\u0011\"\u00039\u0011\u001dA\u0005\u00011A\u0005\n%Caa\u0013\u0001!B\u0013I\u0004\"\u0002'\u0001\t\u0003i\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u0002*\u0001\t\u0003\u0019\u0006\"\u00020\u0001\t\u0003z&!C'bu\u0016\u0004\u0016M\\3m\u0015\t\u00112#\u0001\u0002vS*\u0011A#F\u0001\u0005[\u0006TXM\u0003\u0002\u0017/\u00051\u0001/\u001e>{Y\u0016T!\u0001G\r\u0002\u0019\t\f'O]=cK\u000e\\WM\u001d\u001b\u000b\u0003i\t1aY8n\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013!B:xS:<'\"\u0001\u0012\u0002\u000b)\fg/\u0019=\n\u0005\u0011z\"A\u0003&D_6\u0004xN\\3oi\u00061A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011!E\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011QfE\u0001\u0006[>$W\r\\\u0005\u0003_1\u0012\u0011\"T1{K6{G-\u001a7\u0002\u000b5\f'0\u001a\u0011\u0002\u0011I,g\u000eZ3sKJ,\u0012a\r\t\u0003QQJ!!N\t\u0003\u00195\u000b'0\u001a*f]\u0012,'/\u001a:\u0002\u0013I,g\u000eZ3sKJ\u0004\u0013AD1oS6\fG/[8o'B,W\rZ\u000b\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t\u0019\u0011J\u001c;\u0002%\u0005t\u0017.\\1uS>t7\u000b]3fI~#S-\u001d\u000b\u0003\u0003\u0012\u0003\"A\u000f\"\n\u0005\r[$\u0001B+oSRDq!R\u0004\u0002\u0002\u0003\u0007\u0011(A\u0002yIE\nq\"\u00198j[\u0006$\u0018n\u001c8Ta\u0016,G\rI\u0001\tG\u0016dGnU5{K\u0006a1-\u001a7m'&TXm\u0018\u0013fcR\u0011\u0011I\u0013\u0005\b\u000b*\t\t\u00111\u0001:\u0003%\u0019W\r\u001c7TSj,\u0007%\u0001\u0007tKR$\u0006.[2l]\u0016\u001c8\u000f\u0006\u0002B\u001d\")q\n\u0004a\u0001s\u0005IA\u000f[5dW:,7o]\u0001\ta\u0006Lg\u000e^!mYR\t\u0011)A\u0005qC&tGoQ3mYR\u0011\u0011\t\u0016\u0005\u0006+:\u0001\rAV\u0001\u0006a>Lg\u000e\u001e\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000b\u0001bZ3p[\u0016$(/\u001f\u0006\u00037^\taaY8n[>t\u0017BA/Y\u0005!aunY1uS>t\u0017A\u00049bS:$8i\\7q_:,g\u000e\u001e\u000b\u0003\u0003\u0002DQ!Y\bA\u0002\t\f\u0011a\u001a\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f1!Y<u\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\u0011\u001d\u0013\u0018\r\u001d5jGN\u0004")
public class MazePanel
extends JComponent {
    private final MazeModel maze = new MazeModel(100, 100);
    private final MazeRenderer renderer = new MazeRenderer();
    private int animationSpeed = 0;
    private int cellSize = 0;

    public MazeModel maze() {
        return this.maze;
    }

    private MazeRenderer renderer() {
        return this.renderer;
    }

    public int animationSpeed() {
        return this.animationSpeed;
    }

    public void animationSpeed_$eq(int x$1) {
        this.animationSpeed = x$1;
    }

    private int cellSize() {
        return this.cellSize;
    }

    private void cellSize_$eq(int x$1) {
        this.cellSize = x$1;
    }

    public void setThickness(int thickness) {
        Dimension dim = this.getSize();
        if (dim.width <= 0 || dim.height < 0) {
            return;
        }
        this.cellSize_$eq(thickness);
        this.renderer().setCellSize(this.cellSize());
        int width = dim.width / thickness;
        int height = dim.height / thickness;
        this.maze().setDimensions(width, height);
    }

    public void paintAll() {
        Dimension d = this.getSize();
        this.paintImmediately(0, 0, (int)d.getWidth(), (int)d.getHeight());
    }

    public void paintCell(Location point) {
        block1: {
            int ypos;
            int xpos;
            int csized2;
            block0: {
                csized2 = this.cellSize() / 2 + 2;
                xpos = point.getX() * this.cellSize();
                ypos = point.getY() * this.cellSize();
                if (this.animationSpeed() > 10) break block0;
                this.paintImmediately(xpos - csized2, ypos - csized2, 2 * this.cellSize(), 2 * this.cellSize());
                if (this.animationSpeed() >= 9) break block1;
                ThreadUtil$.MODULE$.sleep(400 / this.animationSpeed() - 40);
                break block1;
            }
            double rand = MathUtil$.MODULE$.RANDOM().nextDouble();
            if (!(rand < 1.0 / (double)this.animationSpeed())) break block1;
            this.repaint(xpos - csized2, ypos - csized2, 2 * this.cellSize(), 2 * this.cellSize());
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.renderer().render((Graphics2D)g, this.maze());
    }
}

