/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.puzzle.maze.ui;

import com.barrybecker4.puzzle.maze.model.MazeCell;
import com.barrybecker4.puzzle.maze.model.MazeModel;
import com.barrybecker4.puzzle.maze.ui.MazeRenderer$;
import com.barrybecker4.ui.util.GUIUtil$;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Uu!\u0002\u0017.\u0011\u0003Ad!\u0002\u001e.\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005b\u0002#\u0002\u0005\u0004%I!\u0012\u0005\u0007\u001d\u0006\u0001\u000b\u0011\u0002$\t\u000f=\u000b!\u0019!C\u0005\u000b\"1\u0001+\u0001Q\u0001\n\u0019Cq!U\u0001C\u0002\u0013%Q\t\u0003\u0004S\u0003\u0001\u0006IA\u0012\u0005\b'\u0006\u0011\r\u0011\"\u0003F\u0011\u0019!\u0016\u0001)A\u0005\r\"9Q+\u0001b\u0001\n\u0013)\u0005B\u0002,\u0002A\u0003%a\tC\u0004X\u0003\t\u0007I\u0011\u0002-\t\rq\u000b\u0001\u0015!\u0003Z\u0011\u001di\u0016A1A\u0005\naCaAX\u0001!\u0002\u0013I\u0006bB0\u0002\u0005\u0004%I\u0001\u0017\u0005\u0007A\u0006\u0001\u000b\u0011B-\t\u000b\u0005\fA\u0011\u00022\u0007\u000bij\u0003!!\u0003\t\r\t#B\u0011AA\u0006\u0011\u001dqH\u00031A\u0005\naC\u0011\"a\u0004\u0015\u0001\u0004%I!!\u0005\t\u000f\u0005]A\u0003)Q\u00053\"A\u0011\u0011\u0004\u000bA\u0002\u0013%\u0001\fC\u0005\u0002\u001cQ\u0001\r\u0011\"\u0003\u0002\u001e!9\u0011\u0011\u0005\u000b!B\u0013I\u0006bCA\u0012)\u0001\u0007\t\u0019!C\u0005\u0003KA1\"!\f\u0015\u0001\u0004\u0005\r\u0011\"\u0003\u00020!Y\u00111\u0007\u000bA\u0002\u0003\u0005\u000b\u0015BA\u0014\u0011-\t)\u0004\u0006a\u0001\u0002\u0004%I!!\n\t\u0017\u0005]B\u00031AA\u0002\u0013%\u0011\u0011\b\u0005\f\u0003{!\u0002\u0019!A!B\u0013\t9\u0003C\u0006\u0002@Q\u0001\r\u00111A\u0005\n\u0005\u0005\u0003bCA%)\u0001\u0007\t\u0019!C\u0005\u0003\u0017B1\"a\u0014\u0015\u0001\u0004\u0005\t\u0015)\u0003\u0002D!9\u0011\u0011\u000b\u000b\u0005\u0002\u0005M\u0003bBA-)\u0011\u0005\u00111\f\u0005\b\u0003[\"B\u0011BA8\u0011\u001d\t)\b\u0006C\u0005\u0003oBq!! \u0015\t\u0013\ty\bC\u0004\u0002\u0006R!I!a\"\t\u000f\u00055E\u0003\"\u0003\u0002\u0010\u0006aQ*\u0019>f%\u0016tG-\u001a:fe*\u0011afL\u0001\u0003k&T!\u0001M\u0019\u0002\t5\f'0\u001a\u0006\u0003eM\na\u0001];{u2,'B\u0001\u001b6\u00031\u0011\u0017M\u001d:zE\u0016\u001c7.\u001a:5\u0015\u00051\u0014aA2p[\u000e\u0001\u0001CA\u001d\u0002\u001b\u0005i#\u0001D'bu\u0016\u0014VM\u001c3fe\u0016\u00148CA\u0001=!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001O\u0001\u000b/\u0006cEjX\"P\u0019>\u0013V#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015aA1xi*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0015\u0019u\u000e\\8s\u0003-9\u0016\t\u0014'`\u0007>cuJ\u0015\u0011\u0002\u0015A\u000bE\u000bS0D\u001f2{%+A\u0006Q\u0003RCulQ(M\u001fJ\u0003\u0013A\u0003+F1R{6i\u0014'P%\u0006YA+\u0012-U?\u000e{Ej\u0014*!\u0003!\u0011uiX\"P\u0019>\u0013\u0016!\u0003\"H?\u000e{Ej\u0014*!\u000351\u0016jU%U\u000b\u0012{6i\u0014'P%\u0006qa+S*J)\u0016#ulQ(M\u001fJ\u0003\u0013aD,B\u00192{F*\u0013(F?^KE\t\u0016%\u0016\u0003e\u0003\"!\u0010.\n\u0005ms$aA%oi\u0006\u0001r+\u0011'M?2Ke*R0X\u0013\u0012#\u0006\nI\u0001\u0010!\u0006#\u0006j\u0018'J\u001d\u0016{v+\u0013#U\u0011\u0006\u0001\u0002+\u0011+I?2Ke*R0X\u0013\u0012#\u0006\nI\u0001\u0012\t\u00163\u0015)\u0016'U?\u000e+E\nT0T\u0013j+\u0015A\u0005#F\r\u0006+F\nV0D\u000b2culU%[\u000b\u0002\n\u0001\u0002\u001a:bo\u000eC\u0017M\u001d\u000b\u0006G\u001a\u001cXp \t\u0003{\u0011L!!\u001a \u0003\tUs\u0017\u000e\u001e\u0005\u0006ON\u0001\r\u0001[\u0001\u0002GB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a\u001b \u000e\u00031T!!\\\u001c\u0002\rq\u0012xn\u001c;?\u0013\tyg(\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8?\u0011\u0015!8\u00031\u0001v\u0003\r\u0001xn\u001d\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f\u0001bZ3p[\u0016$(/\u001f\u0006\u0003uN\naaY8n[>t\u0017B\u0001?x\u0005!aunY1uS>t\u0007\"\u0002@\u0014\u0001\u0004I\u0016\u0001C2fY2\u001c\u0016N_3\t\u000f\u0005\u00051\u00031\u0001\u0002\u0004\u0005\u0011qM\r\t\u0004\u000f\u0006\u0015\u0011bAA\u0004\u0011\nQqI]1qQ&\u001c7O\r#\u0014\u0005QaDCAA\u0007!\tID#\u0001\u0007dK2d7+\u001b>f?\u0012*\u0017\u000fF\u0002d\u0003'A\u0001\"!\u0006\u0018\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\n\u0014!C2fY2\u001c\u0016N_3!\u00031A\u0017\r\u001c4DK2d7+\u001b>f\u0003AA\u0017\r\u001c4DK2d7+\u001b>f?\u0012*\u0017\u000fF\u0002d\u0003?A\u0001\"!\u0006\u001b\u0003\u0003\u0005\r!W\u0001\u000eQ\u0006dgmQ3mYNK'0\u001a\u0011\u0002\u0015]\fG\u000e\\*ue>\\W-\u0006\u0002\u0002(A\u0019q)!\u000b\n\u0007\u0005-\u0002JA\u0006CCNL7m\u0015;s_.,\u0017AD<bY2\u001cFO]8lK~#S-\u001d\u000b\u0004G\u0006E\u0002\"CA\u000b;\u0005\u0005\t\u0019AA\u0014\u0003-9\u0018\r\u001c7TiJ|7.\u001a\u0011\u0002\u0015A\fG\u000f[*ue>\\W-\u0001\bqCRD7\u000b\u001e:pW\u0016|F%Z9\u0015\u0007\r\fY\u0004C\u0005\u0002\u0016\u0001\n\t\u00111\u0001\u0002(\u0005Y\u0001/\u0019;i'R\u0014xn[3!\u0003!!X\r\u001f;G_:$XCAA\"!\r9\u0015QI\u0005\u0004\u0003\u000fB%\u0001\u0002$p]R\fA\u0002^3yi\u001a{g\u000e^0%KF$2aYA'\u0011%\t)bIA\u0001\u0002\u0004\t\u0019%A\u0005uKb$hi\u001c8uA\u0005Y1/\u001a;DK2d7+\u001b>f)\r\u0019\u0017Q\u000b\u0005\u0007\u0003/*\u0003\u0019A-\u0002\tML'0Z\u0001\u0007e\u0016tG-\u001a:\u0015\u000b\r\fi&a\u0018\t\u000f\u0005\u0005a\u00051\u0001\u0002\u0004!1\u0001G\na\u0001\u0003C\u0002B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003Oz\u0013!B7pI\u0016d\u0017\u0002BA6\u0003K\u0012\u0011\"T1{K6{G-\u001a7\u0002\u001d\u0011\u0014\u0018m\u001e\"bG.<'o\\;oIR)1-!\u001d\u0002t!9\u0011\u0011A\u0014A\u0002\u0005\r\u0001B\u0002\u0019(\u0001\u0004\t\t'\u0001\tee\u0006<h+[:ji\u0016$7)\u001a7mgR)1-!\u001f\u0002|!9\u0011\u0011\u0001\u0015A\u0002\u0005\r\u0001B\u0002\u0019)\u0001\u0004\t\t'A\u0005ee\u0006<x+\u00197mgR)1-!!\u0002\u0004\"9\u0011\u0011A\u0015A\u0002\u0005\r\u0001B\u0002\u0019*\u0001\u0004\t\t'\u0001\u0005ee\u0006<\b+\u0019;i)\u0015\u0019\u0017\u0011RAF\u0011\u001d\t\tA\u000ba\u0001\u0003\u0007Aa\u0001\r\u0016A\u0002\u0005\u0005\u0014a\u00043sC^\u001cF/\u0019:u\r&t\u0017n\u001d5\u0015\u000b\r\f\t*a%\t\u000f\u0005\u00051\u00061\u0001\u0002\u0004!1\u0001g\u000ba\u0001\u0003C\u0002")
public class MazeRenderer {
    private int cellSize;
    private int halfCellSize;
    private BasicStroke wallStroke;
    private BasicStroke pathStroke;
    private Font textFont;

    private int cellSize() {
        return this.cellSize;
    }

    private void cellSize_$eq(int x$1) {
        this.cellSize = x$1;
    }

    private int halfCellSize() {
        return this.halfCellSize;
    }

    private void halfCellSize_$eq(int x$1) {
        this.halfCellSize = x$1;
    }

    private BasicStroke wallStroke() {
        return this.wallStroke;
    }

    private void wallStroke_$eq(BasicStroke x$1) {
        this.wallStroke = x$1;
    }

    private BasicStroke pathStroke() {
        return this.pathStroke;
    }

    private void pathStroke_$eq(BasicStroke x$1) {
        this.pathStroke = x$1;
    }

    private Font textFont() {
        return this.textFont;
    }

    private void textFont_$eq(Font x$1) {
        this.textFont = x$1;
    }

    public void setCellSize(int size) {
        this.cellSize_$eq(size);
        this.halfCellSize_$eq((int)((double)this.cellSize() / 2.0));
        float lineWidth = (float)((double)(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$WALL_LINE_WIDTH() * this.cellSize()) / 30.0);
        float pathWidth = (float)((double)(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$PATH_LINE_WIDTH() * this.cellSize()) / 30.0);
        this.wallStroke_$eq(new BasicStroke(lineWidth));
        this.pathStroke_$eq(new BasicStroke(pathWidth, 2, 0));
        int fontSize = 2 + (this.cellSize() >> 1);
        this.textFont_$eq(new Font(GUIUtil$.MODULE$.DEFAULT_FONT_FAMILY(), 1, fontSize));
    }

    public void render(Graphics2D g2, MazeModel maze) {
        if (maze == null) {
            return;
        }
        this.drawBackground(g2, maze);
        this.drawVisitedCells(g2, maze);
        this.drawWalls(g2, maze);
        this.drawPath(g2, maze);
        this.drawStartFinish(g2, maze);
    }

    private void drawBackground(Graphics2D g2, MazeModel maze) {
        g2.setColor(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$BG_COLOR());
        int width = maze.width();
        int height = maze.height();
        g2.fillRect(0, 0, this.cellSize() * width, this.cellSize() * height);
    }

    private void drawVisitedCells(Graphics2D g2, MazeModel maze) {
        g2.setColor(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$VISITED_COLOR());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maze.height()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maze.width()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            block0: {
                MazeCell c = maze.getCell(i, j);
                Predef$.MODULE$.assert(c != null, (Function0 & Serializable)() -> new StringBuilder(34).append("Error1 pos i=").append(i).append(" j=").append(j).append(" is out of bounds.").toString());
                int xpos = i * this.cellSize();
                int ypos = j * this.cellSize();
                if (!c.visited()) break block0;
                g2.setColor(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$VISITED_COLOR());
                g2.fillRect(xpos + 1, ypos + 1, this.cellSize(), this.cellSize());
            }
        }));
    }

    private void drawWalls(Graphics2D g2, MazeModel maze) {
        g2.setStroke(this.wallStroke());
        g2.setColor(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$WALL_COLOR());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maze.height()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maze.width()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            block1: {
                MazeCell c = maze.getCell(i, j);
                Predef$.MODULE$.assert(c != null, (Function0 & Serializable)() -> new StringBuilder(34).append("Error2 pos i=").append(i).append(" j=").append(j).append(" is out of bounds.").toString());
                int xpos = i * this.cellSize();
                int ypos = j * this.cellSize();
                if (c.eastWall()) {
                    g2.drawLine(xpos + this.cellSize(), ypos, xpos + this.cellSize(), ypos + this.cellSize());
                }
                if (!c.southWall()) break block1;
                g2.drawLine(xpos, ypos + this.cellSize(), xpos + this.cellSize(), ypos + this.cellSize());
            }
        }));
    }

    private void drawPath(Graphics2D g2, MazeModel maze) {
        g2.setStroke(this.pathStroke());
        g2.setColor(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$PATH_COLOR());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maze.height()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), maze.width()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            block3: {
                MazeCell c = maze.getCell(i, j);
                int xpos = i * this.cellSize();
                int ypos = j * this.cellSize();
                Predef$.MODULE$.assert(c != null);
                if (c.eastPath()) {
                    g2.drawLine(xpos + this.halfCellSize(), ypos + this.halfCellSize(), xpos + this.cellSize(), ypos + this.halfCellSize());
                }
                if (c.westPath()) {
                    g2.drawLine(xpos, ypos + this.halfCellSize(), xpos + this.halfCellSize(), ypos + this.halfCellSize());
                }
                if (c.northPath()) {
                    g2.drawLine(xpos + this.halfCellSize(), ypos + this.halfCellSize(), xpos + this.halfCellSize(), ypos);
                }
                if (!c.southPath()) break block3;
                g2.drawLine(xpos + this.halfCellSize(), ypos + this.cellSize(), xpos + this.halfCellSize(), ypos + this.halfCellSize());
            }
        }));
    }

    private void drawStartFinish(Graphics2D g2, MazeModel maze) {
        g2.setFont(this.textFont());
        g2.setColor(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$TEXT_COLOR());
        MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$drawChar("S", maze.startPosition(), this.cellSize(), g2);
        MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$drawChar("F", maze.stopPosition(), this.cellSize(), g2);
    }

    public MazeRenderer() {
        this.setCellSize(MazeRenderer$.MODULE$.com$barrybecker4$puzzle$maze$ui$MazeRenderer$$DEFAULT_CELL_SIZE());
        this.cellSize = 0;
        this.halfCellSize = 0;
    }
}

