/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization;

import com.barrybecker4.common.format.FormatUtil$;
import com.barrybecker4.optimization.Logger$;
import com.barrybecker4.optimization.parameter.ParameterArray;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;

public class Logger {
    private String sLogFile;

    public static String SEPARATOR() {
        return Logger$.MODULE$.SEPARATOR();
    }

    public Logger(String sLogFile) {
        this.sLogFile = sLogFile;
        if (this.sLogFile() == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
    }

    public String sLogFile() {
        return this.sLogFile;
    }

    public void sLogFile_$eq(String x$1) {
        this.sLogFile = x$1;
    }

    public void initialize(ParameterArray params) {
        try {
            this.createDirIfNeeded(this.sLogFile());
            FileWriter logFile = new FileWriter(this.sLogFile(), false);
            logFile.write(new StringBuilder(9).append("iteration").append(Logger$.MODULE$.SEPARATOR()).toString());
            logFile.write(new StringBuilder(7).append("fitness").append(Logger$.MODULE$.SEPARATOR()).toString());
            logFile.write(new StringBuilder(8).append("jumpSize").append(Logger$.MODULE$.SEPARATOR()).toString());
            logFile.write(new StringBuilder(7).append("dotprod").append(Logger$.MODULE$.SEPARATOR()).toString());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), params.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> logFile.write(new StringBuilder(0).append(params.get(i).name()).append(Logger$.MODULE$.SEPARATOR()).toString()));
            logFile.write("comment ");
            logFile.write(10);
            logFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void createDirIfNeeded(String sLogFile) {
        String parentDirName = sLogFile.substring(0, sLogFile.lastIndexOf("/"));
        File parentDir = new File(parentDirName);
        if (!parentDir.exists()) {
            try {
                boolean success = parentDir.mkdir();
                Predef$.MODULE$.println((Object)new StringBuilder(27).append("Creation of ").append(parentDir).append(" was success = ").append(success).toString());
            }
            catch (IOException ioe) {
                Predef$.MODULE$.println((Object)new StringBuilder(23).append("IOException creating ").append(parentDir).append(". ").append(ioe.getMessage()).toString());
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    public final void write(int iteration, double fitness, double jumpSize, double distance, ParameterArray params, String comment) {
        String sep = Logger$.MODULE$.SEPARATOR();
        String rowText = new StringBuilder(24).append(iteration).append(sep).append(FormatUtil$.MODULE$.formatNumber(fitness)).append("\r\n      ").append(sep).append(FormatUtil$.MODULE$.formatNumber(jumpSize)).append("\r\n      ").append(sep).append(FormatUtil$.MODULE$.formatNumber(distance)).append("\r\n      ").append(sep).append(params.toCSVString()).append(sep).append(comment).toString();
        if (this.sLogFile() == null) {
            Predef$.MODULE$.println((Object)new StringBuilder(14).append("<no logfile>: ").append(rowText).toString());
            return;
        }
        try {
            FileWriter logFile = new FileWriter(this.sLogFile(), true);
            logFile.write(new StringBuilder(11).append(rowText).append('\n').toString());
            logFile.flush();
            logFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

