/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter;

import com.barrybecker4.math.linear.Vector;
import com.barrybecker4.math.linear.Vector$;
import com.barrybecker4.optimization.parameter.AbstractParameterArray;
import com.barrybecker4.optimization.parameter.Direction;
import com.barrybecker4.optimization.parameter.NumericParameterArray$;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.sampling.NumericGlobalSampler;
import com.barrybecker4.optimization.parameter.types.Parameter;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public class NumericParameterArray
extends AbstractParameterArray
implements Product,
Serializable {
    private final IndexedSeq params;
    private final int numSteps;
    private final Random rnd;

    public static int DEFAULT_NUM_STEPS() {
        return NumericParameterArray$.MODULE$.DEFAULT_NUM_STEPS();
    }

    public static NumericParameterArray apply(IndexedSeq<Parameter> indexedSeq, int n, Random random) {
        return NumericParameterArray$.MODULE$.apply(indexedSeq, n, random);
    }

    public static IndexedSeq<Parameter> createParams(IndexedSeq<Object> indexedSeq, IndexedSeq<Object> indexedSeq2, IndexedSeq<Object> indexedSeq3, IndexedSeq<String> indexedSeq4) {
        return NumericParameterArray$.MODULE$.createParams(indexedSeq, indexedSeq2, indexedSeq3, indexedSeq4);
    }

    public static NumericParameterArray fromProduct(Product product) {
        return NumericParameterArray$.MODULE$.fromProduct(product);
    }

    public static NumericParameterArray unapply(NumericParameterArray numericParameterArray) {
        return NumericParameterArray$.MODULE$.unapply(numericParameterArray);
    }

    public static int $lessinit$greater$default$2() {
        return NumericParameterArray$.MODULE$.$lessinit$greater$default$2();
    }

    public static Random $lessinit$greater$default$3() {
        return NumericParameterArray$.MODULE$.$lessinit$greater$default$3();
    }

    public NumericParameterArray(IndexedSeq<Parameter> params, int numSteps, Random rnd) {
        this.params = params;
        this.numSteps = numSteps;
        this.rnd = rnd;
        super(params, rnd);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.params()));
        n = Statics.mix((int)n, (int)this.numSteps());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rnd()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NumericParameterArray)) return false;
        NumericParameterArray numericParameterArray = (NumericParameterArray)object;
        if (this.numSteps() != numericParameterArray.numSteps()) return false;
        IndexedSeq<Parameter> indexedSeq = this.params();
        IndexedSeq<Parameter> indexedSeq2 = numericParameterArray.params();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        Random random = this.rnd();
        Random random2 = numericParameterArray.rnd();
        if (random == null) {
            if (random2 != null) {
                return false;
            }
        } else if (!random.equals(random2)) return false;
        if (!numericParameterArray.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof NumericParameterArray;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "NumericParameterArray";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this._2());
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "params";
                break;
            }
            case 1: {
                string = "numSteps";
                break;
            }
            case 2: {
                string = "rnd";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public IndexedSeq<Parameter> params() {
        return this.params;
    }

    public int numSteps() {
        return this.numSteps;
    }

    public Random rnd() {
        return this.rnd;
    }

    public NumericParameterArray(IndexedSeq<Object> vals, IndexedSeq<Object> minVals, IndexedSeq<Object> maxVals, IndexedSeq<String> names, Random rnd) {
        this(NumericParameterArray$.MODULE$.createParams(vals, minVals, maxVals, names), NumericParameterArray$.MODULE$.DEFAULT_NUM_STEPS(), rnd);
    }

    public NumericParameterArray(double[] vals, double[] minVals, double[] maxVals, String[] names, Random rnd) {
        Object object = Predef$.MODULE$.doubleArrayOps(vals);
        Object object2 = Predef$.MODULE$.doubleArrayOps(minVals);
        Object object3 = Predef$.MODULE$.doubleArrayOps(maxVals);
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])names);
        this(NumericParameterArray$.MODULE$.createParams((IndexedSeq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(object), (IndexedSeq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(object2), (IndexedSeq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(object3), (IndexedSeq<String>)ArrayOps$.MODULE$.toIndexedSeq$extension(object4)), NumericParameterArray$.MODULE$.DEFAULT_NUM_STEPS(), rnd);
    }

    public Iterator<NumericParameterArray> findGlobalSamples(long requestedNumSamples) {
        return new NumericGlobalSampler(this, requestedNumSamples);
    }

    @Override
    public double distance(ParameterArray pa) {
        if (this.size() != pa.size()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        DoubleRef sumOfSq = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> {
            double d;
            double dif = pa.get(k).getValue() - this.get(k).getValue();
            sumOfSq$1.elem = d = sumOfSq$1.elem + dif * dif;
        });
        return Math.sqrt(sumOfSq.elem);
    }

    public NumericParameterArray add(Vector vec) {
        if (vec.size() != this.size()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(40).append("Parameter vec has magnitude ").append(vec.size()).append(", expecting ").append(this.size()).toString());
        }
        IndexedSeq newParams = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size()).map((Function1 & Serializable)i -> this.$anonfun$1(vec, BoxesRunTime.unboxToInt((Object)i)));
        return NumericParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)newParams, this.numSteps(), this.rnd());
    }

    public NumericParameterArray incrementByEps(int idx, Direction dir) {
        IndexedSeq newParams = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size()).map((Function1 & Serializable)i -> this.$anonfun$2(idx, dir, BoxesRunTime.unboxToInt((Object)i)));
        return NumericParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)newParams, this.numSteps(), this.rnd());
    }

    @Override
    public NumericParameterArray getRandomNeighbor(double radius) {
        return NumericParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)((IndexedSeq)this.params().map((Function1 & Serializable)p -> p.tweakValue(radius, this.rnd()))), this.numSteps(), this.rnd());
    }

    @Override
    public NumericParameterArray getRandomSample() {
        IndexedSeq newParams = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size()).map((Function1 & Serializable)k -> this.$anonfun$3(BoxesRunTime.unboxToInt((Object)k)));
        return NumericParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)newParams, this.numSteps(), this.rnd());
    }

    public Vector asVector() {
        return Vector$.MODULE$.apply((IndexedSeq)this.params().map((Function1 & Serializable)_$1 -> _$1.getValue()));
    }

    public NumericParameterArray copy(IndexedSeq<Parameter> params, int numSteps, Random rnd) {
        return new NumericParameterArray(params, numSteps, rnd);
    }

    public IndexedSeq<Parameter> copy$default$1() {
        return this.params();
    }

    public int copy$default$2() {
        return this.numSteps();
    }

    public Random copy$default$3() {
        return this.rnd();
    }

    public IndexedSeq<Parameter> _1() {
        return this.params();
    }

    public int _2() {
        return this.numSteps();
    }

    public Random _3() {
        return this.rnd();
    }

    private final /* synthetic */ Parameter $anonfun$1(Vector vec$1, int i) {
        Parameter param = this.get(i);
        Parameter newParam = param.setValue(param.getValue() + vec$1.apply(i));
        if (newParam.getValue() > newParam.maxValue()) {
            Predef$.MODULE$.println((Object)new StringBuilder(84).append("Warning param ").append(newParam.name()).append(" is exceeding is maximum value. It is being pegged to that maximum of ").append(newParam.maxValue()).toString());
            newParam = newParam.setValue(newParam.maxValue());
        }
        if (newParam.getValue() < newParam.minValue()) {
            Predef$.MODULE$.println((Object)new StringBuilder(84).append("Warning param ").append(newParam.name()).append(" is exceeding is minimum value. It is being pegged to that minimum of ").append(newParam.minValue()).toString());
            newParam.setValue(newParam.minValue());
        }
        return newParam;
    }

    private final /* synthetic */ Parameter $anonfun$2(int idx$1, Direction dir$1, int i) {
        return idx$1 == i ? this.get(i).incrementByEps(dir$1) : this.get(i);
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Parameter $anonfun$3(int k) {
        void var3_3;
        Parameter par = this.get(k);
        Parameter newPar = par.setValue(par.minValue() + this.rnd().nextDouble() * par.range());
        if (!(newPar.getValue() < newPar.maxValue()) || !(newPar.getValue() > newPar.minValue())) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(26).append("newPar ").append(newPar.getValue()).append(" not between ").append(newPar.minValue()).append(" and  ").append(newPar.maxValue()).toString());
        }
        return var3_3;
    }
}

