/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter;

import com.barrybecker4.optimization.parameter.AbstractParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.PermutedParameterArray$;
import com.barrybecker4.optimization.parameter.distancecalculators.PermutedDistanceCalculator;
import com.barrybecker4.optimization.parameter.sampling.PermutedGlobalSampler;
import com.barrybecker4.optimization.parameter.types.Parameter;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public class PermutedParameterArray
extends AbstractParameterArray
implements Product,
Serializable {
    private final IndexedSeq params;
    private final Random rnd;
    private final PermutedDistanceCalculator distanceCalculator;

    public static PermutedParameterArray apply(IndexedSeq<Parameter> indexedSeq, Random random) {
        return PermutedParameterArray$.MODULE$.apply(indexedSeq, random);
    }

    public static PermutedParameterArray fromProduct(Product product) {
        return PermutedParameterArray$.MODULE$.fromProduct(product);
    }

    public static PermutedParameterArray unapply(PermutedParameterArray permutedParameterArray) {
        return PermutedParameterArray$.MODULE$.unapply(permutedParameterArray);
    }

    public static Random $lessinit$greater$default$1() {
        return PermutedParameterArray$.MODULE$.$lessinit$greater$default$1();
    }

    public PermutedParameterArray(IndexedSeq<Parameter> params, Random rnd) {
        this.params = params;
        this.rnd = rnd;
        super(params, rnd);
        this.distanceCalculator = new PermutedDistanceCalculator();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof PermutedParameterArray)) return false;
        PermutedParameterArray permutedParameterArray = (PermutedParameterArray)object;
        IndexedSeq<Parameter> indexedSeq = this.params();
        IndexedSeq<Parameter> indexedSeq2 = permutedParameterArray.params();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        Random random = this.rnd();
        Random random2 = permutedParameterArray.rnd();
        if (random == null) {
            if (random2 != null) {
                return false;
            }
        } else if (!random.equals(random2)) return false;
        if (!permutedParameterArray.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof PermutedParameterArray;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "PermutedParameterArray";
    }

    public Object productElement(int n) {
        Random random;
        int n2 = n;
        if (0 == n2) {
            random = this._1();
        } else if (1 == n2) {
            random = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return random;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "params";
        } else if (1 == n2) {
            string = "rnd";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public IndexedSeq<Parameter> params() {
        return this.params;
    }

    public Random rnd() {
        return this.rnd;
    }

    public PermutedParameterArray(Random rnd) {
        this((IndexedSeq<Parameter>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Parameter[0]))), rnd);
    }

    public PermutedParameterArray setPermutation(List<Object> indices) {
        if (indices.size() != this.size()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        List newParams = indices.map((Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
        return PermutedParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)newParams.toIndexedSeq(), this.rnd());
    }

    public PermutedParameterArray reverse() {
        return PermutedParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)((IndexedSeq)this.params().reverse()), this.rnd());
    }

    @Override
    public double distance(ParameterArray pa) {
        return this.distanceCalculator.findDistance(this, (PermutedParameterArray)pa);
    }

    @Override
    public PermutedParameterArray getRandomNeighbor(double radius) {
        if (this.size() <= 1) {
            return this;
        }
        int numToSwap = Math.max(1, (int)(10.0 * radius * (double)this.size() / 100.0));
        Object[] revisedParams = (Parameter[])this.params().toArray(ClassTag$.MODULE$.apply(Parameter.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numToSwap).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> this.getRandomNeighbor$$anonfun$1((Parameter[])revisedParams, arg_0)));
        Object object = Predef$.MODULE$.refArrayOps(revisedParams);
        return PermutedParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)ArrayOps$.MODULE$.toIndexedSeq$extension(object), this.rnd());
    }

    @Override
    public Iterator<? extends ParameterArray> findGlobalSamples(long requestedNumSamples) {
        return new PermutedGlobalSampler(this, requestedNumSamples);
    }

    @Override
    public ParameterArray getRandomSample() {
        return PermutedParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)((IndexedSeq)this.rnd().shuffle(this.params(), BuildFrom$.MODULE$.buildFromIterableOps())), this.rnd());
    }

    public PermutedParameterArray copy(IndexedSeq<Parameter> params, Random rnd) {
        return new PermutedParameterArray(params, rnd);
    }

    public IndexedSeq<Parameter> copy$default$1() {
        return this.params();
    }

    public Random copy$default$2() {
        return this.rnd();
    }

    public IndexedSeq<Parameter> _1() {
        return this.params();
    }

    public Random _2() {
        return this.rnd();
    }

    private final /* synthetic */ Parameter $anonfun$1(int i) {
        return this.get(i);
    }

    private final /* synthetic */ void getRandomNeighbor$$anonfun$1(Parameter[] revisedParams$1, int k) {
        int index1 = this.rnd().nextInt(this.size());
        int index2 = this.rnd().nextInt(this.size());
        while (index2 == index1) {
            index2 = this.rnd().nextInt(this.size());
        }
        revisedParams$1[index1] = ((Parameter)this.params().apply(index1)).setValue(((Parameter)this.params().apply(index2)).getValue());
        revisedParams$1[index2] = ((Parameter)this.params().apply(index2)).setValue(((Parameter)this.params().apply(index1)).getValue());
    }
}

