/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter;

import com.barrybecker4.optimization.parameter.AbstractParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.VariableLengthIntSet$;
import com.barrybecker4.optimization.parameter.distancecalculators.DistanceCalculator;
import com.barrybecker4.optimization.parameter.sampling.VariableLengthGlobalSampler;
import com.barrybecker4.optimization.parameter.types.IntegerParameter;
import com.barrybecker4.optimization.parameter.types.IntegerParameter$;
import com.barrybecker4.optimization.parameter.types.Parameter;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.Predef$;
import scala.collection.BuildFrom$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

public class VariableLengthIntSet
extends AbstractParameterArray {
    private final IndexedSeq<Parameter> params;
    private final IndexedSeq fullSeq;
    private final DistanceCalculator distCalc;
    private final Random rnd;
    private final scala.collection.immutable.Set paramSet;
    private final scala.collection.immutable.Set fullSet;

    public static VariableLengthIntSet createInstance(IndexedSeq<Parameter> indexedSeq, IndexedSeq<Object> indexedSeq2, Random random) {
        return VariableLengthIntSet$.MODULE$.createInstance(indexedSeq, indexedSeq2, random);
    }

    public static DistanceCalculator $lessinit$greater$default$3() {
        return VariableLengthIntSet$.MODULE$.$lessinit$greater$default$3();
    }

    public VariableLengthIntSet(IndexedSeq<Parameter> params, IndexedSeq<Object> fullSeq, DistanceCalculator distCalc, Random rnd) {
        this.params = params;
        this.fullSeq = fullSeq;
        this.distCalc = distCalc;
        this.rnd = rnd;
        super(params, rnd);
        this.paramSet = params.toSet();
        this.fullSet = fullSeq.toSet();
    }

    public IndexedSeq<Object> fullSeq() {
        return this.fullSeq;
    }

    private scala.collection.immutable.Set<Parameter> paramSet() {
        return this.paramSet;
    }

    private scala.collection.immutable.Set<Object> fullSet() {
        return this.fullSet;
    }

    public int getMaxLength() {
        return this.fullSet().size();
    }

    public IndexedSeq<Object> intValues() {
        return (IndexedSeq)this.params.map((Function1 & Serializable)_$1 -> (int)_$1.getValue());
    }

    @Override
    public double distance(ParameterArray pa) {
        return this.distCalc.calculateDistance(this, pa);
    }

    @Override
    public VariableLengthIntSet getRandomNeighbor(double radius) {
        VariableLengthIntSet result;
        int numNodesToMove;
        if (this.size() < 1) {
            return this;
        }
        double probAddRemove = radius / (VariableLengthIntSet$.com$barrybecker4$optimization$parameter$VariableLengthIntSet$$$ADD_REMOVE_RADIUS_SOFTENER + radius);
        boolean add = false;
        boolean remove = false;
        if (this.rnd.nextDouble() < probAddRemove) {
            if ((this.rnd.nextDouble() > 0.5 || this.size() <= 1) && this.size() < this.getMaxLength() - 1) {
                add = true;
            } else {
                remove = true;
            }
        }
        int n = numNodesToMove = add || remove ? this.rnd.nextInt(Math.min(this.size(), (int)(radius + 1.1))) : 1 + this.rnd.nextInt((int)(1.4 + radius));
        VariableLengthIntSet variableLengthIntSet = remove ? this.removeRandomParams(this.numToRemove(radius)) : (result = add ? this.addRandomParams(this.numToAdd(radius)) : this);
        if (!add && !remove && numNodesToMove <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return result.moveNodes(numNodesToMove);
    }

    private int numToRemove(double radius) {
        return this.skewedNumToSelect(radius, this.params.length() - 2);
    }

    private int numToAdd(double radius) {
        return this.skewedNumToSelect(radius, this.fullSet().size() - this.params.size());
    }

    private int skewedNumToSelect(double radius, int len) {
        int upper = (int)(radius / 2.0 * Math.abs(this.rnd.nextGaussian()) * (double)len);
        return Math.max(1, Math.min(len, upper));
    }

    public VariableLengthIntSet getCombination(Seq<Object> indices) {
        if (indices.size() > this.getMaxLength()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(57).append("The number of indices (").append(indices.size()).append(") was greater than the max size (").append(this.size()).append(")").toString());
        }
        Seq newParams = (Seq)indices.map((Function1 & Serializable)i -> this.$anonfun$2(BoxesRunTime.unboxToInt((Object)i)));
        return new VariableLengthIntSet((IndexedSeq<Parameter>)newParams.toIndexedSeq(), this.fullSeq(), this.distCalc, this.rnd);
    }

    public Iterator<VariableLengthIntSet> findGlobalSamples(long requestedNumSamples) {
        return new VariableLengthGlobalSampler(this, requestedNumSamples);
    }

    @Override
    public ParameterArray getRandomSample() {
        IndexedSeq shuffled = (IndexedSeq)this.rnd.shuffle(this.fullSeq(), BuildFrom$.MODULE$.buildFromIterableOps());
        IndexedSeq marked = (IndexedSeq)shuffled.take((int)((double)(shuffled.length() - 1) * this.rnd.nextDouble()) + 1);
        IndexedSeq newParams = (IndexedSeq)marked.map((Function1 & Serializable)m -> this.$anonfun$3(BoxesRunTime.unboxToInt((Object)m)));
        return new VariableLengthIntSet((IndexedSeq<Parameter>)newParams, this.fullSeq(), this.distCalc, this.rnd);
    }

    private IntegerParameter createParam(int i) {
        return new IntegerParameter(Int$.MODULE$.int2double(i), i < 0 ? Int$.MODULE$.int2double(i) : 0.0, i >= 0 ? Int$.MODULE$.int2double(i) : 0.0, new StringBuilder(1).append("p").append(i).toString(), IntegerParameter$.MODULE$.$lessinit$greater$default$5());
    }

    private VariableLengthIntSet removeRandomParams(int num) {
        IndexedSeq rndIndices = (IndexedSeq)this.rnd.shuffle((IterableOnce)this.params.indices().toIndexedSeq(), BuildFrom$.MODULE$.buildFromIterableOps());
        scala.collection.immutable.Set indicesToRemove = ((IterableOnceOps)rndIndices.take(num)).toSet();
        return new VariableLengthIntSet((IndexedSeq<Parameter>)((IndexedSeq)((IndexedSeqOps)((IterableOps)this.params.zipWithIndex()).filter((Function1 & Serializable)p -> !indicesToRemove.contains(p._2()))).map((Function1 & Serializable)_$2 -> (Parameter)_$2._1())), this.fullSeq(), this.distCalc, this.rnd);
    }

    private VariableLengthIntSet addRandomParams(int num) {
        Seq intsToAdd = (Seq)((IterableOps)this.rnd.shuffle(this.getFreeNodes(), BuildFrom$.MODULE$.buildFromIterableOps())).take(num);
        if (this.size() + intsToAdd.size() > this.getMaxLength()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return new VariableLengthIntSet((IndexedSeq<Parameter>)((IndexedSeq)this.params.$plus$plus((IterableOnce)intsToAdd.map((Function1 & Serializable)i -> this.addRandomParams$$anonfun$1(BoxesRunTime.unboxToInt((Object)i))))), this.fullSeq(), this.distCalc, this.rnd);
    }

    private VariableLengthIntSet moveNodes(int numNodesToMove) {
        VariableLengthIntSet variableLengthIntSet;
        if (numNodesToMove == 0) {
            return this;
        }
        Seq<Object> freeNodes = this.getFreeNodes();
        int numSelect = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(new int[]{freeNodes.size(), this.params.size(), numNodesToMove}).min((Ordering)Ordering.Int$.MODULE$));
        if (numSelect == 0) {
            variableLengthIntSet = this.removeRandomParams(1);
        } else {
            IndexedSeq randomIndices = (IndexedSeq)((SeqOps)((IndexedSeqOps)this.rnd.shuffle((IterableOnce)this.params.indices().toIndexedSeq(), BuildFrom$.MODULE$.buildFromIterableOps())).take(numSelect)).sorted((Ordering)Ordering.Int$.MODULE$);
            IndexedSeq randomFreeIndices = (IndexedSeq)((IndexedSeqOps)this.rnd.shuffle((IterableOnce)freeNodes.indices().toIndexedSeq(), BuildFrom$.MODULE$.buildFromIterableOps())).take(numSelect);
            IntRef ct = IntRef.create((int)0);
            IndexedSeq newParams = this.params.indices().map((Function1 & Serializable)i -> this.$anonfun$4(freeNodes, numSelect, randomIndices, randomFreeIndices, ct, BoxesRunTime.unboxToInt((Object)i)));
            variableLengthIntSet = new VariableLengthIntSet((IndexedSeq<Parameter>)newParams, this.fullSeq(), this.distCalc, this.rnd);
        }
        return variableLengthIntSet;
    }

    private Seq<Object> getFreeNodes() {
        scala.collection.immutable.Set markedNodes = ((IterableOnceOps)this.params.map((Function1 & Serializable)p -> (int)p.getValue())).toSet();
        return this.fullSet().diff((Set)markedNodes).toSeq();
    }

    public boolean canEqual(Object other) {
        return other instanceof VariableLengthIntSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof VariableLengthIntSet)) return false;
        VariableLengthIntSet that = (VariableLengthIntSet)object;
        if (!that.canEqual(this)) return false;
        scala.collection.immutable.Set<Parameter> set = this.paramSet();
        scala.collection.immutable.Set<Parameter> set2 = that.paramSet();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        scala.collection.immutable.Set<Object> set3 = this.fullSet();
        scala.collection.immutable.Set<Object> set4 = that.fullSet();
        if (set3 == null) {
            if (set4 == null) return true;
            return false;
        } else {
            if (!set3.equals(set4)) return false;
            return true;
        }
    }

    public int hashCode() {
        Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{this.paramSet(), this.fullSet()}));
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)_$3 -> _$3.hashCode())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    private final /* synthetic */ IntegerParameter $anonfun$2(int i) {
        return this.createParam(BoxesRunTime.unboxToInt((Object)this.fullSeq().apply(i)));
    }

    private final /* synthetic */ IntegerParameter $anonfun$3(int m) {
        return this.createParam(m);
    }

    private final /* synthetic */ IntegerParameter addRandomParams$$anonfun$1(int i) {
        return this.createParam(i);
    }

    private final /* synthetic */ Parameter $anonfun$4(Seq freeNodes$1, int numSelect$1, IndexedSeq randomIndices$1, IndexedSeq randomFreeIndices$1, IntRef ct$1, int i) {
        Parameter parameter;
        if (ct$1.elem < numSelect$1 && i == BoxesRunTime.unboxToInt((Object)randomIndices$1.apply(ct$1.elem))) {
            int n;
            int v = BoxesRunTime.unboxToInt((Object)freeNodes$1.apply(BoxesRunTime.unboxToInt((Object)randomFreeIndices$1.apply(ct$1.elem))));
            ct$1.elem = n = ct$1.elem + 1;
            parameter = this.createParam(v);
        } else {
            parameter = (Parameter)this.params.apply(i);
        }
        return parameter;
    }
}

