/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.distancecalculators;

import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.PermutedParameterArray;
import com.barrybecker4.optimization.parameter.types.Parameter;
import java.io.Serializable;
import scala.Function1;
import scala.Int$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;

public class PermutedDistanceCalculator {
    public double findDistance(PermutedParameterArray pa1, PermutedParameterArray pa2) {
        if (pa1.size() != pa2.size()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        PermutedParameterArray paReverse = pa2.reverse();
        return Math.min(this.difference(pa1, pa2), this.difference(pa1, paReverse));
    }

    private double difference(ParameterArray pa1, ParameterArray pa2) {
        ArrayBuffer runLengths = new ArrayBuffer();
        int len = pa1.size();
        for (int i = 0; i < len; i += this.determineRunLength(pa1, pa2, len, i, (ArrayBuffer<Object>)runLengths)) {
        }
        return this.calcDistance(pa1, (ArrayBuffer<Object>)runLengths);
    }

    private int determineRunLength(ParameterArray pa1, ParameterArray pa2, int len, int idx, ArrayBuffer<Object> runLengths) {
        int k = 0;
        int i = idx;
        k = 1;
        int j = this.findCorrespondingEntryIndex(pa2, len, pa1.get(idx));
        boolean matchFound = false;
        boolean matched = true;
        while (matched && k <= len) {
            i = (i + 1) % len;
            j = (j + 1) % len;
            ++k;
            matched = pa1.get(i).getValue() == pa2.get(j).getValue();
            matchFound |= matched;
        }
        int runLength = k - 1;
        if (matchFound) {
            runLengths.append((Object)BoxesRunTime.boxToInteger((int)runLength));
        }
        return runLength;
    }

    private int findCorrespondingEntryIndex(ParameterArray pa, int len, Parameter param) {
        int j;
        for (j = 0; j < len && param.getValue() != pa.get(j).getValue(); ++j) {
        }
        if (j >= len) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(35).append("Param ").append(param).append(" did not match any values in ").append(pa).toString());
        }
        return j;
    }

    private double calcDistance(ParameterArray pa1, ArrayBuffer<Object> runLengths) {
        double max = Math.pow(2.0, Int$.MODULE$.int2double(pa1.size()));
        if (runLengths.isEmpty()) {
            return max;
        }
        DoubleRef denom = DoubleRef.create((double)0.0);
        runLengths.foreach((Function1)(JFunction1.mcVI.sp & Serializable)run -> {
            double d;
            denom$1.elem = d = denom$1.elem + Math.pow(2.0, Int$.MODULE$.int2double(run - 1));
        });
        return max / denom.elem - 2.0;
    }
}

