/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.redistribution;

import com.barrybecker4.optimization.parameter.redistribution.DiscreteRedistribution$;
import com.barrybecker4.optimization.parameter.redistribution.UniformRedistribution;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public class DiscreteRedistribution
extends UniformRedistribution
implements Product,
Serializable {
    private final int numValues;
    private final int[] discreteSpecialValues;
    private final double[] discreteSpecialValueProbabilities;
    private final int len;

    public static DiscreteRedistribution apply(int n, int[] nArray, double[] dArray) {
        return DiscreteRedistribution$.MODULE$.apply(n, nArray, dArray);
    }

    public static DiscreteRedistribution fromProduct(Product product) {
        return DiscreteRedistribution$.MODULE$.fromProduct(product);
    }

    public static DiscreteRedistribution unapply(DiscreteRedistribution discreteRedistribution) {
        return DiscreteRedistribution$.MODULE$.unapply(discreteRedistribution);
    }

    public DiscreteRedistribution(int numValues, int[] discreteSpecialValues, double[] discreteSpecialValueProbabilities) {
        this.numValues = numValues;
        this.discreteSpecialValues = discreteSpecialValues;
        this.discreteSpecialValueProbabilities = discreteSpecialValueProbabilities;
        this.len = discreteSpecialValues.length;
        this.specialValues_$eq(new double[this.len()]);
        this.specialValueProbabilities_$eq(new double[this.len()]);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.len()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (discreteSpecialValues[i] >= numValues) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(36).append(" A discrete special value (").append(discreteSpecialValues[i]).append(") was >= ").append(numValues).toString());
            }
            this.specialValues()[i] = (double)discreteSpecialValues[i] / (double)(numValues - 1);
            this.specialValueProbabilities()[i] = discreteSpecialValueProbabilities[i];
        });
        this.initializeFunction();
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.numValues());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.discreteSpecialValues()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.discreteSpecialValueProbabilities()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DiscreteRedistribution)) return false;
        DiscreteRedistribution discreteRedistribution = (DiscreteRedistribution)object;
        if (this.numValues() != discreteRedistribution.numValues()) return false;
        if (this.discreteSpecialValues() != discreteRedistribution.discreteSpecialValues()) return false;
        if (this.discreteSpecialValueProbabilities() != discreteRedistribution.discreteSpecialValueProbabilities()) return false;
        if (!discreteRedistribution.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DiscreteRedistribution;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "DiscreteRedistribution";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this._1());
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "numValues";
                break;
            }
            case 1: {
                string = "discreteSpecialValues";
                break;
            }
            case 2: {
                string = "discreteSpecialValueProbabilities";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public int numValues() {
        return this.numValues;
    }

    public int[] discreteSpecialValues() {
        return this.discreteSpecialValues;
    }

    public double[] discreteSpecialValueProbabilities() {
        return this.discreteSpecialValueProbabilities;
    }

    public int len() {
        return this.len;
    }

    public DiscreteRedistribution copy(int numValues, int[] discreteSpecialValues, double[] discreteSpecialValueProbabilities) {
        return new DiscreteRedistribution(numValues, discreteSpecialValues, discreteSpecialValueProbabilities);
    }

    public int copy$default$1() {
        return this.numValues();
    }

    public int[] copy$default$2() {
        return this.discreteSpecialValues();
    }

    public double[] copy$default$3() {
        return this.discreteSpecialValueProbabilities();
    }

    public int _1() {
        return this.numValues();
    }

    public int[] _2() {
        return this.discreteSpecialValues();
    }

    public double[] _3() {
        return this.discreteSpecialValueProbabilities();
    }
}

