/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.redistribution;

import com.barrybecker4.math.MathUtil$;
import com.barrybecker4.math.Range;
import com.barrybecker4.math.Range$;
import com.barrybecker4.math.function.ArrayFunction;
import com.barrybecker4.math.function.ErrorFunction;
import com.barrybecker4.math.function.FunctionInverter;
import com.barrybecker4.math.function.InvertibleFunction;
import com.barrybecker4.optimization.parameter.redistribution.GaussianRedistribution$;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;

public class GaussianRedistribution
implements RedistributionFunction {
    private InvertibleFunction redistributionFunction;
    private double mean;
    private double stdDeviation;
    private final ErrorFunction errorFunction;

    public static void main(String[] stringArray) {
        GaussianRedistribution$.MODULE$.main(stringArray);
    }

    public GaussianRedistribution(double mean, double stdDeviation) {
        this.mean = mean;
        this.stdDeviation = stdDeviation;
        RedistributionFunction.$init$(this);
        RedistributionFunction$.MODULE$.verifyInRange(this.mean());
        this.errorFunction = new ErrorFunction();
        this.initializeFunction();
    }

    @Override
    public InvertibleFunction redistributionFunction() {
        return this.redistributionFunction;
    }

    @Override
    public void redistributionFunction_$eq(InvertibleFunction x$1) {
        this.redistributionFunction = x$1;
    }

    public double mean() {
        return this.mean;
    }

    public void mean_$eq(double x$1) {
        this.mean = x$1;
    }

    public double stdDeviation() {
        return this.stdDeviation;
    }

    public void stdDeviation_$eq(double x$1) {
        this.stdDeviation = x$1;
    }

    @Override
    public void initializeFunction() {
        double[] functionMap = null;
        double inc = 1.0 / (double)(GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES - 1);
        double[] cdfFunction = new double[GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES];
        cdfFunction[0] = 0.0;
        DoubleRef x = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES).foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            double v;
            double d;
            x$1.elem = d = x$1.elem + inc;
            cdfFunction$1[index] = v = this.cdf(x$1.elem);
        });
        double lowMissing = this.cdf(0.0);
        double highMissing = 1.0 - cdfFunction[GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES - 1];
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("lowMissing=").append(lowMissing).append(" highMissing=").append(highMissing).toString());
        int numMapValsm1 = GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES - 1;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double aliasAllocation = -lowMissing * (double)(numMapValsm1 - i) / (double)numMapValsm1 + highMissing * (double)i / (double)numMapValsm1;
            cdfFunction$2[i] = cdfFunction[i] + aliasAllocation;
            if (cdfFunction[i] > 1.0 && i < GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES - 1) {
                cdfFunction$2[i] = 1.0 - MathUtil$.MODULE$.EPS();
            }
        });
        double max = cdfFunction[GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES - 1];
        if (!(max > 0.9) || !(max < 1.01)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        cdfFunction[GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$NUM_MAP_VALUES - 1] = 1.0;
        Range xRange = Range$.MODULE$.apply(0.0, 1.0);
        FunctionInverter inverter = new FunctionInverter(cdfFunction);
        functionMap = inverter.createInverseFunction(xRange);
        this.redistributionFunction_$eq((InvertibleFunction)new ArrayFunction(functionMap, cdfFunction));
    }

    private double cdf(double x) {
        double denom = GaussianRedistribution$.com$barrybecker4$optimization$parameter$redistribution$GaussianRedistribution$$$SQRT2 * this.stdDeviation();
        double xx = (Math.min(1.0, x) - this.mean()) / denom;
        double erf = this.errorFunction.getValue(xx);
        return 0.5 * (1.0 + erf);
    }
}

