/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.redistribution;

import com.barrybecker4.math.MathUtil$;
import com.barrybecker4.math.function.InvertibleFunction;
import com.barrybecker4.math.function.PiecewiseFunction;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction1;

public class UniformRedistribution
implements RedistributionFunction {
    private InvertibleFunction redistributionFunction;
    private double[] specialValues;
    private double[] specialValueProbabilities;

    public UniformRedistribution() {
        RedistributionFunction.$init$(this);
    }

    @Override
    public InvertibleFunction redistributionFunction() {
        return this.redistributionFunction;
    }

    @Override
    public void redistributionFunction_$eq(InvertibleFunction x$1) {
        this.redistributionFunction = x$1;
    }

    public double[] specialValues() {
        return this.specialValues;
    }

    public void specialValues_$eq(double[] x$1) {
        this.specialValues = x$1;
    }

    public double[] specialValueProbabilities() {
        return this.specialValueProbabilities;
    }

    public void specialValueProbabilities_$eq(double[] x$1) {
        this.specialValueProbabilities = x$1;
    }

    public UniformRedistribution(double[] specialValues, double[] specialValueProbabilities) {
        this();
        this.specialValues_$eq(specialValues);
        this.specialValueProbabilities_$eq(specialValueProbabilities);
        this.initializeFunction();
    }

    @Override
    public void initializeFunction() {
        double d;
        int len = this.specialValues().length;
        if (len <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"must have at least one special value (otherwise you could just use null for the redistribution function)");
        }
        if (len != this.specialValueProbabilities().length) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        double[] xValues = new double[2 * len + 2];
        double[] yValues = new double[2 * len + 2];
        DoubleRef specialProbabilityTotal = DoubleRef.create((double)this.getSpecialProbTotal());
        double ratio = 1.0 - specialProbabilityTotal.elem;
        specialProbabilityTotal.elem = d = 0.0;
        xValues[0] = 0.0;
        yValues[0] = 0.0;
        DoubleRef lastX = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double d;
            double d2;
            RedistributionFunction$.MODULE$.verifyInRange(this.specialValueProbabilities()[i]);
            specialProbabilityTotal$1.elem = d2 = specialProbabilityTotal$1.elem + this.specialValueProbabilities()[i];
            int i2 = 2 * i;
            double specialValuesm1 = i == 0 ? 0.0 : this.specialValues()[i - 1];
            xValues$1[i2 + 1] = lastX$1.elem + (this.specialValues()[i] - specialValuesm1) * ratio;
            yValues$1[i2 + 1] = this.specialValues()[i];
            xValues$1[i2 + 2] = xValues[i2 + 1] + this.specialValueProbabilities()[i];
            yValues$1[i2 + 2] = this.specialValues()[i];
            if (i > 0) {
                int n = i2 + 1;
                xValues$1[n] = xValues[n] + MathUtil$.MODULE$.EPS();
            }
            lastX$1.elem = d = xValues[i2 + 2];
        });
        if (len == 2) {
            int n = 2 * len - 2;
            xValues[n] = xValues[n] - MathUtil$.MODULE$.EPS_MEDIUM();
        }
        xValues[2 * len + 1] = 1.0;
        yValues[2 * len + 1] = 1.0;
        this.redistributionFunction_$eq((InvertibleFunction)new PiecewiseFunction(xValues, yValues));
    }

    private double getSpecialProbTotal() {
        int len = this.specialValues().length;
        DoubleRef specialProbabilityTotal = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double d;
            RedistributionFunction$.MODULE$.verifyInRange(this.specialValues()[i]);
            if (i > 0 && !(this.specialValues()[i] > this.specialValues()[i - 1])) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            specialProbabilityTotal$2.elem = d = specialProbabilityTotal$2.elem + this.specialValueProbabilities()[i];
        });
        RedistributionFunction$.MODULE$.verifyInRange(specialProbabilityTotal.elem);
        return specialProbabilityTotal.elem;
    }
}

