/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.sampling;

import com.barrybecker4.math.multiarray.MultiDimensionalIndexer;
import com.barrybecker4.optimization.parameter.NumericParameterArray;
import com.barrybecker4.optimization.parameter.NumericParameterArray$;
import com.barrybecker4.optimization.parameter.sampling.AbstractGlobalSampler;
import com.barrybecker4.optimization.parameter.types.Parameter;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class NumericGlobalSampler
extends AbstractGlobalSampler<NumericParameterArray> {
    private NumericParameterArray params;
    private final long requestedNumSamples;
    private final int[] dims;
    private final int samplingRate;
    private final MultiDimensionalIndexer samples;

    public NumericGlobalSampler(NumericParameterArray params, long requestedNumSamples) {
        this.params = params;
        this.requestedNumSamples = requestedNumSamples;
        this.dims = new int[this.params().size()];
        this.samplingRate = this.determineSamplingRate(requestedNumSamples);
        Object object = Predef$.MODULE$.intArrayOps(this.dims());
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.dims()[i] = this.samplingRate;
        });
        this.samples = new MultiDimensionalIndexer(this.dims());
        this.numSamples_$eq(this.samples.getNumValues());
    }

    public NumericParameterArray params() {
        return this.params;
    }

    public void params_$eq(NumericParameterArray x$1) {
        this.params = x$1;
    }

    public long requestedNumSamples() {
        return this.requestedNumSamples;
    }

    public int[] dims() {
        return this.dims;
    }

    @Override
    public NumericParameterArray next() {
        if ((long)this.counter() >= this.numSamples()) {
            throw new NoSuchElementException("ran out of samples.");
        }
        if ((long)this.counter() == this.numSamples() - 1L) {
            this.hasNext_$eq(false);
        }
        int[] index = this.samples.getIndexFromRaw(this.counter());
        IndexedSeq paramList = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.params().size()).map((Function1 & Serializable)j -> this.$anonfun$1(index, BoxesRunTime.unboxToInt((Object)j)));
        this.counter_$eq(this.counter() + 1);
        return NumericParameterArray$.MODULE$.apply((IndexedSeq<Parameter>)paramList, this.params().numSteps(), this.params().rnd());
    }

    private int determineSamplingRate(long requestedNumSamples) {
        int numDims = this.params().size();
        return (int)Math.pow(requestedNumSamples, 1.0 / (double)numDims);
    }

    private final /* synthetic */ Parameter $anonfun$1(int[] index$1, int j) {
        Parameter p = this.params().get(j);
        double increment = (p.maxValue() - p.minValue()) / (double)this.samplingRate;
        return p.setValue(p.minValue() + increment / 2.0 + (double)index$1[j] * increment);
    }
}

