/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.sampling;

import com.barrybecker4.math.MathUtil$;
import com.barrybecker4.math.combinatorics.Permuter;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.PermutedParameterArray;
import com.barrybecker4.optimization.parameter.sampling.AbstractGlobalSampler;
import com.barrybecker4.optimization.parameter.sampling.PermutedGlobalSampler$;
import java.math.BigInteger;
import scala.Int$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;

public class PermutedGlobalSampler
extends AbstractGlobalSampler<PermutedParameterArray> {
    private PermutedParameterArray params;
    private final long requestedNumSamples;
    private final BigInteger numPermutations;
    private final boolean useExhaustiveSearch;
    private Permuter permuter;
    private final ArrayBuffer<ParameterArray> globalSamples;

    public PermutedGlobalSampler(PermutedParameterArray params, long requestedNumSamples) {
        this.params = params;
        this.requestedNumSamples = requestedNumSamples;
        this.numPermutations = MathUtil$.MODULE$.bigFactorial(this.params().size()).divide(BigInteger.valueOf(2L));
        this.numSamples_$eq(this.numPermutations().compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0 ? Math.min(requestedNumSamples, this.numPermutations().longValue()) : requestedNumSamples);
        BigInteger v = this.numPermutations().multiply(BigInteger.valueOf(Int$.MODULE$.int2long(PermutedGlobalSampler$.com$barrybecker4$optimization$parameter$sampling$PermutedGlobalSampler$$$CLOSE_FACTOR))).divide(BigInteger.valueOf(100L));
        boolean bl = this.useExhaustiveSearch = BigInteger.valueOf(requestedNumSamples).compareTo(v) == 1;
        if (this.useExhaustiveSearch) {
            this.permuter = new Permuter(this.params().size());
        }
        this.globalSamples = new ArrayBuffer();
    }

    public PermutedParameterArray params() {
        return this.params;
    }

    public void params_$eq(PermutedParameterArray x$1) {
        this.params = x$1;
    }

    public long requestedNumSamples() {
        return this.requestedNumSamples;
    }

    public BigInteger numPermutations() {
        return this.numPermutations;
    }

    @Override
    public PermutedParameterArray next() {
        if ((long)this.counter() >= this.numSamples()) {
            throw new IllegalStateException("ran out of samples.");
        }
        if ((long)this.counter() == this.numSamples() - 1L) {
            this.hasNext_$eq(false);
        }
        this.counter_$eq(this.counter() + 1);
        return this.useExhaustiveSearch ? this.getNextExhaustiveSample() : this.getNextRandomSample();
    }

    /*
     * WARNING - void declaration
     */
    private PermutedParameterArray getNextRandomSample() {
        void var1_1;
        PermutedParameterArray nextSample = null;
        while (this.globalSamples.size() < this.counter()) {
            nextSample = (PermutedParameterArray)this.params().getRandomSample();
            if (this.globalSamples.contains((Object)nextSample)) continue;
            this.globalSamples.append((Object)nextSample);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private PermutedParameterArray getNextExhaustiveSample() {
        void var1_1;
        PermutedParameterArray pParams = this.params().setPermutation((List<Object>)this.permuter.next());
        return var1_1;
    }
}

