/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.sampling;

import com.barrybecker4.math.combinatorics.Combinater;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.VariableLengthIntSet;
import com.barrybecker4.optimization.parameter.sampling.AbstractGlobalSampler;
import com.barrybecker4.optimization.parameter.sampling.VariableLengthGlobalSampler$;
import java.util.NoSuchElementException;
import scala.Int$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;

public class VariableLengthGlobalSampler
extends AbstractGlobalSampler<VariableLengthIntSet> {
    private VariableLengthIntSet params;
    private final long requestedNumSamples;
    private final ArrayBuffer globalSamples;
    private boolean useExhaustiveSearch;
    private long totalConfigurations;
    private Combinater combinator;

    public VariableLengthGlobalSampler(VariableLengthIntSet params, long requestedNumSamples) {
        this.params = params;
        this.requestedNumSamples = requestedNumSamples;
        this.globalSamples = new ArrayBuffer();
        this.useExhaustiveSearch = false;
        this.totalConfigurations = this.params().getMaxLength() <= 60 ? (long)Math.pow(2.0, Int$.MODULE$.int2double(this.params().getMaxLength())) - 1L : Long.MAX_VALUE;
        this.numSamples_$eq(Math.min(requestedNumSamples, this.totalConfigurations()));
        boolean bl = this.useExhaustiveSearch = (double)requestedNumSamples > VariableLengthGlobalSampler$.com$barrybecker4$optimization$parameter$sampling$VariableLengthGlobalSampler$$$CLOSE_FACTOR * (double)this.totalConfigurations();
        if (this.useExhaustiveSearch) {
            this.combinator = new Combinater(this.params().getMaxLength());
        }
    }

    public VariableLengthIntSet params() {
        return this.params;
    }

    public void params_$eq(VariableLengthIntSet x$1) {
        this.params = x$1;
    }

    public long requestedNumSamples() {
        return this.requestedNumSamples;
    }

    public ArrayBuffer<ParameterArray> globalSamples() {
        return this.globalSamples;
    }

    public long totalConfigurations() {
        return this.totalConfigurations;
    }

    public void totalConfigurations_$eq(long x$1) {
        this.totalConfigurations = x$1;
    }

    @Override
    public VariableLengthIntSet next() {
        if ((long)this.counter() >= this.totalConfigurations()) {
            throw new NoSuchElementException(new StringBuilder(35).append("ran out of samples. There are only ").append(this.totalConfigurations()).toString());
        }
        if ((long)this.counter() == this.numSamples() - 1L) {
            this.hasNext_$eq(false);
        }
        this.counter_$eq(this.counter() + 1);
        return this.useExhaustiveSearch ? this.getNextExhaustiveSample() : this.getNextRandomSample();
    }

    /*
     * WARNING - void declaration
     */
    private VariableLengthIntSet getNextRandomSample() {
        void var1_1;
        VariableLengthIntSet nextSample = null;
        while (this.globalSamples().size() < this.counter()) {
            nextSample = (VariableLengthIntSet)this.params().getRandomSample();
            if (this.globalSamples().contains((Object)nextSample)) continue;
            this.globalSamples().append((Object)nextSample);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private VariableLengthIntSet getNextExhaustiveSample() {
        void var2_2;
        List theNext = this.combinator.next();
        VariableLengthIntSet v1Params = this.params().getCombination((Seq<Object>)theNext);
        return var2_2;
    }
}

