/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.types;

import com.barrybecker4.math.MathUtil$;
import com.barrybecker4.optimization.parameter.Direction;
import com.barrybecker4.optimization.parameter.ParameterChangeListener;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction;
import com.barrybecker4.optimization.parameter.types.AbstractIntParameter$;
import com.barrybecker4.optimization.parameter.types.AbstractParameter;
import com.barrybecker4.optimization.parameter.types.IntegerParameter;
import com.barrybecker4.optimization.parameter.ui.DoubleParameterWidget;
import com.barrybecker4.optimization.parameter.ui.ParameterWidget;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Random;

public abstract class AbstractIntParameter
extends AbstractParameter {
    private final int theVal;
    private final int minVal;
    private final int maxVal;
    private final String paramName;
    private final Option<RedistributionFunction> redisFunc;

    public static Option<RedistributionFunction> $lessinit$greater$default$5() {
        return AbstractIntParameter$.MODULE$.$lessinit$greater$default$5();
    }

    public AbstractIntParameter(int theVal, int minVal, int maxVal, String paramName, Option<RedistributionFunction> redisFunc) {
        this.theVal = theVal;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.paramName = paramName;
        this.redisFunc = redisFunc;
        super(theVal, minVal, maxVal, paramName, redisFunc);
    }

    public int getRandomVal(Random rand) {
        return (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)this.minVal + rand.nextDouble() * this.range()));
    }

    public int tweakIntValue(double radius, Random rand) {
        return this.isOrdered() ? (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(super.tweakNumericValue(Int$.MODULE$.int2double(this.theVal), radius, rand))) : (rand.nextDouble() < radius ? this.getRandomVal(rand) : this.theVal);
    }

    @Override
    public boolean isIntegerOnly() {
        return true;
    }

    public boolean isOrdered() {
        return true;
    }

    @Override
    public IntegerParameter incrementByEps(Direction direction) {
        return new IntegerParameter(Int$.MODULE$.int2double((int)(this.getValue() + (double)direction.multiplier())), Int$.MODULE$.int2double(this.minVal), Int$.MODULE$.int2double(this.maxVal), this.paramName, this.redisFunc);
    }

    @Override
    public double getValue() {
        double d;
        if (this.redisFunc.isDefined()) {
            double v = (double)(this.theVal - this.minVal) / (this.range() + 1.0);
            double rv = ((RedistributionFunction)this.redisFunc.get()).getValue(v);
            d = RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(rv * (this.range() + (1.0 - MathUtil$.MODULE$.EPS())) + (double)this.minVal));
        } else {
            d = Int$.MODULE$.int2double(this.theVal);
        }
        return d;
    }

    @Override
    public Object getNaturalValue() {
        return BoxesRunTime.boxToLong((long)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.getValue())));
    }

    @Override
    public Class<?> getType() {
        return Integer.TYPE;
    }

    @Override
    public ParameterWidget createWidget(ParameterChangeListener listener) {
        return new DoubleParameterWidget(this, listener);
    }
}

