/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.types;

import com.barrybecker4.common.format.FormatUtil$;
import com.barrybecker4.optimization.parameter.Direction;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction;
import com.barrybecker4.optimization.parameter.types.AbstractParameter$;
import com.barrybecker4.optimization.parameter.types.Parameter;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Scala3RunTime$;
import scala.util.Random;

public abstract class AbstractParameter
implements Parameter {
    private final double value;
    private final double minValue;
    private final double maxValue;
    private final String name;
    private final Option<RedistributionFunction> redistributionFunction;
    private final double range;

    public static Option<RedistributionFunction> $lessinit$greater$default$5() {
        return AbstractParameter$.MODULE$.$lessinit$greater$default$5();
    }

    public AbstractParameter(double value, double minValue, double maxValue, String name, Option<RedistributionFunction> redistributionFunction) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.name = name;
        this.redistributionFunction = redistributionFunction;
        this.range = maxValue - minValue;
    }

    @Override
    public double range() {
        return this.range;
    }

    public AbstractParameter(double value, double minVal, double maxVal, String paramName) {
        this(value, minVal, maxVal, paramName, (Option<RedistributionFunction>)None$.MODULE$);
    }

    public double tweakNumericValue(double v, double r, Random rand) {
        if (!(Math.abs(r) <= 1.5)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (r == 0.0) {
            return v;
        }
        double change = rand.nextGaussian() * r * this.range();
        double newValue = v + change;
        if (newValue > this.maxValue) {
            newValue = this.maxValue;
        } else if (newValue < this.minValue) {
            newValue = this.minValue;
        }
        return newValue;
    }

    @Override
    public double getIncrementForDirection(Direction direction) {
        return Int$.MODULE$.int2double(direction.multiplier());
    }

    public double getRandomValue(Random rand) {
        return this.minValue + rand.nextDouble() * this.range();
    }

    public double findNewValue(double proposedNewValue) {
        double d;
        this.validateRange(proposedNewValue);
        if (this.redistributionFunction.isDefined()) {
            double v = (proposedNewValue - this.minValue) / this.range();
            d = this.minValue + this.range() * ((RedistributionFunction)this.redistributionFunction.get()).getInverseFunctionValue(v);
        } else {
            d = proposedNewValue;
        }
        return d;
    }

    public String toString() {
        StringBuilder sa = new StringBuilder(this.name);
        sa.append(" = ");
        sa.append(FormatUtil$.MODULE$.formatNumber(this.getValue()));
        sa.append(" [");
        sa.append(FormatUtil$.MODULE$.formatNumber(this.minValue));
        sa.append(", ");
        sa.append(FormatUtil$.MODULE$.formatNumber(this.maxValue));
        sa.append(']');
        if (this.redistributionFunction.isDefined()) {
            sa.append(" redistributionFunction=").append(this.redistributionFunction.get());
        }
        return sa.toString();
    }

    @Override
    public Class<?> getType() {
        return this.isIntegerOnly() ? Integer.TYPE : Float.TYPE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getValue() {
        void var1_2;
        double d;
        if (this.redistributionFunction.isDefined()) {
            double v = (this.value - this.minValue) / this.range();
            v = ((RedistributionFunction)this.redistributionFunction.get()).getValue(v);
            d = v * this.range() + this.minValue;
        } else {
            d = this.value;
        }
        double retValue = d;
        this.validateRange(retValue);
        return (double)var1_2;
    }

    private void validateRange(double value) {
        if (!(value >= this.minValue) || !(value <= this.maxValue)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new java.lang.StringBuilder(40).append("Value ").append(value).append(" outside range [").append(this.minValue).append(", ").append(this.maxValue).append("] for parameter ").append(this.name).toString());
        }
    }
}

