/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.types;

import com.barrybecker4.optimization.parameter.ParameterChangeListener;
import com.barrybecker4.optimization.parameter.redistribution.BooleanRedistribution;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction;
import com.barrybecker4.optimization.parameter.types.AbstractIntParameter;
import com.barrybecker4.optimization.parameter.types.BooleanParameter$;
import com.barrybecker4.optimization.parameter.ui.BooleanParameterWidget;
import com.barrybecker4.optimization.parameter.ui.ParameterWidget;
import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Random;

public class BooleanParameter
extends AbstractIntParameter
implements Product,
Serializable {
    private final boolean bValue;
    private final String name;
    private final Option redistFunc;

    public static BooleanParameter apply(boolean bl, String string, Option<BooleanRedistribution> option) {
        return BooleanParameter$.MODULE$.apply(bl, string, option);
    }

    public static BooleanParameter createSkewedParameter(boolean bl, String string, double d) {
        return BooleanParameter$.MODULE$.createSkewedParameter(bl, string, d);
    }

    public static BooleanParameter fromProduct(Product product) {
        return BooleanParameter$.MODULE$.fromProduct(product);
    }

    public static BooleanParameter unapply(BooleanParameter booleanParameter) {
        return BooleanParameter$.MODULE$.unapply(booleanParameter);
    }

    public static Option<BooleanRedistribution> $lessinit$greater$default$3() {
        return BooleanParameter$.MODULE$.$lessinit$greater$default$3();
    }

    public BooleanParameter(boolean bValue, String name, Option<BooleanRedistribution> redistFunc) {
        this.bValue = bValue;
        this.name = name;
        this.redistFunc = redistFunc;
        super(bValue ? 1 : 0, 0, 1, name, redistFunc);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)(this.bValue() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.redistFunc()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BooleanParameter)) return false;
        BooleanParameter booleanParameter = (BooleanParameter)object;
        if (this.bValue() != booleanParameter.bValue()) return false;
        String string = this.name();
        String string2 = booleanParameter.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<BooleanRedistribution> option = this.redistFunc();
        Option<BooleanRedistribution> option2 = booleanParameter.redistFunc();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!booleanParameter.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof BooleanParameter;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "BooleanParameter";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = BoxesRunTime.boxToBoolean((boolean)this._1());
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "bValue";
                break;
            }
            case 1: {
                string = "name";
                break;
            }
            case 2: {
                string = "redistFunc";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public boolean bValue() {
        return this.bValue;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Option<BooleanRedistribution> redistFunc() {
        return this.redistFunc;
    }

    @Override
    public double minValue() {
        return 0.0;
    }

    @Override
    public double maxValue() {
        return 1.0;
    }

    @Override
    public BooleanParameter copy() {
        return BooleanParameter$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)this.getNaturalValue()), this.name(), this.redistFunc());
    }

    @Override
    public BooleanParameter randomizeValue(Random rand) {
        return new BooleanParameter((double)this.getRandomVal(rand) == 1.0, this.name(), this.redistFunc());
    }

    @Override
    public BooleanParameter tweakValue(double r, Random rand) {
        return new BooleanParameter(this.tweakIntValue(r, rand) == 0, this.name(), this.redistFunc());
    }

    @Override
    public BooleanParameter setValue(double value) {
        double d;
        if (this.redistFunc().isDefined()) {
            double v = (value - this.minValue()) / (this.range() + 1.0);
            d = this.minValue() + (this.range() + 1.0) * ((RedistributionFunction)this.redistFunc().get()).getInverseFunctionValue(v);
        } else {
            d = value;
        }
        double retValue = d;
        return new BooleanParameter((int)retValue == 1, this.name(), this.redistFunc());
    }

    @Override
    public Object getNaturalValue() {
        return BoxesRunTime.boxToBoolean(((int)this.getValue() % 2 == 1 ? 1 : 0) != 0);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public Class<?> getType() {
        return Boolean.TYPE;
    }

    @Override
    public ParameterWidget createWidget(ParameterChangeListener listener) {
        return new BooleanParameterWidget(this, listener);
    }

    public BooleanParameter copy(boolean bValue, String name, Option<BooleanRedistribution> redistFunc) {
        return new BooleanParameter(bValue, name, redistFunc);
    }

    public boolean copy$default$1() {
        return this.bValue();
    }

    public String copy$default$2() {
        return this.name();
    }

    public Option<BooleanRedistribution> copy$default$3() {
        return this.redistFunc();
    }

    public boolean _1() {
        return this.bValue();
    }

    public String _2() {
        return this.name();
    }

    public Option<BooleanRedistribution> _3() {
        return this.redistFunc();
    }
}

