/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.types;

import com.barrybecker4.optimization.parameter.Direction;
import com.barrybecker4.optimization.parameter.ParameterChangeListener;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction;
import com.barrybecker4.optimization.parameter.types.AbstractParameter;
import com.barrybecker4.optimization.parameter.types.DoubleParameter$;
import com.barrybecker4.optimization.parameter.types.Parameter;
import com.barrybecker4.optimization.parameter.ui.DoubleParameterWidget;
import com.barrybecker4.optimization.parameter.ui.ParameterWidget;
import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Random;

public class DoubleParameter
extends AbstractParameter
implements Product,
Serializable {
    private final double value;
    private final double minValue;
    private final double maxValue;
    private final String name;
    private final Option redistFunc;

    public static DoubleParameter apply(double d, double d2, double d3, String string, Option<RedistributionFunction> option) {
        return DoubleParameter$.MODULE$.apply(d, d2, d3, string, option);
    }

    public static DoubleParameter createGaussianParameter(double d, double d2, double d3, String string, double d4, double d5) {
        return DoubleParameter$.MODULE$.createGaussianParameter(d, d2, d3, string, d4, d5);
    }

    public static DoubleParameter createUniformParameter(double d, double d2, double d3, String string, double[] dArray, double[] dArray2) {
        return DoubleParameter$.MODULE$.createUniformParameter(d, d2, d3, string, dArray, dArray2);
    }

    public static DoubleParameter fromProduct(Product product) {
        return DoubleParameter$.MODULE$.fromProduct(product);
    }

    public static DoubleParameter unapply(DoubleParameter doubleParameter) {
        return DoubleParameter$.MODULE$.unapply(doubleParameter);
    }

    public static Option<RedistributionFunction> $lessinit$greater$default$5() {
        return DoubleParameter$.MODULE$.$lessinit$greater$default$5();
    }

    public DoubleParameter(double value, double minValue, double maxValue, String name, Option<RedistributionFunction> redistFunc) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.name = name;
        this.redistFunc = redistFunc;
        super(value, minValue, maxValue, name, redistFunc);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minValue()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.maxValue()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.redistFunc()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DoubleParameter)) return false;
        DoubleParameter doubleParameter = (DoubleParameter)object;
        if (this.value() != doubleParameter.value()) return false;
        if (this.minValue() != doubleParameter.minValue()) return false;
        if (this.maxValue() != doubleParameter.maxValue()) return false;
        String string = this.name();
        String string2 = doubleParameter.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<RedistributionFunction> option = this.redistFunc();
        Option<RedistributionFunction> option2 = doubleParameter.redistFunc();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!doubleParameter.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof DoubleParameter;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "DoubleParameter";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = BoxesRunTime.boxToDouble((double)this._1());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this._2());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToDouble((double)this._3());
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "value";
                break;
            }
            case 1: {
                string = "minValue";
                break;
            }
            case 2: {
                string = "maxValue";
                break;
            }
            case 3: {
                string = "name";
                break;
            }
            case 4: {
                string = "redistFunc";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public double value() {
        return this.value;
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Option<RedistributionFunction> redistFunc() {
        return this.redistFunc;
    }

    @Override
    public Parameter copy() {
        return DoubleParameter$.MODULE$.apply(this.getValue(), this.minValue(), this.maxValue(), this.name(), this.redistFunc());
    }

    @Override
    public boolean isIntegerOnly() {
        return false;
    }

    @Override
    public DoubleParameter randomizeValue(Random rand) {
        return new DoubleParameter(this.getRandomValue(rand), this.minValue(), this.maxValue(), this.name(), this.redistFunc());
    }

    @Override
    public DoubleParameter tweakValue(double r, Random rand) {
        return DoubleParameter$.MODULE$.apply(this.tweakNumericValue(this.value(), r, rand), this.minValue(), this.maxValue(), this.name(), this.redistFunc());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getIncrementForDirection(Direction direction) {
        void var2_2;
        double increment = (double)direction.multiplier() * (this.maxValue() - this.minValue()) / (double)DoubleParameter$.com$barrybecker4$optimization$parameter$types$DoubleParameter$$$NUM_STEPS;
        return this.value() + increment > this.maxValue() ? this.maxValue() : (this.value() + increment < this.minValue() ? 0.0 : var2_2);
    }

    @Override
    public DoubleParameter incrementByEps(Direction direction) {
        double increment = this.getIncrementForDirection(direction);
        return DoubleParameter$.MODULE$.apply(this.value() + increment, this.minValue(), this.maxValue(), this.name(), this.redistFunc());
    }

    @Override
    public DoubleParameter setValue(double value) {
        double newVal = this.findNewValue(value);
        return new DoubleParameter(newVal, this.minValue(), this.maxValue(), this.name(), this.redistFunc());
    }

    @Override
    public Object getNaturalValue() {
        return BoxesRunTime.boxToDouble((double)this.getValue());
    }

    @Override
    public Class<?> getType() {
        return Float.TYPE;
    }

    @Override
    public ParameterWidget createWidget(ParameterChangeListener listener) {
        return new DoubleParameterWidget(this, listener);
    }

    public DoubleParameter copy(double value, double minValue, double maxValue, String name, Option<RedistributionFunction> redistFunc) {
        return new DoubleParameter(value, minValue, maxValue, name, redistFunc);
    }

    public double copy$default$1() {
        return this.value();
    }

    public double copy$default$2() {
        return this.minValue();
    }

    public double copy$default$3() {
        return this.maxValue();
    }

    public String copy$default$4() {
        return this.name();
    }

    public Option<RedistributionFunction> copy$default$5() {
        return this.redistFunc();
    }

    public double _1() {
        return this.value();
    }

    public double _2() {
        return this.minValue();
    }

    public double _3() {
        return this.maxValue();
    }

    public String _4() {
        return this.name();
    }

    public Option<RedistributionFunction> _5() {
        return this.redistFunc();
    }
}

