/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.types;

import com.barrybecker4.math.MathUtil$;
import com.barrybecker4.optimization.parameter.Direction;
import com.barrybecker4.optimization.parameter.ParameterChangeListener;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction;
import com.barrybecker4.optimization.parameter.types.AbstractIntParameter;
import com.barrybecker4.optimization.parameter.types.IntegerParameter$;
import com.barrybecker4.optimization.parameter.ui.DoubleParameterWidget;
import com.barrybecker4.optimization.parameter.ui.ParameterWidget;
import java.io.Serializable;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.Statics;
import scala.util.Random;

public class IntegerParameter
extends AbstractIntParameter
implements Product,
Serializable {
    private final double theVal;
    private final double minValue;
    private final double maxValue;
    private final String name;
    private final Option redisFunc;

    public static IntegerParameter apply(double d, double d2, double d3, String string, Option<RedistributionFunction> option) {
        return IntegerParameter$.MODULE$.apply(d, d2, d3, string, option);
    }

    public static IntegerParameter createDiscreteParameter(int n, int n2, int n3, String string, int[] nArray, double[] dArray) {
        return IntegerParameter$.MODULE$.createDiscreteParameter(n, n2, n3, string, nArray, dArray);
    }

    public static IntegerParameter fromProduct(Product product) {
        return IntegerParameter$.MODULE$.fromProduct(product);
    }

    public static IntegerParameter unapply(IntegerParameter integerParameter) {
        return IntegerParameter$.MODULE$.unapply(integerParameter);
    }

    public static Option<RedistributionFunction> $lessinit$greater$default$5() {
        return IntegerParameter$.MODULE$.$lessinit$greater$default$5();
    }

    public IntegerParameter(double theVal, double minValue, double maxValue, String name, Option<RedistributionFunction> redisFunc) {
        this.theVal = theVal;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.name = name;
        this.redisFunc = redisFunc;
        super((int)theVal, (int)minValue, (int)maxValue, name, redisFunc);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.theVal()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minValue()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.maxValue()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.redisFunc()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof IntegerParameter)) return false;
        IntegerParameter integerParameter = (IntegerParameter)object;
        if (this.theVal() != integerParameter.theVal()) return false;
        if (this.minValue() != integerParameter.minValue()) return false;
        if (this.maxValue() != integerParameter.maxValue()) return false;
        String string = this.name();
        String string2 = integerParameter.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<RedistributionFunction> option = this.redisFunc();
        Option<RedistributionFunction> option2 = integerParameter.redisFunc();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!integerParameter.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof IntegerParameter;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "IntegerParameter";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = BoxesRunTime.boxToDouble((double)this._1());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this._2());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToDouble((double)this._3());
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            case 4: {
                object = this._5();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "theVal";
                break;
            }
            case 1: {
                string = "minValue";
                break;
            }
            case 2: {
                string = "maxValue";
                break;
            }
            case 3: {
                string = "name";
                break;
            }
            case 4: {
                string = "redisFunc";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public double theVal() {
        return this.theVal;
    }

    @Override
    public double minValue() {
        return this.minValue;
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Option<RedistributionFunction> redisFunc() {
        return this.redisFunc;
    }

    @Override
    public IntegerParameter copy() {
        return IntegerParameter$.MODULE$.apply(Int$.MODULE$.int2double((int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.getValue()))), this.minValue(), this.maxValue(), this.name(), this.redisFunc());
    }

    @Override
    public IntegerParameter randomizeValue(Random rand) {
        return IntegerParameter$.MODULE$.apply(Int$.MODULE$.int2double(this.getRandomVal(rand)), this.minValue(), this.maxValue(), this.name(), this.redisFunc());
    }

    @Override
    public IntegerParameter tweakValue(double r, Random rand) {
        return IntegerParameter$.MODULE$.apply(Int$.MODULE$.int2double(this.tweakIntValue(r, rand)), this.minValue(), this.maxValue(), this.name(), this.redisFunc());
    }

    @Override
    public IntegerParameter incrementByEps(Direction direction) {
        return new IntegerParameter(Int$.MODULE$.int2double((int)(this.getValue() + (double)direction.multiplier())), this.minValue(), this.maxValue(), this.name(), this.redisFunc());
    }

    @Override
    public IntegerParameter setValue(double value) {
        double d;
        if (this.redisFunc().isDefined()) {
            double v = (value - this.minValue()) / (this.range() + 1.0);
            d = this.minValue() + (this.range() + 1.0) * ((RedistributionFunction)this.redisFunc().get()).getInverseFunctionValue(v);
        } else {
            d = value;
        }
        double retValue = d;
        return new IntegerParameter(Int$.MODULE$.int2double((int)retValue), this.minValue(), this.maxValue(), this.name(), this.redisFunc());
    }

    @Override
    public double getValue() {
        double d;
        if (this.redisFunc().isDefined()) {
            double v = (this.theVal() - this.minValue()) / (this.range() + 1.0);
            double rv = ((RedistributionFunction)this.redisFunc().get()).getValue(v);
            d = RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(rv * (this.range() + (1.0 - MathUtil$.MODULE$.EPS())) + this.minValue()));
        } else {
            d = this.theVal();
        }
        return d;
    }

    @Override
    public Object getNaturalValue() {
        return BoxesRunTime.boxToLong((long)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.getValue())));
    }

    @Override
    public Class<?> getType() {
        return Integer.TYPE;
    }

    @Override
    public ParameterWidget createWidget(ParameterChangeListener listener) {
        return new DoubleParameterWidget(this, listener);
    }

    public IntegerParameter copy(double theVal, double minValue, double maxValue, String name, Option<RedistributionFunction> redisFunc) {
        return new IntegerParameter(theVal, minValue, maxValue, name, redisFunc);
    }

    public double copy$default$1() {
        return this.theVal();
    }

    public double copy$default$2() {
        return this.minValue();
    }

    public double copy$default$3() {
        return this.maxValue();
    }

    public String copy$default$4() {
        return this.name();
    }

    public Option<RedistributionFunction> copy$default$5() {
        return this.redisFunc();
    }

    public double _1() {
        return this.theVal();
    }

    public double _2() {
        return this.minValue();
    }

    public double _3() {
        return this.maxValue();
    }

    public String _4() {
        return this.name();
    }

    public Option<RedistributionFunction> _5() {
        return this.redisFunc();
    }
}

