/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.types;

import com.barrybecker4.optimization.parameter.ParameterChangeListener;
import com.barrybecker4.optimization.parameter.redistribution.RedistributionFunction;
import com.barrybecker4.optimization.parameter.types.AbstractIntParameter;
import com.barrybecker4.optimization.parameter.types.StringParameter$;
import com.barrybecker4.optimization.parameter.ui.ParameterWidget;
import com.barrybecker4.optimization.parameter.ui.StringParameterWidget;
import java.io.Serializable;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Random;

public class StringParameter
extends AbstractIntParameter
implements Product,
Serializable {
    private final int index;
    private final IndexedSeq values;
    private final String name;
    private final Option redistFunc;

    public static StringParameter apply(int n, IndexedSeq<String> indexedSeq, String string, Option<RedistributionFunction> option) {
        return StringParameter$.MODULE$.apply(n, indexedSeq, string, option);
    }

    public static StringParameter fromProduct(Product product) {
        return StringParameter$.MODULE$.fromProduct(product);
    }

    public static StringParameter unapply(StringParameter stringParameter) {
        return StringParameter$.MODULE$.unapply(stringParameter);
    }

    public static Option<RedistributionFunction> $lessinit$greater$default$4() {
        return StringParameter$.MODULE$.$lessinit$greater$default$4();
    }

    public StringParameter(int index, IndexedSeq<String> values, String name, Option<RedistributionFunction> redistFunc) {
        this.index = index;
        this.values = values;
        this.name = name;
        this.redistFunc = redistFunc;
        super(index, 0, values.length() - 1, name, redistFunc);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.index());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.values()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.redistFunc()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof StringParameter)) return false;
        StringParameter stringParameter = (StringParameter)object;
        if (this.index() != stringParameter.index()) return false;
        IndexedSeq<String> indexedSeq = this.values();
        IndexedSeq<String> indexedSeq2 = stringParameter.values();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        String string = this.name();
        String string2 = stringParameter.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<RedistributionFunction> option = this.redistFunc();
        Option<RedistributionFunction> option2 = stringParameter.redistFunc();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringParameter.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof StringParameter;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "StringParameter";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this._1());
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "index";
                break;
            }
            case 1: {
                string = "values";
                break;
            }
            case 2: {
                string = "name";
                break;
            }
            case 3: {
                string = "redistFunc";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public int index() {
        return this.index;
    }

    public IndexedSeq<String> values() {
        return this.values;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Option<RedistributionFunction> redistFunc() {
        return this.redistFunc;
    }

    public StringParameter(Enum<?> theVal, IndexedSeq<Enum<?>> enumValues, String paramName) {
        this(theVal.ordinal(), StringParameter.StringParameter$superArg$1(theVal, enumValues, paramName), paramName, (Option<RedistributionFunction>)None$.MODULE$);
    }

    @Override
    public double minValue() {
        return 0.0;
    }

    @Override
    public double maxValue() {
        return Int$.MODULE$.int2double(this.values().length() - 1);
    }

    @Override
    public StringParameter copy() {
        return StringParameter$.MODULE$.apply((int)this.getValue(), this.values(), this.name(), this.redistFunc());
    }

    @Override
    public StringParameter randomizeValue(Random rand) {
        return StringParameter$.MODULE$.apply(this.getRandomVal(rand), this.values(), this.name(), this.redistFunc());
    }

    @Override
    public StringParameter tweakValue(double r, Random rand) {
        return StringParameter$.MODULE$.apply(this.tweakIntValue(r, rand), this.values(), this.name(), this.redistFunc());
    }

    @Override
    public StringParameter setValue(double value) {
        double d;
        if (this.redistFunc().isDefined()) {
            double v = (value - this.minValue()) / (this.range() + 1.0);
            d = this.minValue() + (this.range() + 1.0) * ((RedistributionFunction)this.redistFunc().get()).getInverseFunctionValue(v);
        } else {
            d = value;
        }
        double retValue = d;
        return StringParameter$.MODULE$.apply((int)retValue, this.values(), this.name(), this.redistFunc());
    }

    @Override
    public Object getNaturalValue() {
        return this.values().apply((int)this.getValue());
    }

    public IndexedSeq<String> getStringValues() {
        return this.values();
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public Class<?> getType() {
        return String.class;
    }

    @Override
    public ParameterWidget createWidget(ParameterChangeListener listener) {
        return new StringParameterWidget(this, listener);
    }

    public StringParameter copy(int index, IndexedSeq<String> values, String name, Option<RedistributionFunction> redistFunc) {
        return new StringParameter(index, values, name, redistFunc);
    }

    public int copy$default$1() {
        return this.index();
    }

    public IndexedSeq<String> copy$default$2() {
        return this.values();
    }

    public String copy$default$3() {
        return this.name();
    }

    public Option<RedistributionFunction> copy$default$4() {
        return this.redistFunc();
    }

    public int _1() {
        return this.index();
    }

    public IndexedSeq<String> _2() {
        return this.values();
    }

    public String _3() {
        return this.name();
    }

    public Option<RedistributionFunction> _4() {
        return this.redistFunc();
    }

    private static IndexedSeq<String> StringParameter$superArg$1(Enum<?> theVal, IndexedSeq<Enum<?>> enumValues, String paramName) {
        return (IndexedSeq)enumValues.map((Function1 & Serializable)_$1 -> _$1.toString());
    }
}

