/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.parameter.ui;

import com.barrybecker4.optimization.parameter.ParameterChangeListener;
import com.barrybecker4.optimization.parameter.types.BooleanParameter;
import com.barrybecker4.optimization.parameter.types.Parameter;
import com.barrybecker4.optimization.parameter.ui.ParameterWidget;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import scala.runtime.BoxesRunTime;

public class BooleanParameterWidget
extends ParameterWidget
implements ItemListener {
    private final ParameterChangeListener listener;
    private JCheckBox cb;

    public BooleanParameterWidget(Parameter param, ParameterChangeListener listener) {
        this.listener = listener;
        super(param, listener);
    }

    public ParameterChangeListener listener() {
        return this.listener;
    }

    @Override
    public void addChildren() {
        this.cb = new JCheckBox();
        this.cb.setText(this.parameter().name());
        BooleanParameter bparam = (BooleanParameter)this.parameter();
        this.cb.setSelected(BoxesRunTime.unboxToBoolean((Object)bparam.getNaturalValue()));
        this.cb.addItemListener(this);
        this.add((Component)this.cb, "Center");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.parameter_$eq(this.parameter().setValue(this.cb.isSelected() ? 1.0 : 0.0));
        this.doNotification();
    }

    @Override
    public void refreshInternal() {
        this.cb.setSelected(BoxesRunTime.unboxToBoolean((Object)this.parameter().getNaturalValue()));
    }

    @Override
    public int getMaxHeight() {
        return 20;
    }
}

