/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.strategy;

import com.barrybecker4.common.format.FormatUtil$;
import com.barrybecker4.optimization.optimizee.Optimizee;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness$;
import com.barrybecker4.optimization.strategy.GeneticSearchStrategy$;
import com.barrybecker4.optimization.strategy.OptimizationStrategy;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering$;
import scala.runtime.ObjectRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Random;

public class GeneticSearchStrategy
extends OptimizationStrategy {
    private final Optimizee optimizee;
    private final Random rnd;
    private double nbrRadius;
    private int desiredPopulationSize;
    private double improvementEpsilon;

    public static Random $lessinit$greater$default$2() {
        return GeneticSearchStrategy$.MODULE$.$lessinit$greater$default$2();
    }

    public GeneticSearchStrategy(Optimizee optimizee, Random rnd) {
        this.optimizee = optimizee;
        this.rnd = rnd;
        super(optimizee);
        this.nbrRadius = GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$NBR_RADIUS;
        this.desiredPopulationSize = 0;
        this.improvementEpsilon = GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$DEFAULT_IMPROVEMENT_EPS;
    }

    public double improvementEpsilon() {
        return this.improvementEpsilon;
    }

    public void improvementEpsilon_$eq(double x$1) {
        this.improvementEpsilon = x$1;
    }

    public void setImprovementEpsilon(double eps) {
        this.improvementEpsilon_$eq(eps);
    }

    @Override
    public ParameterArrayWithFitness doOptimization(ParameterArray params, double fitnessRange) {
        ParameterArrayWithFitness lastBest = null;
        this.desiredPopulationSize = params.getSamplePopulationSize();
        ArrayBuffer<ParameterArrayWithFitness> population = this.findInitialPopulation(params);
        lastBest = (ParameterArrayWithFitness)population.min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return this.evolve(params, lastBest, population, fitnessRange);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBuffer<ParameterArrayWithFitness> findInitialPopulation(ParameterArray params) {
        void var2_2;
        ArrayBuffer population = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ParameterArrayWithFitness[0]));
        double fitness = this.optimizee.evaluateByComparison() ? Double.MAX_VALUE : this.optimizee.evaluateFitness(params);
        ParameterArrayWithFitness p1 = ParameterArrayWithFitness$.MODULE$.apply(params, fitness);
        population.$plus$eq((Object)p1);
        int max = 100 * this.desiredPopulationSize;
        for (int i = 0; population.size() < this.desiredPopulationSize && i < max; ++i) {
            ParameterArray nbr = params.getRandomNeighbor(GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$INITIAL_RADIUS);
            if (population.contains((Object)nbr)) continue;
            double fitness2 = this.optimizee.evaluateByComparison() ? this.optimizee.compareFitness(nbr, params) : this.optimizee.evaluateFitness(params);
            population.$plus$eq((Object)ParameterArrayWithFitness$.MODULE$.apply(nbr, fitness2));
        }
        if (population.size() <= 1) {
            throw new IllegalStateException(new StringBuilder(30).append("No random neighbors found for ").append(params).toString());
        }
        return var2_2;
    }

    private ParameterArrayWithFitness evolve(ParameterArray params, ParameterArrayWithFitness lastBest, ArrayBuffer<ParameterArrayWithFitness> population, double fitnessRange) {
        ParameterArrayWithFitness currentBest = lastBest;
        int ct = 0;
        double deltaFitness = -1.0;
        int numWithNoImprovement = 0;
        double lowThresh = 0.005 * fitnessRange;
        double highThresh = 0.05 * fitnessRange;
        ParameterArrayWithFitness recentBest = lastBest;
        ArrayBuffer<ParameterArrayWithFitness> pop = population;
        while (!(deltaFitness >= -this.improvementEpsilon() && numWithNoImprovement > GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$MAX_ITER_NO_IMPRV || this.isOptimalFitnessReached(currentBest) || ct > GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$MAX_ITERATIONS)) {
            pop = this.cullPopulation(pop);
            this.replaceCulledWithKeeperVariants(pop, pop.size());
            currentBest = (ParameterArrayWithFitness)pop.min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            Predef$.MODULE$.println((Object)new StringBuilder(34).append("currBest = ").append(currentBest).append(" \nrecBest = ").append(recentBest).append("        ct=").append(ct).toString());
            deltaFitness = this.computeFitnessDelta(params, recentBest, currentBest, ct);
            Predef$.MODULE$.println((Object)new StringBuilder(56).append("delta fitness =").append(deltaFitness).append("      rbrRadius = ").append(this.nbrRadius).append("  improvementEpsilon = ").append(this.improvementEpsilon()).toString());
            double factor = deltaFitness < -highThresh ? GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$NBR_RADIUS_EXPAND_FACTOR : (deltaFitness > -lowThresh ? GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$NBR_RADIUS_SHRINK_FACTOR : 1.0);
            this.nbrRadius *= factor;
            recentBest = currentBest;
            this.notifyOfChange(currentBest);
            ++ct;
            if (!(deltaFitness <= 0.0)) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"The fitness should never get worse.");
            }
            if (!(deltaFitness > -this.improvementEpsilon())) continue;
            ++numWithNoImprovement;
        }
        if (this.isOptimalFitnessReached(currentBest)) {
            Predef$.MODULE$.println((Object)"stopped because we found the optimal fitness.");
        } else if (deltaFitness >= -this.improvementEpsilon() && numWithNoImprovement > GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$MAX_ITER_NO_IMPRV) {
            Predef$.MODULE$.println((Object)new StringBuilder(59).append("stopped because we made no IMPROVEMENT. The delta, ").append(deltaFitness).append(" was >= ").append(-this.improvementEpsilon()).toString());
        } else if (ct > GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$MAX_ITERATIONS) {
            Predef$.MODULE$.println((Object)new StringBuilder(67).append("Stopped because we exceeded the MAX ITERATIONS(").append(GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$MAX_ITERATIONS).append("): num iterations = ").append(ct).toString());
        } else {
            throw new IllegalStateException(new StringBuilder(46).append("stopped for unexpected cause. ct = ").append(ct).append(" deltaFit=").append(deltaFitness).append(" ").append(new StringBuilder(17).append("currBest=").append(currentBest).append(" nbrRad=").append(this.nbrRadius).toString()).toString());
        }
        Predef$.MODULE$.println((Object)"----------------------- done -------------------");
        this.log(ct, currentBest, 0.0, 0.0, FormatUtil$.MODULE$.formatNumber(ct));
        return currentBest;
    }

    private double computeFitnessDelta(ParameterArray params, ParameterArrayWithFitness lastBest, ParameterArrayWithFitness currentBest, int ct) {
        double deltaFitness = 0.0;
        deltaFitness = currentBest.fitness() - lastBest.fitness();
        if (!(deltaFitness <= 0.0)) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(73).append("We must never get worse in a new generation. Old fitness=").append(lastBest.fitness()).append(" New Fitness = ").append(currentBest.fitness()).append(".").toString());
        }
        this.log(ct, currentBest, this.nbrRadius, deltaFitness, "---");
        return deltaFitness;
    }

    private ArrayBuffer<ParameterArrayWithFitness> cullPopulation(ArrayBuffer<ParameterArrayWithFitness> population) {
        ArrayBuffer sortedPopulation = (ArrayBuffer)population.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        int keepSize = Math.max(1, (int)((double)sortedPopulation.size() * (1.0 - GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$CULL_FACTOR)));
        int size = sortedPopulation.size();
        ArrayBuffer culledPop = (ArrayBuffer)sortedPopulation.dropRight(size - keepSize);
        return culledPop;
    }

    private void replaceCulledWithKeeperVariants(ArrayBuffer<ParameterArrayWithFitness> population, int keepSize) {
        for (int k = keepSize; k < this.desiredPopulationSize; ++k) {
            double r = this.rnd.nextDouble();
            int keeperIndex = (int)(r * r * (double)keepSize);
            ParameterArrayWithFitness p = (ParameterArrayWithFitness)population.apply(keeperIndex);
            double r2 = ((double)keeperIndex + GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$NBR_RADIUS_SOFTENER) / GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$NBR_RADIUS_SOFTENER * this.nbrRadius;
            ParameterArrayWithFitness nbr = this.getNeighbor(p.pa(), r2);
            if (population.contains((Object)nbr)) continue;
            population.$plus$eq((Object)nbr);
            this.notifyOfChange(p);
        }
    }

    private ParameterArrayWithFitness getNeighbor(ParameterArray p, double rad) {
        ParameterArray nbr = p.getRandomNeighbor(rad);
        double nbrFitness = Double.MAX_VALUE;
        if (!this.optimizee.evaluateByComparison()) {
            double curFitness = this.optimizee.evaluateFitness(p);
            nbrFitness = this.optimizee.evaluateFitness(nbr);
            for (int ct = 0; nbrFitness >= curFitness && ct < GeneticSearchStrategy$.com$barrybecker4$optimization$strategy$GeneticSearchStrategy$$$MAX_NBRS_TO_EXPLORE; ++ct) {
                nbr = p.getRandomNeighbor(rad);
                nbrFitness = this.optimizee.evaluateFitness(nbr);
            }
        }
        return ParameterArrayWithFitness$.MODULE$.apply(nbr, nbrFitness);
    }

    public ParameterArrayWithFitness evaluatePopulation(ArrayBuffer<ParameterArray> population, ParameterArray previousBest) {
        ObjectRef bestFitness = ObjectRef.create((Object)ParameterArrayWithFitness$.MODULE$.apply(previousBest, Double.MAX_VALUE));
        population.foreach((Function1)(JProcedure1 & Serializable)p -> {
            double fitness;
            double d = fitness = this.optimizee.evaluateByComparison() ? this.optimizee.compareFitness((ParameterArray)p, previousBest) : this.optimizee.evaluateFitness((ParameterArray)p);
            if (fitness < ((ParameterArrayWithFitness)bestFitness$1.elem).fitness()) {
                ParameterArrayWithFitness parameterArrayWithFitness = ParameterArrayWithFitness$.MODULE$.apply((ParameterArray)p, fitness);
                bestFitness$1.elem = parameterArrayWithFitness;
                this.notifyOfChange((ParameterArrayWithFitness)bestFitness$1.elem);
            }
        });
        return (ParameterArrayWithFitness)bestFitness.elem;
    }

    private void printPopulation(List<?> population) {
        this.printPopulation(population, population.size());
    }

    private void printPopulation(List<?> population, int limit) {
        for (int i = 0; i < population.size() && i < limit; ++i) {
            Predef$.MODULE$.println((Object)"$i: ${population(i)}");
        }
        Predef$.MODULE$.println((Object)"");
    }
}

