/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.strategy;

import com.barrybecker4.optimization.optimizee.Optimizee;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness$;
import com.barrybecker4.optimization.strategy.GlobalSampleStrategy$;
import com.barrybecker4.optimization.strategy.OptimizationStrategy;
import scala.Int$;
import scala.collection.Iterator;
import scala.runtime.Scala3RunTime$;

public class GlobalSampleStrategy
extends OptimizationStrategy {
    private final Optimizee optimizee;
    private int numSample;

    public GlobalSampleStrategy(Optimizee optimizee) {
        this.optimizee = optimizee;
        super(optimizee);
        this.numSample = GlobalSampleStrategy$.com$barrybecker4$optimization$strategy$GlobalSampleStrategy$$$DEFAULT_NUM_SAMPLES;
    }

    public void setSamplingRate(int samplingRate) {
        if (samplingRate <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.numSample = samplingRate;
    }

    @Override
    public ParameterArrayWithFitness doOptimization(ParameterArray params, double fitnessRange) {
        Iterator<? extends ParameterArray> samples = params.findGlobalSamples(Int$.MODULE$.int2long(this.numSample));
        ParameterArrayWithFitness bestParams = ParameterArrayWithFitness$.MODULE$.apply(params, Double.MAX_VALUE);
        boolean done = false;
        while (samples.hasNext() && !done) {
            double fitness;
            ParameterArray sample = (ParameterArray)samples.next();
            double d = fitness = this.optimizee.evaluateByComparison() ? this.optimizee.compareFitness(sample, params) : this.optimizee.evaluateFitness(sample);
            if (fitness < bestParams.fitness()) {
                bestParams = ParameterArrayWithFitness$.MODULE$.apply(sample, fitness);
                this.notifyOfChange(bestParams);
            }
            if (!this.isOptimalFitnessReached(bestParams)) continue;
            done = true;
        }
        return bestParams;
    }
}

