/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.strategy;

import com.barrybecker4.optimization.optimizee.Optimizee;
import com.barrybecker4.optimization.parameter.AbstractParameterArray;
import com.barrybecker4.optimization.parameter.NumericParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness$;
import com.barrybecker4.optimization.parameter.PermutedParameterArray;
import com.barrybecker4.optimization.parameter.VariableLengthIntSet;
import com.barrybecker4.optimization.strategy.OptimizationStrategy;
import com.barrybecker4.optimization.strategy.gradient.DiscreteImprovementFinder;
import com.barrybecker4.optimization.strategy.gradient.Improvement;
import com.barrybecker4.optimization.strategy.gradient.ImprovementFinder;
import com.barrybecker4.optimization.strategy.gradient.NumericImprovementFinder;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.runtime.ScalaRunTime$;

public class HillClimbingStrategy
extends OptimizationStrategy {
    private final Optimizee optimizee;

    public HillClimbingStrategy(Optimizee optimizee) {
        this.optimizee = optimizee;
        super(optimizee);
    }

    @Override
    public ParameterArrayWithFitness doOptimization(ParameterArray params, double fitnessRange) {
        ParameterArrayWithFitness currentParams = this.optimizee.evaluateByComparison() ? ParameterArrayWithFitness$.MODULE$.apply(params, Double.MAX_VALUE) : ParameterArrayWithFitness$.MODULE$.apply(params, this.optimizee.evaluateFitness(params));
        int numIterations = 1;
        this.log(0, currentParams, 0.0, 0.0, "initial test");
        this.notifyOfChange(currentParams);
        HashSet cache = (HashSet)HashSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ParameterArray[0]));
        cache.$plus$eq((Object)currentParams.pa());
        ImprovementFinder impFinder = this.createImprovementFinder(currentParams);
        Improvement improvement = impFinder.findIncrementalImprovement(this.optimizee, null, (Set<ParameterArray>)cache);
        currentParams = improvement.parameters();
        while (improvement.improved() && !this.isOptimalFitnessReached(currentParams)) {
            improvement = impFinder.findIncrementalImprovement(this.optimizee, improvement, (Set<ParameterArray>)cache);
            ++numIterations;
            currentParams = improvement.parameters();
            this.notifyOfChange(currentParams);
        }
        return currentParams;
    }

    private ImprovementFinder createImprovementFinder(ParameterArrayWithFitness params) {
        ImprovementFinder improvementFinder;
        ParameterArray parameterArray = params.pa();
        if (parameterArray instanceof NumericParameterArray) {
            NumericParameterArray npa = (NumericParameterArray)parameterArray;
            improvementFinder = new NumericImprovementFinder(params);
        } else if (parameterArray instanceof PermutedParameterArray || parameterArray instanceof VariableLengthIntSet) {
            AbstractParameterArray dpa = (AbstractParameterArray)parameterArray;
            improvementFinder = new DiscreteImprovementFinder(params);
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected params type: ").append(params.pa().getClass().getName()).toString());
        }
        return improvementFinder;
    }
}

