/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.strategy;

import com.barrybecker4.optimization.Logger;
import com.barrybecker4.optimization.OptimizationListener;
import com.barrybecker4.optimization.optimizee.Optimizee;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import scala.runtime.Scala3RunTime$;

public abstract class OptimizationStrategy {
    private Optimizee optimizee;
    private Logger logger;
    private OptimizationListener listener;

    public OptimizationStrategy(Optimizee optimizee) {
        this.optimizee = optimizee;
    }

    public Optimizee optimizee() {
        return this.optimizee;
    }

    public void optimizee_$eq(Optimizee x$1) {
        this.optimizee = x$1;
    }

    public OptimizationListener listener() {
        return this.listener;
    }

    public void listener_$eq(OptimizationListener x$1) {
        this.listener = x$1;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void log(int iteration, ParameterArrayWithFitness params, double jumpSize, double deltaFitness, String msg) {
        if (this.logger != null) {
            this.logger.write(iteration, params.fitness(), jumpSize, deltaFitness, params.pa(), msg);
        }
    }

    public abstract ParameterArrayWithFitness doOptimization(ParameterArray var1, double var2);

    public void setListener(OptimizationListener listener) {
        this.listener_$eq(listener);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isOptimalFitnessReached(ParameterArrayWithFitness currentBest) {
        void var2_2;
        boolean optimalFitnessReached = false;
        if (!this.optimizee().evaluateByComparison() && currentBest != null) {
            if (!(this.optimizee().getOptimalFitness() >= 0.0)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            optimalFitnessReached = currentBest.fitness() <= this.optimizee().getOptimalFitness();
        }
        return (boolean)var2_2;
    }

    public void notifyOfChange(ParameterArrayWithFitness params) {
        if (this.listener() != null) {
            this.listener().optimizerChanged(params);
        }
    }
}

