/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.strategy;

import com.barrybecker4.common.format.FormatUtil$;
import com.barrybecker4.optimization.optimizee.Optimizee;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness$;
import com.barrybecker4.optimization.strategy.OptimizationStrategy;
import com.barrybecker4.optimization.strategy.SimulatedAnnealingStrategy$;
import scala.Int$;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

public class SimulatedAnnealingStrategy
extends OptimizationStrategy {
    private final Optimizee optimizee;
    private final Random rnd;
    private double tempMax;
    private final Set<ParameterArray> cache;

    public static Random $lessinit$greater$default$2() {
        return SimulatedAnnealingStrategy$.MODULE$.$lessinit$greater$default$2();
    }

    public SimulatedAnnealingStrategy(Optimizee optimizee, Random rnd) {
        this.optimizee = optimizee;
        this.rnd = rnd;
        super(optimizee);
        this.tempMax = SimulatedAnnealingStrategy$.com$barrybecker4$optimization$strategy$SimulatedAnnealingStrategy$$$DEFAULT_TEMP_MAX;
        this.cache = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ParameterArray[0]));
    }

    public void setMaxTemperature(double tempMax) {
        this.tempMax = tempMax;
    }

    @Override
    public ParameterArrayWithFitness doOptimization(ParameterArray params, double fitnessRange) {
        int ct = 0;
        double temperature = this.tempMax;
        double tempMin = this.tempMax / Math.pow(2.0, Int$.MODULE$.int2double(SimulatedAnnealingStrategy$.com$barrybecker4$optimization$strategy$SimulatedAnnealingStrategy$$$NUM_TEMP_ITERATIONS));
        ParameterArrayWithFitness bestParams = !this.optimizee.evaluateByComparison() ? ParameterArrayWithFitness$.MODULE$.apply(params, this.optimizee.evaluateFitness(params)) : ParameterArrayWithFitness$.MODULE$.apply(params, Double.MAX_VALUE);
        ParameterArrayWithFitness currentParams = null;
        while (currentParams == null || temperature > tempMin && !this.isOptimalFitnessReached(currentParams)) {
            currentParams = bestParams;
            while (ct < SimulatedAnnealingStrategy$.com$barrybecker4$optimization$strategy$SimulatedAnnealingStrategy$$$N * currentParams.pa().size() && !this.isOptimalFitnessReached(currentParams)) {
                if ((currentParams = this.findNeighbor(currentParams, ct, temperature, fitnessRange)).fitness() < bestParams.fitness()) {
                    bestParams = currentParams;
                    this.notifyOfChange(bestParams);
                }
                ++ct;
            }
            ct = 0;
            Predef$.MODULE$.println((Object)new StringBuilder(33).append("temp = ").append(temperature *= SimulatedAnnealingStrategy$.com$barrybecker4$optimization$strategy$SimulatedAnnealingStrategy$$$TEMP_DROP_FACTOR).append(" tempMin = ").append(tempMin).append("\n bestParams = ").append(bestParams).toString());
        }
        this.log(ct, bestParams, 0.0, 0.0, FormatUtil$.MODULE$.formatNumber(temperature));
        return bestParams;
    }

    private ParameterArrayWithFitness findNeighbor(ParameterArrayWithFitness params, int ct, double temperature, double fitnessRange) {
        double d;
        ParameterArrayWithFitness curParams = params;
        double r = (double)8 * temperature / ((double)(SimulatedAnnealingStrategy$.com$barrybecker4$optimization$strategy$SimulatedAnnealingStrategy$$$N + ct) * this.tempMax);
        ParameterArray newParams = params.pa().getRandomNeighbor(r);
        double tempRad = r;
        for (int i = 0; this.cache.contains((Object)newParams) && i < 10; ++i) {
            newParams = curParams.pa().getRandomNeighbor(tempRad);
            tempRad *= 1.05;
        }
        double dist = curParams.pa().distance(newParams);
        double newFitness = 0.0;
        if (this.optimizee.evaluateByComparison()) {
            d = this.optimizee.compareFitness(newParams, curParams.pa());
        } else {
            newFitness = this.optimizee.evaluateFitness(newParams);
            d = newFitness - curParams.fitness();
        }
        double deltaFitness = d;
        double probability = Math.pow(Math.E, this.tempMax * -deltaFitness / (fitnessRange * temperature));
        boolean useWorseSolution = this.rnd.nextDouble() < probability;
        ParameterArrayWithFitness newParamsWithFitness = deltaFitness < 0.0 || useWorseSolution ? ParameterArrayWithFitness$.MODULE$.apply(newParams, newFitness) : curParams;
        this.log(ct, newParamsWithFitness, r, dist, FormatUtil$.MODULE$.formatNumber(temperature));
        return newParamsWithFitness;
    }
}

