/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.strategy.gradient;

import com.barrybecker4.optimization.optimizee.Optimizee;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness$;
import com.barrybecker4.optimization.strategy.gradient.DiscreteImprovementFinder$;
import com.barrybecker4.optimization.strategy.gradient.Improvement;
import com.barrybecker4.optimization.strategy.gradient.Improvement$;
import com.barrybecker4.optimization.strategy.gradient.ImprovementFinder;
import com.barrybecker4.optimization.strategy.gradient.ImprovementFinder$;
import scala.Predef$;
import scala.collection.mutable.Set;

public class DiscreteImprovementFinder
implements ImprovementFinder {
    private ParameterArrayWithFitness startingParams;

    public DiscreteImprovementFinder(ParameterArrayWithFitness startingParams) {
        this.startingParams = startingParams;
    }

    public ParameterArrayWithFitness startingParams() {
        return this.startingParams;
    }

    public void startingParams_$eq(ParameterArrayWithFitness x$1) {
        this.startingParams = x$1;
    }

    @Override
    public Improvement findIncrementalImprovement(Optimizee optimizee, Improvement lastImprovement, Set<ParameterArray> cache) {
        int numTries = 0;
        double fitnessDelta = 1.0;
        double jumpSize = 0.0;
        ParameterArrayWithFitness currentParams = null;
        if (lastImprovement == null) {
            currentParams = this.startingParams();
            jumpSize = ImprovementFinder$.MODULE$.INITIAL_JUMP_SIZE();
        }
        if (lastImprovement != null) {
            currentParams = lastImprovement.parameters();
            jumpSize = lastImprovement.jumpSize() * DiscreteImprovementFinder$.com$barrybecker4$optimization$strategy$gradient$DiscreteImprovementFinder$$$JUMP_SIZE_DECREASE;
        }
        Improvement improvement = Improvement$.MODULE$.apply(currentParams, 0.0, jumpSize, Improvement$.MODULE$.$lessinit$greater$default$4());
        while (fitnessDelta >= 0.0 && numTries < DiscreteImprovementFinder$.com$barrybecker4$optimization$strategy$gradient$DiscreteImprovementFinder$$$MAX_TRIES) {
            ParameterArray nbrParam = currentParams.pa().getRandomNeighbor(jumpSize);
            fitnessDelta = 0.0;
            if (!cache.contains((Object)nbrParam)) {
                ParameterArrayWithFitness nbr;
                ParameterArrayWithFitness parameterArrayWithFitness;
                cache.$plus$eq((Object)nbrParam);
                if (optimizee.evaluateByComparison()) {
                    fitnessDelta = optimizee.compareFitness(nbrParam, currentParams.pa());
                    parameterArrayWithFitness = ParameterArrayWithFitness$.MODULE$.apply(nbrParam, currentParams.fitness() + fitnessDelta);
                } else {
                    double fitness = optimizee.evaluateFitness(nbrParam);
                    fitnessDelta = fitness - currentParams.fitness();
                    parameterArrayWithFitness = nbr = ParameterArrayWithFitness$.MODULE$.apply(nbrParam, fitness);
                }
                if (fitnessDelta < 0.0) {
                    improvement = Improvement$.MODULE$.apply(nbr, fitnessDelta, jumpSize, Improvement$.MODULE$.$lessinit$greater$default$4());
                }
            }
            ++numTries;
            jumpSize *= DiscreteImprovementFinder$.com$barrybecker4$optimization$strategy$gradient$DiscreteImprovementFinder$$$JUMP_SIZE_INCREASE;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("incremental improvement = ").append(improvement).append(" numTries=").append(numTries).toString());
        return improvement;
    }
}

