/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.strategy.gradient;

import com.barrybecker4.optimization.optimizee.Optimizee;
import com.barrybecker4.optimization.parameter.NumericParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness$;
import com.barrybecker4.optimization.strategy.gradient.ImprovementIteration;
import com.barrybecker4.optimization.strategy.gradient.ImprovementStep$;
import scala.Predef$;
import scala.collection.mutable.Set;

public class ImprovementStep {
    private Optimizee optimizee;
    private ImprovementIteration iter;
    private double gradLength;
    private Set cache;
    private double jumpSize;
    private double oldFitness;
    private double improvement;
    private boolean improved;

    public static double JUMP_SIZE_DEC_FACTOR() {
        return ImprovementStep$.MODULE$.JUMP_SIZE_DEC_FACTOR();
    }

    public static double JUMP_SIZE_INC_FACTOR() {
        return ImprovementStep$.MODULE$.JUMP_SIZE_INC_FACTOR();
    }

    public ImprovementStep(Optimizee optimizee, ImprovementIteration iter, double gradLength, Set<ParameterArray> cache, double jumpSize, double oldFitness) {
        this.optimizee = optimizee;
        this.iter = iter;
        this.gradLength = gradLength;
        this.cache = cache;
        this.jumpSize = jumpSize;
        this.oldFitness = oldFitness;
        this.improvement = 0.0;
        this.improved = false;
    }

    public Optimizee optimizee() {
        return this.optimizee;
    }

    public void optimizee_$eq(Optimizee x$1) {
        this.optimizee = x$1;
    }

    public ImprovementIteration iter() {
        return this.iter;
    }

    public void iter_$eq(ImprovementIteration x$1) {
        this.iter = x$1;
    }

    public double gradLength() {
        return this.gradLength;
    }

    public void gradLength_$eq(double x$1) {
        this.gradLength = x$1;
    }

    public Set<ParameterArray> cache() {
        return this.cache;
    }

    public void cache_$eq(Set<ParameterArray> x$1) {
        this.cache = x$1;
    }

    public double jumpSize() {
        return this.jumpSize;
    }

    public void jumpSize_$eq(double x$1) {
        this.jumpSize = x$1;
    }

    public double oldFitness() {
        return this.oldFitness;
    }

    public void oldFitness_$eq(double x$1) {
        this.oldFitness = x$1;
    }

    public double getImprovement() {
        return this.improvement;
    }

    /*
     * WARNING - void declaration
     */
    public ParameterArrayWithFitness findNextParams(ParameterArrayWithFitness params) {
        void var3_3;
        int maxTries = 100;
        ParameterArrayWithFitness currentParams = this.findNextCandidateParams(params);
        for (int numTries = 1; !this.improved && this.jumpSize() > ImprovementStep$.MODULE$.JUMP_SIZE_EPS() && numTries < maxTries; ++numTries) {
            currentParams = this.findNextCandidateParams(currentParams);
        }
        return var3_3;
    }

    private ParameterArrayWithFitness findNextCandidateParams(ParameterArrayWithFitness params) {
        NumericParameterArray currentParams = (NumericParameterArray)params.pa();
        ParameterArrayWithFitness oldParams = params;
        this.iter().updateGradient(this.jumpSize(), this.gradLength());
        currentParams = currentParams.add(this.iter().gradient());
        double gaussRadius = 0.01;
        boolean sameParams = false;
        while (this.cache().contains((Object)currentParams)) {
            sameParams = true;
            currentParams = currentParams.getRandomNeighbor(gaussRadius);
            gaussRadius *= ImprovementStep$.com$barrybecker4$optimization$strategy$gradient$ImprovementStep$$$RADIUS_EXPANDER;
        }
        this.cache().$plus$eq((Object)currentParams);
        ParameterArrayWithFitness newParams = null;
        if (this.optimizee().evaluateByComparison()) {
            double fitness = this.optimizee().compareFitness(currentParams, oldParams.pa());
            newParams = ParameterArrayWithFitness$.MODULE$.apply(currentParams, fitness);
            if (fitness > 0.0) {
                this.improved = false;
            }
            this.improvement = fitness;
        } else {
            double fitness = this.optimizee().evaluateFitness(currentParams);
            newParams = ParameterArrayWithFitness$.MODULE$.apply(currentParams, fitness);
            if (fitness >= this.oldFitness()) {
                this.improved = false;
            }
            this.improvement = fitness - this.oldFitness();
        }
        boolean bl = this.improved = this.improvement < 0.0;
        if (!this.improved) {
            newParams = oldParams;
            if (!sameParams) {
                Predef$.MODULE$.println((Object)"--Warning: the new params are worse, so reduce the step size and try again");
                Predef$.MODULE$.println((Object)new StringBuilder(11).append("  jumpSize=").append(this.jumpSize()).toString());
                this.jumpSize_$eq(this.jumpSize() * ImprovementStep$.MODULE$.JUMP_SIZE_DEC_FACTOR());
            }
        }
        return newParams;
    }
}

