/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.strategy.gradient;

import com.barrybecker4.math.linear.Vector;
import com.barrybecker4.optimization.optimizee.Optimizee;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.strategy.gradient.Improvement;
import com.barrybecker4.optimization.strategy.gradient.Improvement$;
import com.barrybecker4.optimization.strategy.gradient.ImprovementFinder;
import com.barrybecker4.optimization.strategy.gradient.ImprovementFinder$;
import com.barrybecker4.optimization.strategy.gradient.ImprovementIteration;
import com.barrybecker4.optimization.strategy.gradient.ImprovementStep;
import com.barrybecker4.optimization.strategy.gradient.ImprovementStep$;
import com.barrybecker4.optimization.strategy.gradient.NumericImprovementFinder$;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.mutable.Set;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class NumericImprovementFinder
implements ImprovementFinder {
    private final ParameterArrayWithFitness startingParams;

    public static double MAX_DOT_PRODUCT() {
        return NumericImprovementFinder$.MODULE$.MAX_DOT_PRODUCT();
    }

    public static double MIN_DOT_PRODUCT() {
        return NumericImprovementFinder$.MODULE$.MIN_DOT_PRODUCT();
    }

    public NumericImprovementFinder(ParameterArrayWithFitness startingParams) {
        this.startingParams = startingParams;
    }

    public ParameterArrayWithFitness startingParams() {
        return this.startingParams;
    }

    @Override
    public Improvement findIncrementalImprovement(Optimizee optimizee, Improvement lastImprovement, Set<ParameterArray> cache) {
        ParameterArrayWithFitness currentParams = null;
        Vector oldGradient = null;
        double jumpSize = 0.0;
        if (lastImprovement == null) {
            currentParams = this.startingParams();
            jumpSize = ImprovementFinder$.MODULE$.INITIAL_JUMP_SIZE();
        }
        if (lastImprovement != null) {
            currentParams = lastImprovement.parameters();
            oldGradient = (Vector)lastImprovement.gradient().get();
            jumpSize = lastImprovement.jumpSize();
        }
        double oldFitness = currentParams.fitness();
        ImprovementIteration iter = new ImprovementIteration(currentParams, oldGradient);
        DoubleRef sumOfSqs = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), currentParams.pa().size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double d;
            sumOfSqs$1.elem = d = sumOfSqs$1.elem + iter.incSumOfSqs(i, optimizee);
        });
        double gradLength = Math.sqrt(sumOfSqs.elem);
        ImprovementStep step = new ImprovementStep(optimizee, iter, gradLength, cache, jumpSize, oldFitness);
        ParameterArrayWithFitness newParams = step.findNextParams(currentParams);
        double newJumpSize = step.jumpSize();
        double improvement = step.getImprovement();
        double dotProduct = iter.gradient().normalizedDot(iter.oldGradient());
        newJumpSize = this.findNewJumpSize(newJumpSize, dotProduct);
        iter.oldGradient_$eq(iter.gradient());
        return Improvement$.MODULE$.apply(newParams, improvement, newJumpSize, (Option<Vector>)Some$.MODULE$.apply((Object)iter.gradient()));
    }

    private double findNewJumpSize(double jumpSize, double dotProduct) {
        double newJumpSize = jumpSize;
        if (dotProduct > NumericImprovementFinder$.MODULE$.MAX_DOT_PRODUCT()) {
            newJumpSize *= ImprovementStep$.MODULE$.JUMP_SIZE_INC_FACTOR();
        } else if (dotProduct < NumericImprovementFinder$.MODULE$.MIN_DOT_PRODUCT()) {
            newJumpSize *= ImprovementStep$.MODULE$.JUMP_SIZE_DEC_FACTOR();
        }
        return newJumpSize;
    }
}

