/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.viewer;

import com.barrybecker4.optimization.Optimizer;
import com.barrybecker4.optimization.optimizee.optimizees.OptimizeeProblem;
import com.barrybecker4.optimization.parameter.ParameterArray;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.strategy.OptimizationStrategyType;
import com.barrybecker4.optimization.viewer.OptimizationViewable;
import com.barrybecker4.optimization.viewer.OptimizerEvalPanel$;
import com.barrybecker4.optimization.viewer.PointsListRenderer;
import com.barrybecker4.optimization.viewer.model.PointsList;
import com.barrybecker4.optimization.viewer.projectors.SimpleProjector;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.vecmath.Point2d;
import scala.Option;
import scala.Predef$;
import scala.Some$;

public class OptimizerEvalPanel
extends JPanel
implements OptimizationViewable,
MouseListener,
MouseMotionListener {
    private final PointsListRenderer renderer = new PointsListRenderer();
    private final SimpleProjector projector = new SimpleProjector();
    private PointsList pointsList;
    private Point dragStartPosition;

    public static Dimension SIZE() {
        return OptimizerEvalPanel$.MODULE$.SIZE();
    }

    public OptimizerEvalPanel() {
        this.setPreferredSize(OptimizerEvalPanel$.MODULE$.SIZE());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void doTest(OptimizationStrategyType optType, Optimizer optimizer, Point2d solutionPosition, ParameterArray initialGuess, double fitnessRange) {
        this.pointsList = new PointsList(solutionPosition, OptimizerEvalPanel$.com$barrybecker4$optimization$viewer$OptimizerEvalPanel$$$EDGE_SIZE, this.projector);
        ParameterArrayWithFitness solution = null;
        try {
            solution = optimizer.doOptimization(optType, initialGuess, fitnessRange, optimizer.doOptimization$default$4());
        }
        catch (AbstractMethodError e) {
            e.printStackTrace();
        }
        this.repaint();
        Predef$.MODULE$.println((Object)"\n************************************************************************");
        Predef$.MODULE$.println((Object)new StringBuilder(59).append("The solution to the (").append(optimizer.optimizee().getName()).append(") Polynomial Test Problem using ").append(optType).append(" is :\n").append(solution).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(20).append("Which evaluates to: ").append(solution.fitness()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(42).append("We expected to get exactly p1 = ").append(solutionPosition.x).append(" and p2 = ").append(solutionPosition.y).toString());
    }

    @Override
    public void optimizerChanged(ParameterArrayWithFitness params) {
        this.pointsList.addPoint(params);
    }

    @Override
    public void showOptimization(OptimizationStrategyType strategy, OptimizeeProblem testProblem, String logFile) {
        ParameterArrayWithFitness params = testProblem.getExactSolution();
        Point2d solutionPosition = this.projector.project(params.pa());
        Optimizer optimizer = new Optimizer(testProblem, (Option<String>)Some$.MODULE$.apply((Object)logFile));
        optimizer.setListener(this);
        this.doTest(strategy, optimizer, solutionPosition, testProblem.getInitialGuess(), testProblem.getFitnessRange());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponents(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        g2.setColor(OptimizerEvalPanel$.com$barrybecker4$optimization$viewer$OptimizerEvalPanel$$$BG_COLOR);
        g2.fillRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
        this.renderer.render(this.pointsList, g2);
    }

    @Override
    public void pan(Point2d offset) {
        this.pointsList.pan(offset);
        this.repaint();
    }

    @Override
    public void zoomIn() {
        this.pointsList.zoomIn();
        this.repaint();
    }

    @Override
    public void zoomOut() {
        this.pointsList.zoomOut();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.doPan(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragStartPosition = e.getPoint();
        Predef$.MODULE$.println((Object)new StringBuilder(17).append("mouse pressed at ").append(this.dragStartPosition).toString());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.doPan(e.getPoint());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void doPan(Point currentPos) {
        Point point = this.dragStartPosition;
        Point point2 = currentPos;
        if (point == null ? point2 != null : !((Object)point).equals(point2)) {
            double xOffset = (this.dragStartPosition.getX() - currentPos.getX()) / (double)this.getWidth();
            double yOffset = (this.dragStartPosition.getY() - currentPos.getY()) / (double)this.getHeight();
            Point2d offset = new Point2d(xOffset, yOffset);
            this.pointsList.pan(offset);
            this.repaint();
        }
        this.dragStartPosition = currentPos;
    }
}

