/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.viewer;

import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.viewer.PointsListRenderer$;
import com.barrybecker4.optimization.viewer.model.PointsList;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.vecmath.Point2d;
import scala.Function1;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class PointsListRenderer {
    public void render(PointsList points, Graphics2D g2) {
        if (points.getSolutionPosition() != null) {
            this.drawSolution(g2, points.getSolutionPosition());
        }
        int numPoints = points.size();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), numPoints).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.drawVector(g2, points.getScaledPoint(i - 1), points.getScaledPoint(i), points.getRawPoint(i), points.getParamArrayForPoint(i), i == numPoints - 1));
    }

    private void drawVector(Graphics2D g2, Point lastPoint, Point currentPoint, Point2d rawPoint, ParameterArrayWithFitness params, boolean isLast) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$LINE_STROKE);
        g2.setColor(PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$VECTOR_COLOR);
        g2.drawLine(currentPoint.x, currentPoint.y, lastPoint.x, lastPoint.y);
        g2.setColor(PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$cmap.getColorForValue(params.fitness()));
        this.fillOval(currentPoint, 3 * PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_DIAMETER, g2);
        g2.setStroke(PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_STROKE);
        g2.setColor(isLast ? PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$FINAL_POINT_COLOR : PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_COLOR);
        this.drawOval(currentPoint, PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_DIAMETER, g2);
        g2.setColor(PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$TEXT_COLOR);
        String label = new StringBuilder(2).append("(").append(params.pa().toCSVString()).append(")").toString();
        g2.drawString(label, currentPoint.x - 10 - 5 * label.length(), currentPoint.y + 12);
    }

    private void drawSolution(Graphics2D g2, Point position) {
        g2.setColor(PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$SOLUTION_COLOR);
        g2.setStroke(PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_STROKE);
        this.drawOval(position, PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_DIAMETER - 2, g2);
        this.drawOval(position, PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_DIAMETER, g2);
        this.drawOval(position, PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_DIAMETER + 3, g2);
        this.drawOval(position, PointsListRenderer$.com$barrybecker4$optimization$viewer$PointsListRenderer$$$POINT_DIAMETER + 10, g2);
    }

    private void drawOval(Point position, int rad, Graphics2D g2) {
        g2.drawOval((int)((double)position.x - (double)rad / 2.0), (int)((double)position.y - (double)rad / 2.0), rad, rad);
    }

    private void fillOval(Point position, int rad, Graphics2D g2) {
        g2.fillOval((int)((double)position.x - (double)rad / 2.0), (int)((double)position.y - (double)rad / 2.0), rad, rad);
    }
}

