/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.optimization.viewer.model;

import com.barrybecker4.math.Range;
import com.barrybecker4.math.Range$;
import com.barrybecker4.optimization.parameter.ParameterArrayWithFitness;
import com.barrybecker4.optimization.viewer.NavigationListener;
import com.barrybecker4.optimization.viewer.model.PointsList$;
import com.barrybecker4.optimization.viewer.projectors.Projector;
import java.awt.Point;
import javax.vecmath.Point2d;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.ScalaRunTime$;

public class PointsList
implements NavigationListener {
    private Point2d rawSolutionPosition;
    private int edgeSize;
    private Projector projector;
    private ArrayBuffer<Point2d> rawPoints;
    private ArrayBuffer<ParameterArrayWithFitness> paramArrays;
    private Range rangeX;
    private Range rangeY;

    public PointsList(Point2d rawSolutionPosition, int edgeSize, Projector projector) {
        this.rawSolutionPosition = rawSolutionPosition;
        this.edgeSize = edgeSize;
        this.projector = projector;
        this.rawPoints = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Point2d[0]));
        this.paramArrays = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ParameterArrayWithFitness[0]));
    }

    public Point2d rawSolutionPosition() {
        return this.rawSolutionPosition;
    }

    public void rawSolutionPosition_$eq(Point2d x$1) {
        this.rawSolutionPosition = x$1;
    }

    public int edgeSize() {
        return this.edgeSize;
    }

    public void edgeSize_$eq(int x$1) {
        this.edgeSize = x$1;
    }

    public Projector projector() {
        return this.projector;
    }

    public void projector_$eq(Projector x$1) {
        this.projector = x$1;
    }

    public Point getSolutionPosition() {
        return new Point(this.getScaledXValue(this.rawSolutionPosition().x), this.getScaledYValue(this.rawSolutionPosition().y));
    }

    public Point2d getRawPoint(int i) {
        return (Point2d)this.rawPoints.apply(i);
    }

    public ParameterArrayWithFitness getParamArrayForPoint(int i) {
        return (ParameterArrayWithFitness)this.paramArrays.apply(i);
    }

    public Point getScaledPoint(int i) {
        Point2d pt = (Point2d)this.rawPoints.apply(i);
        return new Point(this.getScaledXValue(pt.x), this.getScaledYValue(pt.y));
    }

    public int size() {
        return this.rawPoints.size();
    }

    public void addPoint(ParameterArrayWithFitness params) {
        if (this.rangeX == null) {
            this.rangeX = this.projector().getXRange(params.pa());
            this.rangeY = this.projector().getYRange(params.pa());
        }
        this.rawPoints.$plus$eq((Object)this.projector().project(params.pa()));
        this.paramArrays.$plus$eq((Object)params);
    }

    @Override
    public void pan(Point2d offset) {
        this.adjustXRange(offset.x * this.rangeX.getExtent());
        this.adjustYRange(offset.y * this.rangeY.getExtent());
    }

    private void adjustXRange(double xOffset) {
        this.rangeX = Range$.MODULE$.apply(this.rangeX.min() + xOffset, this.rangeX.max() + xOffset);
    }

    private void adjustYRange(double yOffset) {
        this.rangeY = Range$.MODULE$.apply(this.rangeY.min() + yOffset, this.rangeY.max() + yOffset);
    }

    @Override
    public void zoomIn() {
        double xOffset = 0.5 * PointsList$.com$barrybecker4$optimization$viewer$model$PointsList$$$ZOOM_IN_INCREMENT * this.rangeX.getExtent();
        double yOffset = 0.5 * PointsList$.com$barrybecker4$optimization$viewer$model$PointsList$$$ZOOM_IN_INCREMENT * this.rangeY.getExtent();
        this.adjustRanges(xOffset, yOffset);
    }

    @Override
    public void zoomOut() {
        double xOffset = -0.5 * PointsList$.com$barrybecker4$optimization$viewer$model$PointsList$$$ZOOM_OUT_INCREMENT * this.rangeX.getExtent();
        double yOffset = -0.5 * PointsList$.com$barrybecker4$optimization$viewer$model$PointsList$$$ZOOM_OUT_INCREMENT * this.rangeY.getExtent();
        this.adjustRanges(xOffset, yOffset);
    }

    private void adjustRanges(double xOffset, double yOffset) {
        this.rangeX = Range$.MODULE$.apply(this.rangeX.min() + xOffset, this.rangeX.max() - xOffset);
        this.rangeY = Range$.MODULE$.apply(this.rangeY.min() + yOffset, this.rangeY.max() - yOffset);
    }

    private int getScaledXValue(double value) {
        if (this.rangeX == null) {
            return 0;
        }
        return (int)((double)this.edgeSize() * (value - this.rangeX.min()) / this.rangeX.getExtent());
    }

    private int getScaledYValue(double value) {
        if (this.rangeY == null) {
            return 0;
        }
        return (int)((double)this.edgeSize() * (value - this.rangeY.min()) / this.rangeY.getExtent());
    }
}

