/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.ca.dj.jigo.sgf;

import com.barrybecker4.ca.dj.jigo.sgf.SGFException;
import com.barrybecker4.ca.dj.jigo.sgf.SGFGame;
import com.barrybecker4.ca.dj.jigo.sgf.SGFLeaf;
import com.barrybecker4.ca.dj.jigo.sgf.SGFTree;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.AddBlackToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.AddWhiteToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.ArrowToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.BadMoveToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.BlackMoveToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.BlackNameToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.BlackRankToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.BlackSpeciesToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.BlackStonesLeftToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.BlackTimeToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.CircleToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.CommentToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.DateToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.DimToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.DoubtfulMoveToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.EvenPositionToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.EventToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.FigureToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.FileFormatToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.GameCommentToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.GameIDToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.GameNameToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.GameTypeToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.GoodBlackMoveToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.GoodWhiteMoveToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.InfoToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.InterestingMoveToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.KoToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.KomiToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.LabelToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.LineToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.MoveNumberToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.NodeNameToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.PlaceToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.PrintModeToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.ResultToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.RoundToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.RuleSetToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.SGFToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.SelectedListToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.SizeToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.SourceToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.SquareToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.SystemToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.TesujiToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.TextToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.TimeLimitToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.UnclearPositionToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.UserToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.ViewToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.WhiteMoveToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.WhiteNameToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.WhiteRankToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.WhiteSpeciesToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.WhiteStonesLeftToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.WhiteTimeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class SGFLoader {
    private static final String INVALID_SGF_FILE = "Invalid SGF File.";
    private static List<SGFToken> myGameInfoTokens = new ArrayList<SGFToken>(10);

    public synchronized SGFGame load(InputStream is) throws IOException, SGFException {
        StreamTokenizer st = new StreamTokenizer(new BufferedReader(new InputStreamReader(is)));
        SGFLoader.resetTokenizer(st);
        SGFGame sgfGame = this.readGame(st);
        is.close();
        return sgfGame;
    }

    private SGFGame readGame(StreamTokenizer st) throws IOException, SGFException {
        myGameInfoTokens.clear();
        SGFTree rootTree = this.readTree(st);
        SGFGame sgfGame = new SGFGame(rootTree);
        for (SGFToken token : myGameInfoTokens) {
            sgfGame.addInfoToken((InfoToken)((Object)token));
        }
        return sgfGame;
    }

    private SGFTree readTree(StreamTokenizer st) throws IOException, SGFException {
        int token;
        SGFTree tree = new SGFTree();
        block5: while ((token = st.nextToken()) != -1) {
            switch (token) {
                case 59: {
                    tree.addLeaf(this.readLeaf(st));
                    continue block5;
                }
                case 40: {
                    tree.addTree(this.readTree(st));
                    continue block5;
                }
                case 41: {
                    return tree;
                }
            }
            throw new SGFException(INVALID_SGF_FILE);
        }
        return tree;
    }

    private SGFLeaf readLeaf(StreamTokenizer st) throws IOException, SGFException {
        int token;
        SGFLeaf leaf = null;
        while ((token = st.nextToken()) != -1 && token != 59 && token != 40 && token != 41) {
            SGFToken sgfToken;
            if (token != -3 || (sgfToken = this.readToken(st)) == null) continue;
            if (sgfToken instanceof InfoToken) {
                myGameInfoTokens.add(sgfToken);
                continue;
            }
            if (leaf == null) {
                leaf = new SGFLeaf(sgfToken);
                continue;
            }
            leaf.addToken(sgfToken);
        }
        st.pushBack();
        return leaf;
    }

    protected SGFToken readToken(StreamTokenizer st) throws IOException, SGFException {
        String tokenName = st.sval.toUpperCase();
        SGFToken token = tokenName.equals("B") || tokenName.equals("BLACK") ? new BlackMoveToken() : (tokenName.equals("W") || tokenName.equals("WHITE") ? new WhiteMoveToken() : (tokenName.equals("C") || tokenName.equals("COMMENT") ? new CommentToken() : (tokenName.equals("N") || tokenName.equals("NAME") ? new NodeNameToken() : (tokenName.equals("FG") ? new FigureToken() : (tokenName.equals("AR") ? new ArrowToken() : (tokenName.equals("CR") ? new CircleToken() : (tokenName.equals("SQ") ? new SquareToken() : (tokenName.equals("LB") ? new LabelToken() : (tokenName.equals("MN") ? new MoveNumberToken() : (tokenName.equals("LN") ? new LineToken() : (tokenName.equals("DD") ? new DimToken() : (tokenName.equals("SL") ? new SelectedListToken() : (tokenName.equals("VW") ? new ViewToken() : (tokenName.equals("AB") || tokenName.equals("ADDBLACK") ? new AddBlackToken() : (tokenName.equals("AW") || tokenName.equals("ADDWHITE") ? new AddWhiteToken() : (tokenName.equals("TE") ? new TesujiToken() : (tokenName.equals("BM") ? new BadMoveToken() : (tokenName.equals("GB") ? new GoodBlackMoveToken() : (tokenName.equals("GW") ? new GoodWhiteMoveToken() : (tokenName.equals("DM") ? new EvenPositionToken() : (tokenName.equals("UC") ? new UnclearPositionToken() : (tokenName.equals("IT") ? new InterestingMoveToken() : (tokenName.equals("DO") ? new DoubtfulMoveToken() : (tokenName.equals("KO") ? new KoToken() : (tokenName.equals("FF") ? new FileFormatToken() : (tokenName.equals("GM") || tokenName.equals("GAME") ? new GameTypeToken() : (tokenName.equals("SZ") || tokenName.equals("SIZE") ? new SizeToken() : (tokenName.equals("KM") || tokenName.equals("KOMI") ? new KomiToken() : (tokenName.equals("PW") || tokenName.equals("PLAYERWHITE") ? new WhiteNameToken() : (tokenName.equals("PB") || tokenName.equals("PLAYERBLACK") ? new BlackNameToken() : (tokenName.equals("WR") || tokenName.equals("WHITERANK") ? new WhiteRankToken() : (tokenName.equals("BR") || tokenName.equals("WHITERANK") ? new BlackRankToken() : (tokenName.equals("DT") || tokenName.equals("DATE") ? new DateToken() : (tokenName.equals("RE") || tokenName.equals("RESULT") ? new ResultToken() : (tokenName.equals("TM") || tokenName.equals("TIME") ? new TimeLimitToken() : (tokenName.equals("BL") ? new BlackTimeToken() : (tokenName.equals("WL") ? new WhiteTimeToken() : (tokenName.equals("OB") ? new BlackStonesLeftToken() : (tokenName.equals("OW") ? new WhiteStonesLeftToken() : (tokenName.equals("PM") ? new PrintModeToken() : (tokenName.equals("SY") ? new SystemToken() : (tokenName.equals("PC") ? new PlaceToken() : (tokenName.equals("EV") || tokenName.equals("EVENT") ? new EventToken() : (tokenName.equals("RO") || tokenName.equals("ROUND") ? new RoundToken() : (tokenName.equals("SO") || tokenName.equals("SOURCE") ? new SourceToken() : (tokenName.equals("US") ? new UserToken() : (tokenName.equals("GC") ? new GameCommentToken() : (tokenName.equals("RU") ? new RuleSetToken() : (tokenName.equals("BS") ? new BlackSpeciesToken() : (tokenName.equals("WS") ? new WhiteSpeciesToken() : (tokenName.equals("GN") || tokenName.equals("GAMENAME") ? new GameNameToken() : (tokenName.equals("ID") ? new GameIDToken() : new TextToken()))))))))))))))))))))))))))))))))))))))))))))))))))));
        token.parse(st);
        return token;
    }

    private static void resetTokenizer(StreamTokenizer st) {
        st.lowerCaseMode(false);
        st.eolIsSignificant(false);
        st.ordinaryChars(33, 126);
        st.wordChars(33, 126);
        st.ordinaryChar(59);
        st.ordinaryChar(92);
        st.ordinaryChars(91, 93);
        st.ordinaryChars(40, 41);
    }
}

