/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.ca.dj.jigo.sgf.tokens;

import com.barrybecker4.ca.dj.jigo.sgf.SGFException;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.InfoToken;
import com.barrybecker4.ca.dj.jigo.sgf.tokens.TextToken;
import java.io.IOException;
import java.io.StreamTokenizer;

public class ResultToken
extends TextToken
implements InfoToken {
    public static final int WHITE_WINS = 1;
    public static final int BLACK_WINS = 2;
    public static final int JIGO = 3;
    public static final int SUSPENDED = 4;
    public static final int BY_SCORE = 1;
    public static final int BY_RESIGNATION = 2;
    public static final int BY_TIME = 3;
    public static final int BY_FORFEIT = 4;
    public static final int BY_UNKNOWN = 5;
    public static final int BY_JIGO = 6;
    private static final int SCORE_INDEX = 2;
    private int myWinner = 4;
    private int myReason = 5;
    private float myScore = 0.0f;

    @Override
    protected boolean parseContent(StreamTokenizer st) throws IOException, SGFException {
        if (!super.parseContent(st)) {
            return false;
        }
        String text = this.getText();
        if (text.startsWith("B")) {
            this.setWinner(2);
        } else if (text.startsWith("W")) {
            this.setWinner(1);
        } else if (text.equals("0") || text.equalsIgnoreCase("DRAW") || text.equalsIgnoreCase("JIGO")) {
            this.setWinner(3);
        } else {
            this.setWinner(4);
            return true;
        }
        try {
            switch (text.charAt(2)) {
                case 'R': {
                    this.setReason(2);
                    break;
                }
                case 'T': {
                    this.setReason(3);
                    break;
                }
                case 'F': {
                    this.setReason(4);
                    break;
                }
                case '0': 
                case 'J': {
                    this.setReason(6);
                    break;
                }
                default: {
                    this.setReason(1);
                    this.setScore(Float.valueOf(text.substring(2, text.length())).floatValue());
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public int getWinner() {
        return this.myWinner;
    }

    private void setWinner(int winner) {
        this.myWinner = winner;
    }

    public int getReason() {
        return this.myReason;
    }

    private void setReason(int reason) {
        this.myReason = reason;
    }

    public float getScore() {
        return this.myScore;
    }

    private void setScore(float score) {
        this.myScore = score;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.getWinner()) {
            case 1: {
                sb.append("White by ");
                break;
            }
            case 2: {
                sb.append("Black by ");
                break;
            }
            case 3: {
                sb.append("Jigo.");
                return sb.toString();
            }
            case 4: {
                sb.append("Suspended.");
                return sb.toString();
            }
        }
        switch (this.getReason()) {
            case 1: {
                sb.append(this.getScore());
                break;
            }
            case 2: {
                sb.append("resignation");
                break;
            }
            case 3: {
                sb.append("time");
                break;
            }
            case 4: {
                sb.append("forfeit");
                break;
            }
            case 5: {
                sb.append("unknown reason");
                break;
            }
            case 6: {
                sb.append("jigo");
            }
        }
        sb.append('.');
        return sb.toString();
    }
}

