/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.stock;

import com.barrybecker4.simulation.common.ui.Simulator;
import com.barrybecker4.simulation.common.ui.SimulatorOptionsDialog;
import com.barrybecker4.simulation.stock.StockSampleOptions;
import com.barrybecker4.simulation.stock.StockSampleOptions$;
import com.barrybecker4.simulation.stock.StockSimulator;
import com.barrybecker4.ui.components.NumberInput;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\u0012%\u00015B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"11\t\u0001C\u0001I\u0011Cq!\u0013\u0001C\u0002\u0013%!\n\u0003\u0004O\u0001\u0001\u0006Ia\u0013\u0005\n\u001f\u0002\u0001\r\u00111A\u0005\nAC\u0011\u0002\u0017\u0001A\u0002\u0003\u0007I\u0011B-\t\u0013\t\u0004\u0001\u0019!A!B\u0013\t\u0006\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0003Q\u0011%!\u0007\u00011AA\u0002\u0013%Q\rC\u0005h\u0001\u0001\u0007\t\u0011)Q\u0005#\"I\u0001\u000e\u0001a\u0001\u0002\u0004%I\u0001\u0015\u0005\nS\u0002\u0001\r\u00111A\u0005\n)D\u0011\u0002\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B)\t\u00135\u0004\u0001\u0019!a\u0001\n\u0013\u0001\u0006\"\u00038\u0001\u0001\u0004\u0005\r\u0011\"\u0003p\u0011%\t\b\u00011A\u0001B\u0003&\u0011\u000bC\u0005s\u0001\u0001\u0007\t\u0019!C\u0005!\"I1\u000f\u0001a\u0001\u0002\u0004%I\u0001\u001e\u0005\nm\u0002\u0001\r\u0011!Q!\nEC\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002)\t\u0013a\u0004\u0001\u0019!a\u0001\n\u0013I\b\"C>\u0001\u0001\u0004\u0005\t\u0015)\u0003R\u0011%a\b\u00011AA\u0002\u0013%Q\u0010C\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\n\u0005=\u0001BCA\n\u0001\u0001\u0007\t\u0011)Q\u0005}\"Q\u0011Q\u0003\u0001A\u0002\u0003\u0007I\u0011B?\t\u0017\u0005]\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0004\u0005\u000b\u0003;\u0001\u0001\u0019!A!B\u0013q\bbBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003_\u0001A\u0011KA\u0019\u0011\u001d\tI\u0004\u0001C\u0005\u0003wAq!!\u0010\u0001\t\u0013\t\t\u0004C\u0004\u0002@\u0001!\t&a\u000f\u0003%M#xnY6PaRLwN\\:ES\u0006dwn\u001a\u0006\u0003K\u0019\nQa\u001d;pG.T!a\n\u0015\u0002\u0015MLW.\u001e7bi&|gN\u0003\u0002*U\u0005a!-\u0019:ss\n,7m[3si)\t1&A\u0002d_6\u001c\u0001a\u0005\u0002\u0001]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0003k&T!a\r\u0014\u0002\r\r|W.\\8o\u0013\t)\u0004G\u0001\fTS6,H.\u0019;pe>\u0003H/[8og\u0012K\u0017\r\\8h\u0003\u0019\u0001\u0018M]3oiB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0004C^$(\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u0012\u0011bQ8na>tWM\u001c;\u0002\u0013MLW.\u001e7bi>\u0014\bCA\u0018B\u0013\t\u0011\u0005GA\u0005TS6,H.\u0019;pe\u00061A(\u001b8jiz\"2!R$I!\t1\u0005!D\u0001%\u0011\u001514\u00011\u00018\u0011\u0015y4\u00011\u0001A\u0003\u001dy\u0007\u000f^5p]N,\u0012a\u0013\t\u0003\r2K!!\u0014\u0013\u0003%M#xnY6TC6\u0004H.Z(qi&|gn]\u0001\t_B$\u0018n\u001c8tA\u0005qa.^7Ti>\u001c7n\u001d$jK2$W#A)\u0011\u0005I3V\"A*\u000b\u0005Q+\u0016AC2p[B|g.\u001a8ug*\u0011\u0011\u0007K\u0005\u0003/N\u00131BT;nE\u0016\u0014\u0018J\u001c9vi\u0006\u0011b.^7Ti>\u001c7n\u001d$jK2$w\fJ3r)\tQ\u0006\r\u0005\u0002\\=6\tALC\u0001^\u0003\u0015\u00198-\u00197b\u0013\tyFL\u0001\u0003V]&$\bbB1\b\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\n\u0014a\u00048v[N#xnY6t\r&,G\u000e\u001a\u0011\u0002'9,X\u000eV5nKB+'/[8eg\u001aKW\r\u001c3\u0002/9,X\u000eV5nKB+'/[8eg\u001aKW\r\u001c3`I\u0015\fHC\u0001.g\u0011\u001d\t'\"!AA\u0002E\u000bAC\\;n)&lW\rU3sS>$7OR5fY\u0012\u0004\u0013\u0001\u00069fe\u000e,g\u000e^%oGJ,\u0017m]3GS\u0016dG-\u0001\rqKJ\u001cWM\u001c;J]\u000e\u0014X-Y:f\r&,G\u000eZ0%KF$\"AW6\t\u000f\u0005l\u0011\u0011!a\u0001#\u0006)\u0002/\u001a:dK:$\u0018J\\2sK\u0006\u001cXMR5fY\u0012\u0004\u0013\u0001\u00069fe\u000e,g\u000e\u001e#fGJ,\u0017m]3GS\u0016dG-\u0001\rqKJ\u001cWM\u001c;EK\u000e\u0014X-Y:f\r&,G\u000eZ0%KF$\"A\u00179\t\u000f\u0005\u0004\u0012\u0011!a\u0001#\u0006)\u0002/\u001a:dK:$H)Z2sK\u0006\u001cXMR5fY\u0012\u0004\u0013AE:uCJ$\u0018N\\4WC2,XMR5fY\u0012\fac\u001d;beRLgn\u001a,bYV,g)[3mI~#S-\u001d\u000b\u00035VDq!Y\n\u0002\u0002\u0003\u0007\u0011+A\nti\u0006\u0014H/\u001b8h-\u0006dW/\u001a$jK2$\u0007%\u0001\ty%\u0016\u001cx\u000e\\;uS>tg)[3mI\u0006!\u0002PU3t_2,H/[8o\r&,G\u000eZ0%KF$\"A\u0017>\t\u000f\u00054\u0012\u0011!a\u0001#\u0006\t\u0002PU3t_2,H/[8o\r&,G\u000e\u001a\u0011\u0002\u0017U\u001cX\rT8h'\u000e\fG.Z\u000b\u0002}B\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tQa]<j]\u001eT!!a\u0002\u0002\u000b)\fg/\u0019=\n\t\u0005-\u0011\u0011\u0001\u0002\n\u0015\u000eCWmY6C_b\fq\"^:f\u0019><7kY1mK~#S-\u001d\u000b\u00045\u0006E\u0001bB1\u001a\u0003\u0003\u0005\rA`\u0001\rkN,Gj\\4TG\u0006dW\rI\u0001\u0010kN,'+\u00198e_6\u001c\u0005.\u00198hK\u0006\u0019Ro]3SC:$w.\\\"iC:<Wm\u0018\u0013fcR\u0019!,a\u0007\t\u000f\u0005d\u0012\u0011!a\u0001}\u0006\u0001Ro]3SC:$w.\\\"iC:<W\rI\u0001\tO\u0016$H+\u001b;mKR\u0011\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011F\u001e\u0002\t1\fgnZ\u0005\u0005\u0003[\t9C\u0001\u0004TiJLgnZ\u0001\u0017GJ,\u0017\r^3DkN$x.\u001c)be\u0006l\u0007+\u00198fYV\u0011\u00111\u0007\t\u0004\u007f\u0006U\u0012\u0002BA\u001c\u0003\u0003\u0011aA\u0013)b]\u0016d\u0017\u0001E5oSRL\u0017\r\\5{K\u001aKW\r\u001c3t)\u0005Q\u0016\u0001F2sK\u0006$XMQ8pY\u0016\fgn\u00149uS>t7/\u0001\u0002pW\u0002")
public class StockOptionsDialog
extends SimulatorOptionsDialog {
    private final StockSampleOptions options = new StockSampleOptions();
    private NumberInput numStocksField;
    private NumberInput numTimePeriodsField;
    private NumberInput percentIncreaseField;
    private NumberInput percentDecreaseField;
    private NumberInput startingValueField;
    private NumberInput xResolutionField;
    private JCheckBox useLogScale;
    private JCheckBox useRandomChange;

    private StockSampleOptions options() {
        return this.options;
    }

    private NumberInput numStocksField() {
        return this.numStocksField;
    }

    private void numStocksField_$eq(NumberInput x$1) {
        this.numStocksField = x$1;
    }

    private NumberInput numTimePeriodsField() {
        return this.numTimePeriodsField;
    }

    private void numTimePeriodsField_$eq(NumberInput x$1) {
        this.numTimePeriodsField = x$1;
    }

    private NumberInput percentIncreaseField() {
        return this.percentIncreaseField;
    }

    private void percentIncreaseField_$eq(NumberInput x$1) {
        this.percentIncreaseField = x$1;
    }

    private NumberInput percentDecreaseField() {
        return this.percentDecreaseField;
    }

    private void percentDecreaseField_$eq(NumberInput x$1) {
        this.percentDecreaseField = x$1;
    }

    private NumberInput startingValueField() {
        return this.startingValueField;
    }

    private void startingValueField_$eq(NumberInput x$1) {
        this.startingValueField = x$1;
    }

    private NumberInput xResolutionField() {
        return this.xResolutionField;
    }

    private void xResolutionField_$eq(NumberInput x$1) {
        this.xResolutionField = x$1;
    }

    private JCheckBox useLogScale() {
        return this.useLogScale;
    }

    private void useLogScale_$eq(JCheckBox x$1) {
        this.useLogScale = x$1;
    }

    private JCheckBox useRandomChange() {
        return this.useRandomChange;
    }

    private void useRandomChange_$eq(JCheckBox x$1) {
        this.useRandomChange = x$1;
    }

    public String getTitle() {
        return "Stock Simulation Configuration";
    }

    /*
     * WARNING - void declaration
     */
    public JPanel createCustomParamPanel() {
        void var1_1;
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        this.initializeFields();
        JPanel booleanOptions = this.createBooleanOptions();
        innerPanel.add((Component)this.numStocksField());
        innerPanel.add((Component)this.numTimePeriodsField());
        innerPanel.add((Component)this.percentIncreaseField());
        innerPanel.add((Component)this.percentDecreaseField());
        innerPanel.add((Component)this.startingValueField());
        innerPanel.add((Component)this.xResolutionField());
        paramPanel.add((Component)innerPanel, "North");
        paramPanel.add((Component)booleanOptions, "Center");
        return var1_1;
    }

    private void initializeFields() {
        this.numStocksField_$eq(new NumberInput("Number of stocks in each sample (1 - 1000): ", (double)StockSampleOptions$.MODULE$.DEFAULT_NUM_STOCKS(), "The number of stocks in each trial. The average value of which will be one data point.", 1.0, 1000.0, true));
        this.numTimePeriodsField_$eq(new NumberInput("Number of time periods (1 - 1000): ", (double)StockSampleOptions$.MODULE$.DEFAULT_NUM_TIME_PERIODS(), "Number of time periods (for example months or years).", 1.0, 1000.0, true));
        this.percentIncreaseField_$eq(new NumberInput("Amount to increase each time period if heads (0 - 100): ", (double)100 * StockSampleOptions$.MODULE$.DEFAULT_PERCENT_INCREASE(), "Amount to increase after each time period if coin toss is heads.", 0.0, 100.0, true));
        this.percentDecreaseField_$eq(new NumberInput("Amount to decrease each time period if tails (0 - 100): ", (double)100 * StockSampleOptions$.MODULE$.DEFAULT_PERCENT_DECREASE(), "Amount to decrease after each time period if coin toss is tails.", 0.0, 100.0, true));
        this.startingValueField_$eq(new NumberInput("Starting stock value : ", StockSampleOptions$.MODULE$.DEFAULT_STARTING_VALUE(), "Starting value of each stock in the sample (in dollars). For simplicity, they are all the same.", 1.0, 1000000.0, false));
        this.xResolutionField_$eq(new NumberInput("Resolution (1 - 5): ", (double)StockSampleOptions$.MODULE$.DEFAULT_X_RESOLUTION(), "1 is low resolution 5 is high (meaning more bins on the x axis).", 1.0, 5.0, true));
    }

    /*
     * WARNING - void declaration
     */
    private JPanel createBooleanOptions() {
        void var1_1;
        JPanel booleanOptionsPanel = new JPanel();
        booleanOptionsPanel.setLayout(new BoxLayout(booleanOptionsPanel, 1));
        this.useLogScale_$eq(new JCheckBox("Use log scale on x axis", StockSampleOptions$.MODULE$.DEFAULT_USE_LOG_SCALE()));
        this.useLogScale().setToolTipText("If checked, the x axis will be shown on a log scale so that the histogram will be easier to interpret.");
        this.useRandomChange_$eq(new JCheckBox("Use random change", StockSampleOptions$.MODULE$.DEFAULT_USE_RANDOM_CHANGE()));
        this.useRandomChange().setToolTipText("If checked, then the amount of change at each time step will be a random amount between 0 and the percent increase or decrease.");
        booleanOptionsPanel.add(this.useLogScale());
        booleanOptionsPanel.add(this.useRandomChange());
        return var1_1;
    }

    public void ok() {
        super.ok();
        this.options().numStocks_$eq(this.numStocksField().getIntValue());
        this.options().percentDecrease_$eq((double)this.percentDecreaseField().getIntValue() / 100.0);
        this.options().percentIncrease_$eq((double)this.percentIncreaseField().getIntValue() / 100.0);
        this.options().numTimePeriods_$eq(this.numTimePeriodsField().getIntValue());
        this.options().startingValue_$eq(this.startingValueField().getValue());
        this.options().xResolution_$eq(this.xResolutionField().getIntValue());
        this.options().useLogScale_$eq(this.useLogScale().isSelected());
        this.options().useRandomChange_$eq(this.useRandomChange().isSelected());
        StockSimulator simulator = (StockSimulator)this.getSimulator();
        simulator.setSampleOptions(this.options());
    }

    public StockOptionsDialog(Component parent, Simulator simulator) {
        super(parent, simulator);
    }
}

