/*
 * Decompiled with CFR 0.152.
 */
package com.barrybecker4.simulation.stock;

import com.barrybecker4.common.app.AppContext$;
import com.barrybecker4.common.app.ILog;
import com.barrybecker4.common.format.CurrencyFormatter;
import com.barrybecker4.common.format.INumberFormatter;
import com.barrybecker4.math.function.InvertibleFunction;
import com.barrybecker4.math.function.LinearFunction;
import com.barrybecker4.math.function.LinearFunction$;
import com.barrybecker4.math.function.LogFunction;
import com.barrybecker4.simulation.common.ui.DistributionSimulator;
import com.barrybecker4.simulation.common.ui.Simulator;
import com.barrybecker4.simulation.stock.StockOptionsDialog;
import com.barrybecker4.simulation.stock.StockSampleOptions;
import com.barrybecker4.simulation.stock.StockSimulator$;
import com.barrybecker4.ui.renderers.HistogramRenderer;
import com.barrybecker4.ui.renderers.HistogramRenderer$;
import com.barrybecker4.ui.util.Log;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u001d<Q!\u0005\n\t\u0002m1Q!\b\n\t\u0002yAQ!L\u0001\u0005\u00029BqaL\u0001C\u0002\u0013%\u0001\u0007\u0003\u00045\u0003\u0001\u0006I!\r\u0005\bk\u0005\t\t\u0011\"\u00037\r\u0011i\"\u0003A\u001f\t\u000b52A\u0011\u0001$\t\u000f!3\u0001\u0019!C\u0005\u0013\"9QJ\u0002a\u0001\n\u0013q\u0005B\u0002+\u0007A\u0003&!\nC\u0003V\r\u0011\u0005a\u000bC\u0003Z\r\u0011E#\fC\u0003\\\r\u0011EC\fC\u0003a\r\u0011E\u0013\rC\u0003f\r\u0011%\u0011\rC\u0003g\r\u0011%\u0011-\u0001\bTi>\u001c7nU5nk2\fGo\u001c:\u000b\u0005M!\u0012!B:u_\u000e\\'BA\u000b\u0017\u0003)\u0019\u0018.\\;mCRLwN\u001c\u0006\u0003/a\tABY1sef\u0014WmY6feRR\u0011!G\u0001\u0004G>l7\u0001\u0001\t\u00039\u0005i\u0011A\u0005\u0002\u000f'R|7m[*j[Vd\u0017\r^8s'\r\tq$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013AA5p\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005Y\u0012a\u0003'B\u0005\u0016culV%E)\"+\u0012!\r\t\u0003AIJ!aM\u0011\u0003\u0007%sG/\u0001\u0007M\u0003\n+EjX,J\tRC\u0005%\u0001\u0007xe&$XMU3qY\u0006\u001cW\rF\u00018!\tA4(D\u0001:\u0015\tQ\u0014&\u0001\u0003mC:<\u0017B\u0001\u001f:\u0005\u0019y%M[3diN\u0011aA\u0010\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b!!^5\u000b\u0005\r#\u0012AB2p[6|g.\u0003\u0002F\u0001\n)B)[:ue&\u0014W\u000f^5p]NKW.\u001e7bi>\u0014H#A$\u0011\u0005q1\u0011\u0001B8qiN,\u0012A\u0013\t\u00039-K!\u0001\u0014\n\u0003%M#xnY6TC6\u0004H.Z(qi&|gn]\u0001\t_B$8o\u0018\u0013fcR\u0011qJ\u0015\t\u0003AAK!!U\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b'&\t\t\u00111\u0001K\u0003\rAH%M\u0001\u0006_B$8\u000fI\u0001\u0011g\u0016$8+Y7qY\u0016|\u0005\u000f^5p]N$\"aT,\t\u000ba[\u0001\u0019\u0001&\u0002%M$xnY6TC6\u0004H.Z(qi&|gn]\u0001\u000eS:LG\u000fS5ti><'/Y7\u0015\u0003=\u000b1c\u0019:fCR,w\n\u001d;j_:\u001cH)[1m_\u001e,\u0012!\u0018\t\u00039yK!a\u0018\n\u0003%M#xnY6PaRLwN\\:ES\u0006dwnZ\u0001\u0018O\u0016$\b\fU8tSRLwN\u001c+p\u0013:\u001c'/Z7f]R,\u0012A\u0019\t\u0003A\rL!\u0001Z\u0011\u0003\r\u0011{WO\u00197f\u00031\u0019'/Z1uKN\u000bW\u000e\u001d7f\u0003a\u0019\u0017\r\\2vY\u0006$XMR5oC2\u001cFo\\2l!JL7-\u001a")
public class StockSimulator
extends DistributionSimulator {
    private StockSampleOptions opts;

    private StockSampleOptions opts() {
        return this.opts;
    }

    private void opts_$eq(StockSampleOptions x$1) {
        this.opts = x$1;
    }

    public void setSampleOptions(StockSampleOptions stockSampleOptions) {
        this.opts_$eq(stockSampleOptions);
        this.initHistogram();
    }

    public void initHistogram() {
        double max = this.opts().getTheoreticalMaximum();
        double xScale = Math.pow(10.0, Math.max(0.0, Math.log10(max) - (double)this.opts().xResolution()));
        double xLogScale = 3.0 * (double)this.opts().xResolution() * (double)this.opts().xResolution();
        LogFunction xFunction = this.opts().useLogScale() ? new LogFunction(xLogScale, 10.0, true) : new LinearFunction(1.0 / xScale, LinearFunction$.MODULE$.$lessinit$greater$default$2());
        int maxX = (int)xFunction.getValue(max);
        this.data_$eq((int[])Array$.MODULE$.ofDim(maxX + 1, (ClassTag)ClassTag$.MODULE$.Int()));
        this.histogram_$eq(new HistogramRenderer(this.data(), (InvertibleFunction)xFunction, HistogramRenderer$.MODULE$.$lessinit$greater$default$3()));
        this.histogram().setXFormatter((INumberFormatter)new CurrencyFormatter());
        this.histogram().setMaxLabelWidth(StockSimulator$.MODULE$.com$barrybecker4$simulation$stock$StockSimulator$$LABEL_WIDTH());
    }

    public StockOptionsDialog createOptionsDialog() {
        return new StockOptionsDialog(this.frame(), (Simulator)this);
    }

    public double getXPositionToIncrement() {
        return this.createSample();
    }

    private double createSample() {
        DoubleRef total = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.opts().numStocks()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> total$1.elem += this.calculateFinalStockPrice());
        return total.elem / (double)this.opts().numStocks();
    }

    private double calculateFinalStockPrice() {
        DoubleRef stockPrice = DoubleRef.create((double)this.opts().startingValue());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.opts().numTimePeriods()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            double percentChange = Math.random() > 0.5 ? this.opts().percentIncrease() : -this.opts().percentDecrease();
            stockPrice$1.elem = stockPrice$1.elem * (1.0 + (this.opts().useRandomChange() ? Math.random() * percentChange : percentChange));
        });
        return stockPrice.elem;
    }

    public StockSimulator() {
        super("Stock Market Simulation");
        AppContext$.MODULE$.initialize("ENGLISH", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"com.barrybecker4.ui.message"})), (ILog)new Log());
        this.opts = new StockSampleOptions();
        this.initHistogram();
    }
}

