/*
 * Decompiled with CFR 0.152.
 */
package com.bartoszlipinski.viewpropertyobjectanimator;

import android.animation.ValueAnimator;
import android.view.View;
import com.bartoszlipinski.viewpropertyobjectanimator.ChangeUpdateListener;

class PaddingChangeListener
extends ChangeUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    private ChangeUpdateListener.IntValues mLeftPadding;
    private ChangeUpdateListener.IntValues mTopPadding;
    private ChangeUpdateListener.IntValues mRightPadding;
    private ChangeUpdateListener.IntValues mBottomPadding;

    PaddingChangeListener(View view) {
        super(view);
    }

    private int currentLeftPadding() {
        return this.hasView() ? ((View)this.mView.get()).getPaddingLeft() : 0;
    }

    private int currentTopPadding() {
        return this.hasView() ? ((View)this.mView.get()).getPaddingTop() : 0;
    }

    private int currentRightPadding() {
        return this.hasView() ? ((View)this.mView.get()).getPaddingRight() : 0;
    }

    private int currentBottomPadding() {
        return this.hasView() ? ((View)this.mView.get()).getPaddingBottom() : 0;
    }

    public void leftPadding(int padding) {
        this.mLeftPadding = new ChangeUpdateListener.IntValues(this.currentLeftPadding(), padding);
    }

    public void leftPaddingBy(int paddingBy) {
        this.mLeftPadding = new ChangeUpdateListener.IntValues(this.currentLeftPadding(), this.currentLeftPadding() + paddingBy);
    }

    public void topPadding(int padding) {
        this.mTopPadding = new ChangeUpdateListener.IntValues(this.currentTopPadding(), padding);
    }

    public void topPaddingBy(int paddingBy) {
        this.mTopPadding = new ChangeUpdateListener.IntValues(this.currentTopPadding(), this.currentTopPadding() + paddingBy);
    }

    public void bottomPadding(int padding) {
        this.mBottomPadding = new ChangeUpdateListener.IntValues(this.currentBottomPadding(), padding);
    }

    public void bottomPaddingBy(int paddingBy) {
        this.mBottomPadding = new ChangeUpdateListener.IntValues(this.currentBottomPadding(), this.currentBottomPadding() + paddingBy);
    }

    public void rightPadding(int padding) {
        this.mRightPadding = new ChangeUpdateListener.IntValues(this.currentRightPadding(), padding);
    }

    public void rightPaddingBy(int paddingBy) {
        this.mRightPadding = new ChangeUpdateListener.IntValues(this.currentRightPadding(), this.currentRightPadding() + paddingBy);
    }

    public void horizontalPadding(int padding) {
        this.leftPadding(padding);
        this.rightPadding(padding);
    }

    public void horizontalPaddingBy(int paddingBy) {
        this.leftPaddingBy(paddingBy);
        this.rightPaddingBy(paddingBy);
    }

    public void verticalPadding(int padding) {
        this.topPadding(padding);
        this.bottomPadding(padding);
    }

    public void verticalPaddingBy(int paddingBy) {
        this.topPaddingBy(paddingBy);
        this.bottomPaddingBy(paddingBy);
    }

    public void padding(int padding) {
        this.leftPadding(padding);
        this.topPadding(padding);
        this.bottomPadding(padding);
        this.rightPadding(padding);
    }

    public void paddingBy(int paddingBy) {
        this.leftPaddingBy(paddingBy);
        this.topPaddingBy(paddingBy);
        this.bottomPaddingBy(paddingBy);
        this.rightPaddingBy(paddingBy);
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        if (this.hasView()) {
            float animatedFraction = valueAnimator.getAnimatedFraction();
            int leftPadding = this.currentLeftPadding();
            int topPadding = this.currentTopPadding();
            int rightPadding = this.currentRightPadding();
            int bottomPadding = this.currentBottomPadding();
            if (this.mLeftPadding != null) {
                leftPadding = (int)this.calculateAnimatedValue(this.mLeftPadding.mFrom, this.mLeftPadding.mTo, animatedFraction);
            }
            if (this.mTopPadding != null) {
                topPadding = (int)this.calculateAnimatedValue(this.mTopPadding.mFrom, this.mTopPadding.mTo, animatedFraction);
            }
            if (this.mRightPadding != null) {
                rightPadding = (int)this.calculateAnimatedValue(this.mRightPadding.mFrom, this.mRightPadding.mTo, animatedFraction);
            }
            if (this.mBottomPadding != null) {
                bottomPadding = (int)this.calculateAnimatedValue(this.mBottomPadding.mFrom, this.mBottomPadding.mTo, animatedFraction);
            }
            ((View)this.mView.get()).setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        }
    }
}

