/*
 * Decompiled with CFR 0.152.
 */
package com.bartoszlipinski.viewpropertyobjectanimator;

import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import com.bartoszlipinski.viewpropertyobjectanimator.ChangeUpdateListener;

class MarginChangeListener
extends ChangeUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    private final ViewGroup.MarginLayoutParams mParams;
    private ChangeUpdateListener.IntValues mLeftMargin;
    private ChangeUpdateListener.IntValues mTopMargin;
    private ChangeUpdateListener.IntValues mRightMargin;
    private ChangeUpdateListener.IntValues mBottomMargin;

    MarginChangeListener(View view) {
        super(view);
        this.mParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        if (this.mParams == null) {
            throw new IllegalStateException("View does not have layout params yet.");
        }
    }

    private int currentLeftMargin() {
        return this.mParams.leftMargin;
    }

    private int currentTopMargin() {
        return this.mParams.topMargin;
    }

    private int currentRightMargin() {
        return this.mParams.rightMargin;
    }

    private int currentBottomMargin() {
        return this.mParams.bottomMargin;
    }

    public void leftMargin(int margin) {
        this.mLeftMargin = new ChangeUpdateListener.IntValues(this.currentLeftMargin(), margin);
    }

    public void leftMarginBy(int marginBy) {
        this.mLeftMargin = new ChangeUpdateListener.IntValues(this.currentLeftMargin(), this.currentLeftMargin() + marginBy);
    }

    public void topMargin(int margin) {
        this.mTopMargin = new ChangeUpdateListener.IntValues(this.currentTopMargin(), margin);
    }

    public void topMarginBy(int marginBy) {
        this.mTopMargin = new ChangeUpdateListener.IntValues(this.currentTopMargin(), this.currentLeftMargin() + marginBy);
    }

    public void bottomMargin(int margin) {
        this.mBottomMargin = new ChangeUpdateListener.IntValues(this.currentBottomMargin(), margin);
    }

    public void bottomMarginBy(int marginBy) {
        this.mBottomMargin = new ChangeUpdateListener.IntValues(this.currentBottomMargin(), this.currentLeftMargin() + marginBy);
    }

    public void rightMargin(int margin) {
        this.mRightMargin = new ChangeUpdateListener.IntValues(this.currentRightMargin(), margin);
    }

    public void rightMarginBy(int marginBy) {
        this.mRightMargin = new ChangeUpdateListener.IntValues(this.currentRightMargin(), this.currentLeftMargin() + marginBy);
    }

    public void horizontalMargin(int margin) {
        this.leftMargin(margin);
        this.rightMargin(margin);
    }

    public void horizontalMarginBy(int marginBy) {
        this.leftMarginBy(marginBy);
        this.rightMarginBy(marginBy);
    }

    public void verticalMargin(int margin) {
        this.topMargin(margin);
        this.bottomMargin(margin);
    }

    public void verticalMarginBy(int marginBy) {
        this.topMarginBy(marginBy);
        this.bottomMarginBy(marginBy);
    }

    public void margin(int margin) {
        this.leftMargin(margin);
        this.topMargin(margin);
        this.bottomMargin(margin);
        this.rightMargin(margin);
    }

    public void marginBy(int marginBy) {
        this.leftMarginBy(marginBy);
        this.topMarginBy(marginBy);
        this.bottomMarginBy(marginBy);
        this.rightMarginBy(marginBy);
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        if (this.hasView()) {
            float animatedFraction = valueAnimator.getAnimatedFraction();
            if (this.mLeftMargin != null) {
                this.mParams.leftMargin = (int)this.calculateAnimatedValue(this.mLeftMargin.mFrom, this.mLeftMargin.mTo, animatedFraction);
            }
            if (this.mTopMargin != null) {
                this.mParams.topMargin = (int)this.calculateAnimatedValue(this.mTopMargin.mFrom, this.mTopMargin.mTo, animatedFraction);
            }
            if (this.mRightMargin != null) {
                this.mParams.rightMargin = (int)this.calculateAnimatedValue(this.mRightMargin.mFrom, this.mRightMargin.mTo, animatedFraction);
            }
            if (this.mBottomMargin != null) {
                this.mParams.bottomMargin = (int)this.calculateAnimatedValue(this.mBottomMargin.mFrom, this.mBottomMargin.mTo, animatedFraction);
            }
            ((View)this.mView.get()).requestLayout();
        }
    }
}

