/*
 * Decompiled with CFR 0.152.
 */
package com.bartoszlipinski.viewpropertyobjectanimator;

import android.animation.ValueAnimator;
import android.support.percent.PercentLayoutHelper;
import android.view.View;
import android.view.ViewGroup;
import com.bartoszlipinski.viewpropertyobjectanimator.ChangeUpdateListener;

public class PercentChangeListener
extends ChangeUpdateListener
implements ValueAnimator.AnimatorUpdateListener {
    private final PercentLayoutHelper.PercentLayoutInfo mPercentLayoutInfo;
    private ChangeUpdateListener.FloatValues mWidthPercent;
    private ChangeUpdateListener.FloatValues mHeightPercent;
    private ChangeUpdateListener.FloatValues mLeftMarginPercent;
    private ChangeUpdateListener.FloatValues mTopMarginPercent;
    private ChangeUpdateListener.FloatValues mBottomMarginPercent;
    private ChangeUpdateListener.FloatValues mRightMarginPercent;

    PercentChangeListener(View view) {
        super(view);
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (params == null) {
            throw new IllegalStateException("View does not have layout params yet.");
        }
        if (!(params instanceof PercentLayoutHelper.PercentLayoutParams)) {
            throw new IllegalStateException("Animating percent parameters is available only for children of PercentRelativeLayout or PercentFrameLayout.");
        }
        this.mPercentLayoutInfo = ((PercentLayoutHelper.PercentLayoutParams)params).getPercentLayoutInfo();
    }

    private float currentWidthPercent() {
        return this.mPercentLayoutInfo.widthPercent;
    }

    private float currentHeightPercent() {
        return this.mPercentLayoutInfo.heightPercent;
    }

    private float currentLeftMarginPercent() {
        return this.mPercentLayoutInfo.leftMarginPercent;
    }

    private float currentTopMarginPercent() {
        return this.mPercentLayoutInfo.topMarginPercent;
    }

    private float currentRightMarginPercent() {
        return this.mPercentLayoutInfo.rightMarginPercent;
    }

    private float currentBottomMarginPercent() {
        return this.mPercentLayoutInfo.bottomMarginPercent;
    }

    public void widthPercent(float widthPercent) {
        this.mWidthPercent = new ChangeUpdateListener.FloatValues(this.currentWidthPercent(), widthPercent);
    }

    public void widthPercentBy(float widthPercentBy) {
        this.mWidthPercent = new ChangeUpdateListener.FloatValues(this.currentWidthPercent(), this.currentWidthPercent() + widthPercentBy);
    }

    public void heightPercent(float heightPercent) {
        this.mHeightPercent = new ChangeUpdateListener.FloatValues(this.currentHeightPercent(), heightPercent);
    }

    public void heightPercentBy(float heightPercentBy) {
        this.mHeightPercent = new ChangeUpdateListener.FloatValues(this.currentHeightPercent(), this.currentHeightPercent() + heightPercentBy);
    }

    public void sizePercent(float sizePercent) {
        this.widthPercent(sizePercent);
        this.heightPercent(sizePercent);
    }

    public void sizePercentBy(int sizePercentBy) {
        this.widthPercentBy(sizePercentBy);
        this.heightPercentBy(sizePercentBy);
    }

    public void leftMarginPercent(float marginPercent) {
        this.mLeftMarginPercent = new ChangeUpdateListener.FloatValues(this.currentLeftMarginPercent(), marginPercent);
    }

    public void leftMarginPercentBy(float marginPercentBy) {
        this.mLeftMarginPercent = new ChangeUpdateListener.FloatValues(this.currentLeftMarginPercent(), this.currentLeftMarginPercent() + marginPercentBy);
    }

    public void topMarginPercent(float marginPercent) {
        this.mTopMarginPercent = new ChangeUpdateListener.FloatValues(this.currentTopMarginPercent(), marginPercent);
    }

    public void topMarginPercentBy(float marginPercentBy) {
        this.mTopMarginPercent = new ChangeUpdateListener.FloatValues(this.currentTopMarginPercent(), this.currentTopMarginPercent() + marginPercentBy);
    }

    public void bottomMarginPercent(float marginPercent) {
        this.mBottomMarginPercent = new ChangeUpdateListener.FloatValues(this.currentBottomMarginPercent(), marginPercent);
    }

    public void bottomMarginPercentBy(float marginPercentBy) {
        this.mBottomMarginPercent = new ChangeUpdateListener.FloatValues(this.currentBottomMarginPercent(), this.currentBottomMarginPercent() + marginPercentBy);
    }

    public void rightMarginPercent(float marginPercent) {
        this.mRightMarginPercent = new ChangeUpdateListener.FloatValues(this.currentRightMarginPercent(), marginPercent);
    }

    public void rightMarginPercentBy(float marginPercentBy) {
        this.mRightMarginPercent = new ChangeUpdateListener.FloatValues(this.currentRightMarginPercent(), this.currentRightMarginPercent() + marginPercentBy);
    }

    public void horizontalMarginPercent(float marginPercent) {
        this.leftMarginPercent(marginPercent);
        this.rightMarginPercent(marginPercent);
    }

    public void horizontalMarginPercentBy(float marginPercentBy) {
        this.leftMarginPercentBy(marginPercentBy);
        this.rightMarginPercentBy(marginPercentBy);
    }

    public void verticalMarginPercent(float marginPercent) {
        this.topMarginPercent(marginPercent);
        this.bottomMarginPercent(marginPercent);
    }

    public void verticalMarginPercentBy(float marginPercentBy) {
        this.topMarginPercentBy(marginPercentBy);
        this.bottomMarginPercentBy(marginPercentBy);
    }

    public void marginPercent(float marginPercent) {
        this.leftMarginPercent(marginPercent);
        this.topMarginPercent(marginPercent);
        this.bottomMarginPercent(marginPercent);
        this.rightMarginPercent(marginPercent);
    }

    public void marginPercentBy(float marginPercentBy) {
        this.leftMarginPercentBy(marginPercentBy);
        this.topMarginPercentBy(marginPercentBy);
        this.bottomMarginPercentBy(marginPercentBy);
        this.rightMarginPercentBy(marginPercentBy);
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        if (this.hasView()) {
            float animatedFraction = valueAnimator.getAnimatedFraction();
            if (this.mWidthPercent != null) {
                this.mPercentLayoutInfo.widthPercent = this.calculateAnimatedValue(this.mWidthPercent.mFrom, this.mWidthPercent.mTo, animatedFraction);
            }
            if (this.mHeightPercent != null) {
                this.mPercentLayoutInfo.heightPercent = this.calculateAnimatedValue(this.mHeightPercent.mFrom, this.mHeightPercent.mTo, animatedFraction);
            }
            if (this.mLeftMarginPercent != null) {
                this.mPercentLayoutInfo.leftMarginPercent = this.calculateAnimatedValue(this.mLeftMarginPercent.mFrom, this.mLeftMarginPercent.mTo, animatedFraction);
            }
            if (this.mTopMarginPercent != null) {
                this.mPercentLayoutInfo.topMarginPercent = this.calculateAnimatedValue(this.mTopMarginPercent.mFrom, this.mTopMarginPercent.mTo, animatedFraction);
            }
            if (this.mRightMarginPercent != null) {
                this.mPercentLayoutInfo.rightMarginPercent = this.calculateAnimatedValue(this.mRightMarginPercent.mFrom, this.mRightMarginPercent.mTo, animatedFraction);
            }
            if (this.mBottomMarginPercent != null) {
                this.mPercentLayoutInfo.bottomMarginPercent = this.calculateAnimatedValue(this.mBottomMarginPercent.mFrom, this.mBottomMarginPercent.mTo, animatedFraction);
            }
            ((View)this.mView.get()).requestLayout();
        }
    }
}

