/*
 * Decompiled with CFR 0.152.
 */
package com.bartoszlipinski.viewpropertyobjectanimator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.os.Build;
import android.support.v4.util.ArrayMap;
import android.util.Property;
import android.view.View;
import android.view.animation.Interpolator;
import com.bartoszlipinski.viewpropertyobjectanimator.DimensionChangeListener;
import com.bartoszlipinski.viewpropertyobjectanimator.MarginChangeListener;
import com.bartoszlipinski.viewpropertyobjectanimator.PaddingChangeListener;
import com.bartoszlipinski.viewpropertyobjectanimator.PercentChangeListener;
import com.bartoszlipinski.viewpropertyobjectanimator.ScrollChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ViewPropertyObjectAnimator {
    private final WeakReference<View> mView;
    private long mDuration = -1L;
    private long mStartDelay = -1L;
    private boolean mWithLayer = false;
    private Interpolator mInterpolator;
    private List<Animator.AnimatorListener> mListeners = new ArrayList<Animator.AnimatorListener>();
    private List<ValueAnimator.AnimatorUpdateListener> mUpdateListeners = new ArrayList<ValueAnimator.AnimatorUpdateListener>();
    private List<Animator.AnimatorPauseListener> mPauseListeners = new ArrayList<Animator.AnimatorPauseListener>();
    private ArrayMap<Property<View, Float>, PropertyValuesHolder> mPropertyHoldersMap = new ArrayMap();
    private MarginChangeListener mMarginListener;
    private DimensionChangeListener mDimensionListener;
    private PaddingChangeListener mPaddingListener;
    private ScrollChangeListener mScrollListener;
    private PercentChangeListener mPercentListener;

    private ViewPropertyObjectAnimator(View view) {
        this.mView = new WeakReference<View>(view);
    }

    public static ViewPropertyObjectAnimator animate(View view) {
        return new ViewPropertyObjectAnimator(view);
    }

    private void animateProperty(Property<View, Float> property, float toValue) {
        if (this.hasView()) {
            float fromValue = ((Float)property.get(this.mView.get())).floatValue();
            this.animatePropertyBetween(property, fromValue, toValue);
        }
    }

    private void animatePropertyBy(Property<View, Float> property, float byValue) {
        if (this.hasView()) {
            float fromValue = ((Float)property.get(this.mView.get())).floatValue();
            float toValue = fromValue + byValue;
            this.animatePropertyBetween(property, fromValue, toValue);
        }
    }

    private void animatePropertyBetween(Property<View, Float> property, float fromValue, float toValue) {
        this.mPropertyHoldersMap.remove(property);
        this.mPropertyHoldersMap.put(property, (Object)PropertyValuesHolder.ofFloat(property, (float[])new float[]{fromValue, toValue}));
    }

    public ViewPropertyObjectAnimator scaleX(float scaleX) {
        this.animateProperty((Property<View, Float>)View.SCALE_X, scaleX);
        return this;
    }

    public ViewPropertyObjectAnimator scaleXBy(float scaleXBy) {
        this.animatePropertyBy((Property<View, Float>)View.SCALE_X, scaleXBy);
        return this;
    }

    public ViewPropertyObjectAnimator scaleY(float scaleY) {
        this.animateProperty((Property<View, Float>)View.SCALE_Y, scaleY);
        return this;
    }

    public ViewPropertyObjectAnimator scaleYBy(float scaleYBy) {
        this.animatePropertyBy((Property<View, Float>)View.SCALE_Y, scaleYBy);
        return this;
    }

    public ViewPropertyObjectAnimator scales(float scales) {
        this.scaleY(scales);
        this.scaleX(scales);
        return this;
    }

    public ViewPropertyObjectAnimator scalesBy(float scalesBy) {
        this.scaleYBy(scalesBy);
        this.scaleXBy(scalesBy);
        return this;
    }

    public ViewPropertyObjectAnimator translationX(float translationX) {
        this.animateProperty((Property<View, Float>)View.TRANSLATION_X, translationX);
        return this;
    }

    public ViewPropertyObjectAnimator translationXBy(float translationXBy) {
        this.animatePropertyBy((Property<View, Float>)View.TRANSLATION_X, translationXBy);
        return this;
    }

    public ViewPropertyObjectAnimator translationY(float translationY) {
        this.animateProperty((Property<View, Float>)View.TRANSLATION_Y, translationY);
        return this;
    }

    public ViewPropertyObjectAnimator translationYBy(float translationYBy) {
        this.animatePropertyBy((Property<View, Float>)View.TRANSLATION_Y, translationYBy);
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewPropertyObjectAnimator translationZ(float translationZ) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.animateProperty((Property<View, Float>)View.TRANSLATION_Z, translationZ);
        }
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewPropertyObjectAnimator translationZBy(float translationZBy) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.animatePropertyBy((Property<View, Float>)View.TRANSLATION_Z, translationZBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator alpha(float alpha) {
        this.animateProperty((Property<View, Float>)View.ALPHA, alpha);
        return this;
    }

    public ViewPropertyObjectAnimator alphaBy(float alphaBy) {
        this.animatePropertyBy((Property<View, Float>)View.ALPHA, alphaBy);
        return this;
    }

    public ViewPropertyObjectAnimator rotation(float rotation) {
        this.animateProperty((Property<View, Float>)View.ROTATION, rotation);
        return this;
    }

    public ViewPropertyObjectAnimator rotationBy(float rotationBy) {
        this.animatePropertyBy((Property<View, Float>)View.ROTATION, rotationBy);
        return this;
    }

    public ViewPropertyObjectAnimator rotationX(float rotationX) {
        this.animateProperty((Property<View, Float>)View.ROTATION_X, rotationX);
        return this;
    }

    public ViewPropertyObjectAnimator rotationXBy(float rotationXBy) {
        this.animatePropertyBy((Property<View, Float>)View.ROTATION_X, rotationXBy);
        return this;
    }

    public ViewPropertyObjectAnimator rotationY(float rotationY) {
        this.animateProperty((Property<View, Float>)View.ROTATION_Y, rotationY);
        return this;
    }

    public ViewPropertyObjectAnimator rotationYBy(float rotationYBy) {
        this.animatePropertyBy((Property<View, Float>)View.ROTATION_Y, rotationYBy);
        return this;
    }

    public ViewPropertyObjectAnimator x(float x) {
        this.animateProperty((Property<View, Float>)View.X, x);
        return this;
    }

    public ViewPropertyObjectAnimator xBy(float xBy) {
        this.animatePropertyBy((Property<View, Float>)View.X, xBy);
        return this;
    }

    public ViewPropertyObjectAnimator y(float y) {
        this.animateProperty((Property<View, Float>)View.Y, y);
        return this;
    }

    public ViewPropertyObjectAnimator yBy(float yBy) {
        this.animatePropertyBy((Property<View, Float>)View.Y, yBy);
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewPropertyObjectAnimator z(float z) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.animateProperty((Property<View, Float>)View.Z, z);
        }
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public ViewPropertyObjectAnimator zBy(float zBy) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.animatePropertyBy((Property<View, Float>)View.Z, zBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator leftMargin(int leftMargin) {
        if (this.initMarginListener()) {
            this.mMarginListener.leftMargin(leftMargin);
        }
        return this;
    }

    public ViewPropertyObjectAnimator leftMarginBy(int leftMarginBy) {
        if (this.initMarginListener()) {
            this.mMarginListener.leftMarginBy(leftMarginBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator topMargin(int topMargin) {
        if (this.initMarginListener()) {
            this.mMarginListener.topMargin(topMargin);
        }
        return this;
    }

    public ViewPropertyObjectAnimator topMarginBy(int topMarginBy) {
        if (this.initMarginListener()) {
            this.mMarginListener.topMarginBy(topMarginBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator rightMargin(int rightMargin) {
        if (this.initMarginListener()) {
            this.mMarginListener.rightMargin(rightMargin);
        }
        return this;
    }

    public ViewPropertyObjectAnimator rightMarginBy(int rightMarginBy) {
        if (this.initMarginListener()) {
            this.mMarginListener.rightMarginBy(rightMarginBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator bottomMargin(int bottomMargin) {
        if (this.initMarginListener()) {
            this.mMarginListener.bottomMargin(bottomMargin);
        }
        return this;
    }

    public ViewPropertyObjectAnimator bottomMarginBy(int bottomMarginBy) {
        if (this.initMarginListener()) {
            this.mMarginListener.bottomMarginBy(bottomMarginBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator horizontalMargin(int horizontalMargin) {
        if (this.initMarginListener()) {
            this.mMarginListener.horizontalMargin(horizontalMargin);
        }
        return this;
    }

    public ViewPropertyObjectAnimator horizontalMarginBy(int horizontalMarginBy) {
        if (this.initMarginListener()) {
            this.mMarginListener.horizontalMarginBy(horizontalMarginBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator verticalMargin(int verticalMargin) {
        if (this.initMarginListener()) {
            this.mMarginListener.verticalMargin(verticalMargin);
        }
        return this;
    }

    public ViewPropertyObjectAnimator verticalMarginBy(int verticalMarginBy) {
        if (this.initMarginListener()) {
            this.mMarginListener.verticalMarginBy(verticalMarginBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator margin(int margin) {
        if (this.initMarginListener()) {
            this.mMarginListener.margin(margin);
        }
        return this;
    }

    public ViewPropertyObjectAnimator marginBy(int marginBy) {
        if (this.initMarginListener()) {
            this.mMarginListener.marginBy(marginBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator width(int width) {
        if (this.initDimensionListener()) {
            this.mDimensionListener.width(width);
        }
        return this;
    }

    public ViewPropertyObjectAnimator widthBy(int widthBy) {
        if (this.initDimensionListener()) {
            this.mDimensionListener.widthBy(widthBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator height(int height) {
        if (this.initDimensionListener()) {
            this.mDimensionListener.height(height);
        }
        return this;
    }

    public ViewPropertyObjectAnimator heightBy(int heightBy) {
        if (this.initDimensionListener()) {
            this.mDimensionListener.heightBy(heightBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator size(int size) {
        if (this.initDimensionListener()) {
            this.mDimensionListener.size(size);
        }
        return this;
    }

    public ViewPropertyObjectAnimator sizeBy(int sizeBy) {
        if (this.initDimensionListener()) {
            this.mDimensionListener.sizeBy(sizeBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator leftPadding(int leftPadding) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.leftPadding(leftPadding);
        }
        return this;
    }

    public ViewPropertyObjectAnimator leftPaddingBy(int leftPaddingBy) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.leftPaddingBy(leftPaddingBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator topPadding(int topPadding) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.topPadding(topPadding);
        }
        return this;
    }

    public ViewPropertyObjectAnimator topPaddingBy(int topPaddingBy) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.topPaddingBy(topPaddingBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator rightPadding(int rightPadding) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.rightPadding(rightPadding);
        }
        return this;
    }

    public ViewPropertyObjectAnimator rightPaddingBy(int rightPaddingBy) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.rightPaddingBy(rightPaddingBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator bottomPadding(int bottomPadding) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.bottomPadding(bottomPadding);
        }
        return this;
    }

    public ViewPropertyObjectAnimator bottomPaddingBy(int bottomPaddingBy) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.bottomPaddingBy(bottomPaddingBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator horizontalPadding(int horizontalPadding) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.horizontalPadding(horizontalPadding);
        }
        return this;
    }

    public ViewPropertyObjectAnimator horizontalPaddingBy(int horizontalPaddingBy) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.horizontalPaddingBy(horizontalPaddingBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator verticalPadding(int verticalPadding) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.verticalPadding(verticalPadding);
        }
        return this;
    }

    public ViewPropertyObjectAnimator verticalPaddingBy(int verticalPaddingBy) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.verticalPaddingBy(verticalPaddingBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator padding(int padding) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.padding(padding);
        }
        return this;
    }

    public ViewPropertyObjectAnimator paddingBy(int paddingBy) {
        if (this.initPaddingListener()) {
            this.mPaddingListener.paddingBy(paddingBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator scrollX(int scrollX) {
        if (this.initScrollListener()) {
            this.mScrollListener.scrollX(scrollX);
        }
        return this;
    }

    public ViewPropertyObjectAnimator scrollXBy(int scrollXBy) {
        if (this.initScrollListener()) {
            this.mScrollListener.scrollXBy(scrollXBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator scrollY(int scrollY) {
        if (this.initScrollListener()) {
            this.mScrollListener.scrollY(scrollY);
        }
        return this;
    }

    public ViewPropertyObjectAnimator scrollYBy(int scrollYBy) {
        if (this.initScrollListener()) {
            this.mScrollListener.scrollYBy(scrollYBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator widthPercent(float widthPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.widthPercent(widthPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator widthPercentBy(float widthPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.widthPercentBy(widthPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator heightPercent(float heightPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.heightPercent(heightPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator heightPercentBy(float heightPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.heightPercentBy(heightPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator sizePercent(float sizePercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.sizePercent(sizePercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator sizePercentBy(float sizePercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.sizePercentBy(sizePercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator leftMarginPercent(float marginPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.leftMarginPercent(marginPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator leftMarginPercentBy(float marginPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.leftMarginPercentBy(marginPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator topMarginPercent(float marginPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.topMarginPercent(marginPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator topMarginPercentBy(float marginPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.topMarginPercentBy(marginPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator bottomMarginPercent(float marginPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.bottomMarginPercent(marginPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator bottomMarginPercentBy(float marginPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.bottomMarginPercentBy(marginPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator rightMarginPercent(float marginPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.rightMarginPercent(marginPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator rightMarginPercentBy(float marginPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.rightMarginPercentBy(marginPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator horizontalMarginPercent(float marginPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.horizontalMarginPercent(marginPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator horizontalMarginPercentBy(float marginPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.horizontalMarginPercentBy(marginPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator verticalMarginPercent(float marginPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.verticalMarginPercent(marginPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator verticalMarginPercentBy(float marginPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.verticalMarginPercentBy(marginPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator marginPercent(float marginPercent) {
        if (this.initPercentListener()) {
            this.mPercentListener.marginPercent(marginPercent);
        }
        return this;
    }

    public ViewPropertyObjectAnimator marginPercentBy(float marginPercentBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.marginPercentBy(marginPercentBy);
        }
        return this;
    }

    public ViewPropertyObjectAnimator aspectRatio(float aspectRatio) {
        if (this.initPercentListener()) {
            this.mPercentListener.aspectRatio(aspectRatio);
        }
        return this;
    }

    public ViewPropertyObjectAnimator aspectRatioBy(float aspectRatioBy) {
        if (this.initPercentListener()) {
            this.mPercentListener.aspectRatioBy(aspectRatioBy);
        }
        return this;
    }

    private boolean initMarginListener() {
        if (this.mMarginListener == null) {
            if (!this.hasView()) {
                return false;
            }
            this.mMarginListener = new MarginChangeListener((View)this.mView.get());
        }
        return true;
    }

    private boolean initDimensionListener() {
        if (this.mDimensionListener == null) {
            if (!this.hasView()) {
                return false;
            }
            this.mDimensionListener = new DimensionChangeListener((View)this.mView.get());
        }
        return true;
    }

    private boolean initPaddingListener() {
        if (this.mPaddingListener == null) {
            if (!this.hasView()) {
                return false;
            }
            this.mPaddingListener = new PaddingChangeListener((View)this.mView.get());
        }
        return true;
    }

    private boolean initScrollListener() {
        if (this.mScrollListener == null) {
            if (!this.hasView()) {
                return false;
            }
            this.mScrollListener = new ScrollChangeListener((View)this.mView.get());
        }
        return true;
    }

    private boolean initPercentListener() {
        if (this.mPercentListener == null) {
            if (!this.hasView()) {
                return false;
            }
            this.mPercentListener = new PercentChangeListener((View)this.mView.get());
        }
        return true;
    }

    public ViewPropertyObjectAnimator withLayer() {
        this.mWithLayer = true;
        return this;
    }

    public ViewPropertyObjectAnimator setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            throw new IllegalArgumentException("startDelay cannot be < 0");
        }
        this.mStartDelay = startDelay;
        return this;
    }

    public ViewPropertyObjectAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration cannot be < 0");
        }
        this.mDuration = duration;
        return this;
    }

    public ViewPropertyObjectAnimator setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    public ViewPropertyObjectAnimator addListener(Animator.AnimatorListener listener) {
        this.mListeners.add(listener);
        return this;
    }

    public ViewPropertyObjectAnimator removeListener(Animator.AnimatorListener listener) {
        this.mListeners.remove(listener);
        return this;
    }

    public ViewPropertyObjectAnimator removeAllListeners() {
        this.mListeners.clear();
        return this;
    }

    public ViewPropertyObjectAnimator addUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
        this.mUpdateListeners.add(listener);
        return this;
    }

    public ViewPropertyObjectAnimator removeUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
        this.mUpdateListeners.remove(listener);
        return this;
    }

    public ViewPropertyObjectAnimator removeAllUpdateListeners() {
        this.mUpdateListeners.clear();
        return this;
    }

    public ViewPropertyObjectAnimator addPauseListener(Animator.AnimatorPauseListener listener) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mPauseListeners.add(listener);
        }
        return this;
    }

    public ViewPropertyObjectAnimator removePauseListener(Animator.AnimatorPauseListener listener) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mPauseListeners.remove(listener);
        }
        return this;
    }

    public ViewPropertyObjectAnimator removeAllPauseListeners() {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mPauseListeners.clear();
        }
        return this;
    }

    public ViewPropertyObjectAnimator withStartAction(final Runnable runnable) {
        return this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                runnable.run();
                ViewPropertyObjectAnimator.this.removeListener((Animator.AnimatorListener)this);
            }
        });
    }

    public ViewPropertyObjectAnimator withEndAction(final Runnable runnable) {
        return this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                runnable.run();
                ViewPropertyObjectAnimator.this.removeListener((Animator.AnimatorListener)this);
            }
        });
    }

    private boolean hasView() {
        return this.mView.get() != null;
    }

    @SuppressLint(value={"NewApi"})
    public ObjectAnimator get() {
        if (this.hasView()) {
            Collection holders = this.mPropertyHoldersMap.values();
            ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder(this.mView.get(), (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
            if (this.mWithLayer) {
                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                    int mCurrentLayerType = 0;

                    public void onAnimationStart(Animator animation) {
                        if (ViewPropertyObjectAnimator.this.hasView()) {
                            View view = (View)ViewPropertyObjectAnimator.this.mView.get();
                            this.mCurrentLayerType = view.getLayerType();
                            view.setLayerType(2, null);
                            if (view.isAttachedToWindow()) {
                                view.buildLayer();
                            }
                        }
                    }

                    public void onAnimationEnd(Animator animation) {
                        if (ViewPropertyObjectAnimator.this.hasView()) {
                            ((View)ViewPropertyObjectAnimator.this.mView.get()).setLayerType(this.mCurrentLayerType, null);
                        }
                    }
                });
            }
            if (this.mStartDelay != -1L) {
                animator.setStartDelay(this.mStartDelay);
            }
            if (this.mDuration != -1L) {
                animator.setDuration(this.mDuration);
            }
            if (this.mInterpolator != null) {
                animator.setInterpolator((TimeInterpolator)this.mInterpolator);
            }
            for (Animator.AnimatorListener animatorListener : this.mListeners) {
                animator.addListener(animatorListener);
            }
            if (this.mMarginListener != null) {
                animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mMarginListener);
            }
            if (this.mDimensionListener != null) {
                animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mDimensionListener);
            }
            if (this.mPaddingListener != null) {
                animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mPaddingListener);
            }
            if (this.mScrollListener != null) {
                animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mScrollListener);
            }
            if (this.mPercentListener != null) {
                animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this.mPercentListener);
            }
            for (ValueAnimator.AnimatorUpdateListener animatorUpdateListener : this.mUpdateListeners) {
                animator.addUpdateListener(animatorUpdateListener);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                for (Animator.AnimatorPauseListener animatorPauseListener : this.mPauseListeners) {
                    animator.addPauseListener(animatorPauseListener);
                }
            }
            return animator;
        }
        return ObjectAnimator.ofFloat(null, (Property)View.ALPHA, (float[])new float[]{1.0f, 1.0f});
    }

    public void start() {
        this.get().start();
    }
}

