/*
 * Decompiled with CFR 0.152.
 */
package com.basgeekball.awesomevalidation.utility;

import android.content.res.ColorStateList;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;

public class ViewsInfo {
    private int mIndex;
    private ViewGroup mParent;
    private LinearLayout mNewContainer;
    private EditText mEditText;
    private ColorStateList mColorStateList;
    private boolean mIsOriginal = false;

    public ViewsInfo(int n, ViewGroup viewGroup, LinearLayout linearLayout, EditText editText) {
        this.mIndex = n;
        this.mParent = viewGroup;
        this.mNewContainer = linearLayout;
        this.mEditText = editText;
        this.mColorStateList = ViewCompat.getBackgroundTintList((View)editText);
    }

    public void restoreViews() {
        if (!this.mIsOriginal) {
            ViewCompat.setBackgroundTintList((View)this.mEditText, (ColorStateList)this.mColorStateList);
            this.mEditText.requestFocus();
            this.mNewContainer.removeView((View)this.mEditText);
            this.mParent.removeView((View)this.mNewContainer);
            this.mParent.addView((View)this.mEditText, this.mIndex);
            this.mIsOriginal = true;
        }
    }

    public int getIndex() {
        return this.mIndex;
    }

    public ViewGroup getParent() {
        return this.mParent;
    }

    public LinearLayout getNewContainer() {
        return this.mNewContainer;
    }

    public EditText getEditText() {
        return this.mEditText;
    }
}

