/*
 * Decompiled with CFR 0.152.
 */
package com.basgeekball.awesomevalidation.validators;

import android.support.v4.util.Pair;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;
import com.basgeekball.awesomevalidation.AwesomeValidation;
import com.basgeekball.awesomevalidation.ValidationHolder;
import com.basgeekball.awesomevalidation.helper.RangeHelper;
import com.basgeekball.awesomevalidation.helper.SpanHelper;
import com.basgeekball.awesomevalidation.utility.ValidationCallback;
import com.basgeekball.awesomevalidation.validators.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class ColorationValidator
extends Validator {
    private int mColor = -65536;
    private HashMap<EditText, TextWatcher> mTextWatcherForEditText = new HashMap();
    private ValidationCallback mValidationCallback = new ValidationCallback(){

        @Override
        public void execute(ValidationHolder validationHolder, Matcher matcher) {
            ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
            if (matcher != null) {
                while (matcher.find()) {
                    arrayList.add((Pair<Integer, Integer>)Pair.create((Object)matcher.start(), (Object)(matcher.end() - 1)));
                }
            }
            final EditText editText = validationHolder.getEditText();
            ArrayList<Pair<Integer, Integer>> arrayList2 = RangeHelper.inverse(arrayList, editText.getText().length());
            SpanHelper.setColor(editText, ColorationValidator.this.mColor, arrayList2);
            editText.setError((CharSequence)validationHolder.getErrMsg());
            TextWatcher textWatcher = new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                }

                public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    editText.removeTextChangedListener((TextWatcher)this);
                    int n4 = editText.getSelectionStart();
                    int n5 = editText.getSelectionEnd();
                    SpanHelper.reset(editText);
                    editText.setSelection(n4, n5);
                }

                public void afterTextChanged(Editable editable) {
                }
            };
            editText.addTextChangedListener(textWatcher);
            ColorationValidator.this.mTextWatcherForEditText.put(editText, textWatcher);
        }
    };

    public void setColor(int n) {
        this.mColor = n;
    }

    @Override
    public boolean trigger() {
        this.halt();
        return this.checkFields(this.mValidationCallback);
    }

    @Override
    public void halt() {
        for (Object object2 : this.mValidationHolderList) {
            if (((ValidationHolder)object2).isSomeSortOfView()) {
                ((ValidationHolder)object2).resetCustomError();
                continue;
            }
            EditText editText = ((ValidationHolder)object2).getEditText();
            editText.setError(null);
            SpanHelper.reset(editText);
        }
        Object object = this.mTextWatcherForEditText.entrySet().iterator();
        while (object.hasNext()) {
            Object object2;
            object2 = (Map.Entry)object.next();
            ((EditText)object2.getKey()).removeTextChangedListener((TextWatcher)object2.getValue());
        }
        if (AwesomeValidation.isAutoFocusOnFirstFailureEnabled() && this.mValidationHolderList.size() > 0 && !((ValidationHolder)(object = (ValidationHolder)this.mValidationHolderList.get(0))).isSomeSortOfView()) {
            ((ValidationHolder)object).getEditText().requestFocus();
        }
    }
}

